/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.GamlFileExtension;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.util.file.GamaFileMetaData;
import gama.core.util.file.IFileMetaDataProvider;
import gama.gaml.interfaces.IGamlDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class GamlFileInfo
extends GamaFileMetaData
implements IGamlDescription {
    public static final String BATCH_PREFIX = "***";
    public static final String ERRORS = "errors detected";
    private final Collection<String> experiments;
    private final Collection<String> imports;
    private final Collection<String> uses;
    private final Collection<String> tags;
    public final boolean invalid;
    public final URI uri;

    public static Iterable<GamlFileInfo> getAllModels() {
        ArrayList<GamlFileInfo> arrayList = new ArrayList<GamlFileInfo>();
        try {
            GamlFileInfo.processContainer((IContainer)FileUtils.ROOT, arrayList);
        }
        catch (CoreException coreException) {}
        return arrayList;
    }

    static void processContainer(IContainer iContainer, List<GamlFileInfo> list) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        IFileMetaDataProvider iFileMetaDataProvider = GAMA.getGui().getMetaDataProvider();
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (iResource instanceof IContainer) {
                GamlFileInfo.processContainer((IContainer)iResource, list);
            } else if (iResource instanceof IFile && GamlFileExtension.isGaml(iResource.getName())) {
                GamlFileInfo gamlFileInfo = (GamlFileInfo)iFileMetaDataProvider.getMetaData(iResource, true, true);
                if (gamlFileInfo.uri == null || gamlFileInfo.uri.isEmpty() || gamlFileInfo.getName() == null) {
                    iFileMetaDataProvider.refreshAllMetaData();
                }
                list.add((GamlFileInfo)iFileMetaDataProvider.getMetaData(iResource, true, true));
            }
            ++n2;
        }
    }

    public GamlFileInfo(URI uRI, long l, Collection<String> collection, Collection<String> collection2, Collection<String> collection3, Collection<String> collection4) {
        super(l);
        this.uri = uRI;
        this.invalid = l == Long.MAX_VALUE;
        this.imports = collection;
        this.uses = collection2;
        this.experiments = collection3;
        this.tags = collection4;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public Collection<String> getImports() {
        return this.imports == null ? Collections.EMPTY_LIST : this.imports;
    }

    public Collection<String> getUses() {
        return this.uses == null ? Collections.EMPTY_LIST : this.uses;
    }

    public Collection<String> getTags() {
        return this.tags == null ? Collections.EMPTY_LIST : this.tags;
    }

    public Collection<String> getExperiments() {
        return this.experiments == null ? Collections.EMPTY_LIST : this.experiments;
    }

    public GamlFileInfo(String string) {
        super(string);
        String[] stringArray = this.split(string);
        this.uri = URI.createURI((String)stringArray[1]);
        List<String> list = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[2], (String)"@%@"));
        this.imports = list == null || list.isEmpty() || list.contains(null) ? null : list;
        List<String> list2 = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[3], (String)"@%@"));
        this.uses = list2 == null || list2.isEmpty() || list2.contains(null) ? null : list2;
        List<String> list3 = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[4], (String)"@%@"));
        this.experiments = list3 == null || list3.isEmpty() || list3.contains(null) ? null : list3;
        List<String> list4 = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[5], (String)"@%@"));
        this.tags = list4 == null || list4.isEmpty() || list4.contains(null) ? null : list4;
        this.invalid = "TRUE".equals(stringArray[6]);
    }

    @Override
    public String getSuffix() {
        int n;
        if (this.invalid) {
            return ERRORS;
        }
        int n2 = n = this.experiments == null ? 0 : this.experiments.size();
        if (n > 0) {
            return (String)(n == 1 ? "1 experiment" : n + " experiments");
        }
        return "no experiment";
    }

    @Override
    public void appendSuffix(StringBuilder stringBuilder) {
        int n;
        if (this.invalid) {
            stringBuilder.append(ERRORS);
            return;
        }
        int n2 = n = this.experiments == null ? 0 : this.experiments.size();
        if (n > 0) {
            stringBuilder.append(n).append(" experiment");
            if (n > 1) {
                stringBuilder.append("s");
            }
        } else {
            stringBuilder.append("no experiment");
        }
    }

    @Override
    public String toPropertyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toPropertyString()).append("_!_");
        stringBuilder.append(this.uri).append("_!_");
        stringBuilder.append(this.imports == null ? "" : String.join((CharSequence)"@%@", this.imports)).append("_!_");
        stringBuilder.append(this.uses == null ? "" : String.join((CharSequence)"@%@", this.uses)).append("_!_");
        stringBuilder.append(this.experiments == null ? "" : String.join((CharSequence)"@%@", this.experiments)).append("_!_");
        stringBuilder.append(this.tags == null ? "" : String.join((CharSequence)"@%@", this.tags)).append("_!_");
        stringBuilder.append(this.invalid ? "TRUE" : "FALSE").append("_!_");
        return stringBuilder.toString();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return new IGamlDescription.ConstantDoc("GAML model file with " + this.getSuffix());
    }

    @Override
    public String getName() {
        return URI.decode((String)this.uri.lastSegment()) + " " + String.valueOf(this.tags);
    }

    @Override
    public String getTitle() {
        return URI.decode((String)this.uri.lastSegment());
    }

    @Override
    public Consumer<IGamlDescription> getContextualAction() {
        return iGamlDescription -> GAMA.getGui().openFile(this.uri);
    }
}

