/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.finite_state_machine;

import com.google.common.collect.FluentIterable;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.architecture.finite_state_machine.FsmArchitecture;
import gama.gaml.architecture.finite_state_machine.FsmEnterStatement;
import gama.gaml.architecture.finite_state_machine.FsmExitStatement;
import gama.gaml.architecture.finite_state_machine.FsmTransitionStatement;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(symbols={"fsm"}, kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="initial", type={3}, optional=true, doc={@GamlAnnotations.doc(value="specifies whether the state is the initial one (default value = false)")}), @GamlAnnotations.facet(name="final", type={3}, optional=true, doc={@GamlAnnotations.doc(value="specifies whether the state is a final one (i.e. there is no transition from this state to another state) (default value= false)")}), @GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the state")})}, omissible="name")
@validator(value=StateValidator.class)
@GamlAnnotations.doc(value="A state, like a reflex, can contains several statements that can be executed at each time step by the agent.", usages={@GamlAnnotations.usage(value="Here is an exemple integrating 2 states and the statements in the FSM architecture:", examples={@GamlAnnotations.example(value="state s_init initial: true {", isExecutable=false), @GamlAnnotations.example(value="\tenter { ", isExecutable=false), @GamlAnnotations.example(value="\t\twrite \"Enter in\" + state;", isExecutable=false), @GamlAnnotations.example(value="\t}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="\twrite state;", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="\ttransition to: s1 when: (cycle > 2) {", isExecutable=false), @GamlAnnotations.example(value="\t\twrite \"transition s_init -> s1\";", isExecutable=false), @GamlAnnotations.example(value="\t}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="\texit {", isExecutable=false), @GamlAnnotations.example(value="\t\twrite \"EXIT from \"+state;", isExecutable=false), @GamlAnnotations.example(value="\t}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="state s1 {", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="\tenter {write 'Enter in '+state;}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="\twrite state;", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="\texit {write 'EXIT from '+state;}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"enter", "exit", "transition"})
public class FsmStateStatement
extends AbstractStatementSequence {
    static final List<String> ALLOWED_ARCHITECTURES = Arrays.asList("user_controlled", "user_first", "user_init", "user_last", "user_only");
    public static final String STATE_MEMORY = "state_memory";
    public static final String INITIAL = "initial";
    public static final String FINAL = "final";
    protected static final String STATE = "state";
    public static final String ENTER = "enter";
    public static final String EXIT = "exit";
    private FsmEnterStatement enterActions = null;
    private FsmExitStatement exitActions = null;
    List<FsmTransitionStatement> transitions = new ArrayList<FsmTransitionStatement>();
    private int transitionsSize;
    boolean isInitial;
    boolean isFinal;

    public FsmStateStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(this.getLiteral("name"));
        this.isInitial = Cast.asBool(null, this.getLiteral(INITIAL));
        this.isFinal = Cast.asBool(null, this.getLiteral(FINAL));
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        for (ISymbol iSymbol2 : iterable) {
            if (iSymbol2 instanceof FsmEnterStatement) {
                this.enterActions = (FsmEnterStatement)iSymbol2;
                continue;
            }
            if (iSymbol2 instanceof FsmExitStatement) {
                this.exitActions = (FsmExitStatement)iSymbol2;
                continue;
            }
            if (!(iSymbol2 instanceof FsmTransitionStatement)) continue;
            this.transitions.add((FsmTransitionStatement)iSymbol2);
        }
        this.transitionsSize = this.transitions.size();
        super.setChildren((Iterable<? extends ISymbol>)FluentIterable.from(iterable).filter(iSymbol -> iSymbol != this.enterActions && iSymbol != this.exitActions && !this.transitions.contains(iSymbol)));
    }

    protected boolean beginExecution(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        if (iScope.interrupted()) {
            return false;
        }
        Boolean bl = (Boolean)iAgent.getAttribute(ENTER);
        IMap iMap = (IMap)iAgent.getAttribute(STATE_MEMORY);
        if (bl.booleanValue() || iMap == null) {
            iMap = GamaMapFactory.create();
            iAgent.setAttribute(STATE_MEMORY, iMap);
        } else {
            iMap.forEach((string, object) -> iScope.addVarWithValue((String)string, object));
        }
        if (bl.booleanValue()) {
            if (this.enterActions != null) {
                iScope.execute(this.enterActions);
            }
            if (iAgent.dead()) {
                return false;
            }
            iAgent.setAttribute(ENTER, false);
        }
        return true;
    }

    protected Object bodyExecution(IScope iScope) throws GamaRuntimeException {
        return super.privateExecuteIn(iScope);
    }

    protected String evaluateTransitions(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        int n = 0;
        while (n < this.transitionsSize) {
            FsmTransitionStatement fsmTransitionStatement = this.transitions.get(n);
            if (fsmTransitionStatement.evaluatesTrueOn(iScope)) {
                String string = fsmTransitionStatement.getName();
                this.haltOn(iScope);
                iScope.execute(fsmTransitionStatement);
                iScope.setAgentVarValue(iAgent, STATE, string);
                return string;
            }
            ++n;
        }
        if (iAgent != null && !iAgent.dead()) {
            iScope.saveAllVarValuesIn((Map)iAgent.getAttribute(STATE_MEMORY));
        }
        return this.name;
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (!this.beginExecution(iScope)) {
            return null;
        }
        this.bodyExecution(iScope);
        return this.evaluateTransitions(iScope);
    }

    public void haltOn(IScope iScope) throws GamaRuntimeException {
        if (this.exitActions != null) {
            iScope.execute(this.exitActions);
        }
    }

    public FsmExitStatement getExitStatement() {
        return this.exitActions;
    }

    public boolean hasExitActions() {
        return this.exitActions != null;
    }

    public boolean isInitial() {
        return this.isInitial;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public static class StateValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
            SpeciesDescription speciesDescription = iDescription.getSpeciesContext();
            String string = iDescription.getKeyword();
            SkillDescription skillDescription = speciesDescription.getControl();
            if (!FsmArchitecture.class.isAssignableFrom(skillDescription.getJavaBase())) {
                if (FsmStateStatement.STATE.equals(string)) {
                    iDescription.error("A state can only be defined in an fsm-controlled or user-controlled species", "gaml.wrong.context.issue");
                    return;
                }
                if (skillDescription.getJavaBase() == FsmArchitecture.class) {
                    iDescription.error("A " + iDescription.getKeyword() + " can only be defined in a user-controlled species (one of" + String.valueOf(ALLOWED_ARCHITECTURES) + ")", "gaml.wrong.context.issue");
                    return;
                }
            }
            if (!IDescriptionValidator.Assert.nameIsValid(iDescription)) {
                return;
            }
            IExpression iExpression = iDescription.getFacetExpr(FsmStateStatement.INITIAL);
            if (IExpressionFactory.TRUE_EXPR.equals(iExpression)) {
                this.assertNoOther(iDescription, FsmStateStatement.INITIAL);
            } else {
                this.assertAtLeastOne(iDescription, FsmStateStatement.INITIAL);
            }
        }

        private void assertNoOther(IDescription iDescription, String string) {
            IDescription iDescription2 = iDescription.getEnclosingDescription();
            if (!(iDescription2 instanceof SpeciesDescription)) {
                return;
            }
            for (IDescription iDescription3 : ((SpeciesDescription)iDescription2).getBehaviors()) {
                IExpression iExpression;
                if (iDescription3.equals(iDescription) || !FsmStateStatement.STATE.equals(iDescription3.getKeyword()) || !IExpressionFactory.TRUE_EXPR.equals(iExpression = iDescription3.getFacetExpr(string))) continue;
                String string2 = "Only one " + string + " state is allowed.";
                iDescription3.error(string2, "gaml.duplicate.definition.issue", string, "true");
            }
        }

        private void assertAtLeastOne(IDescription iDescription, String string) {
            IDescription iDescription2 = iDescription.getEnclosingDescription();
            if (!(iDescription2 instanceof SpeciesDescription)) {
                return;
            }
            for (IDescription object2 : ((SpeciesDescription)iDescription2).getBehaviors()) {
                IExpression iExpression;
                String string2 = object2.getKeyword();
                if (!FsmStateStatement.STATE.equals(string2) && !"user_panel".equals(string2) || (iExpression = object2.getFacetExpr(string)) == null || !IExpressionFactory.TRUE_EXPR.equals(iExpression)) continue;
                return;
            }
            String string3 = "No " + string + " state defined";
            iDescription2.error(string3, "gaml.missing.definition.issue", iDescription2.getUnderlyingElement(), iDescription.getKeyword(), string, "true");
        }
    }
}

