/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.data;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.ICollector;
import gama.core.util.IList;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.function.Predicate;

public class ListExpression
extends AbstractExpression
implements IOperator {
    final IExpression[] elements;

    public static IExpression create(Iterable<? extends IExpression> iterable) {
        return new ListExpression(iterable);
    }

    public static IExpression create(IExpression ... iExpressionArray) {
        return new ListExpression(iExpressionArray);
    }

    ListExpression(IExpression ... iExpressionArray) {
        this.elements = iExpressionArray;
        this.type = Types.LIST.of(GamaType.findCommonType(this.elements, 0));
    }

    ListExpression(Iterable<? extends IExpression> iterable) {
        this((IExpression[])Iterables.toArray(iterable, IExpression.class));
    }

    public IExpression[] getElements() {
        return this.elements;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                if (!iExpression.isConst()) {
                    return false;
                }
                Object object2 = iExpression.getConstValue();
                if (object.equals(object2)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        ListExpression listExpression = new ListExpression(Arrays.asList(this.elements));
        int n = 0;
        while (n < this.elements.length) {
            IExpression iExpression = this.elements[n];
            if (iExpression != null) {
                listExpression.elements[n] = iExpression.resolveAgainst(iScope);
            }
            ++n;
        }
        return listExpression;
    }

    @Override
    public IList _value(IScope iScope) throws GamaRuntimeException {
        IList iList = GamaListFactory.create(this.getGamlType().getContentType());
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iList.add(iExpression.value(iScope));
            }
            ++n2;
        }
        return iList;
    }

    public String toString() {
        return Arrays.toString(this.elements);
    }

    @Override
    public boolean isConst() {
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isConst()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        ListExpression.surround(stringBuilder, '[', ']', this.elements);
        return stringBuilder.toString();
    }

    @Override
    public String getTitle() {
        return "literal list of type " + this.getGamlType().getTitle();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return new IGamlDescription.ConstantDoc("Constant " + this.isConst() + "<br>Contains elements of type " + this.type.getContentType().getTitle());
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iExpression.collectMetaInformation(gamlProperties);
            }
            ++n2;
        }
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iExpression.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
            }
            ++n2;
        }
    }

    @Override
    public boolean isContextIndependant() {
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isContextIndependant()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isAllowedInParameters() {
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isAllowedInParameters()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void visitSuboperators(IOperator.IOperatorVisitor iOperatorVisitor) {
        IExpression[] iExpressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression iExpression = iExpressionArray[n2];
            if (iExpression instanceof IOperator) {
                iOperatorVisitor.visit((IOperator)iExpression);
            }
            ++n2;
        }
    }

    @Override
    public IExpression arg(int n) {
        if (n < 0 || n > this.elements.length) {
            return null;
        }
        return this.elements[n];
    }

    @Override
    public OperatorProto getPrototype() {
        return null;
    }

    @Override
    public boolean findAny(Predicate<IExpression> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        if (this.elements != null) {
            IExpression[] iExpressionArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression.findAny(predicate)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

