/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.interfaces;

import gama.annotations.precompiler.GamlProperties;
import gama.gaml.interfaces.INamed;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public interface IGamlDescription
extends INamed {
    public static final Doc EMPTY_DOC = new ConstantDoc("");

    default public String getTitle() {
        return this.getName();
    }

    default public Doc getDocumentation() {
        return EMPTY_DOC;
    }

    default public String getDefiningPlugin() {
        return null;
    }

    default public void collectMetaInformation(GamlProperties gamlProperties) {
        gamlProperties.put("plugins", this.getDefiningPlugin());
    }

    default public Consumer<IGamlDescription> getContextualAction() {
        return null;
    }

    public record ConstantDoc(String value) implements Doc
    {
        @Override
        public String toString() {
            return this.value;
        }
    }

    public static interface Doc {
        public String toString();

        default public Doc get(String string) {
            return EMPTY_DOC;
        }

        default public Doc append(String string) {
            return this;
        }

        default public Doc append(Character c) {
            return this;
        }

        default public Doc prepend(String string) {
            return this;
        }

        default public void set(String string, String string2, Doc doc2) {
        }
    }

    public static class RegularDoc
    implements Doc {
        final StringBuilder builder;
        final Map<String, Map<String, Doc>> subdocs = new LinkedHashMap<String, Map<String, Doc>>();

        public RegularDoc(CharSequence charSequence) {
            this.builder = new StringBuilder(charSequence);
        }

        public RegularDoc() {
            this("");
        }

        @Override
        public Doc append(String string) {
            this.builder.append(string);
            return this;
        }

        @Override
        public Doc append(Character c) {
            this.builder.append(c);
            return this;
        }

        @Override
        public Doc prepend(String string) {
            this.builder.insert(0, string);
            return this;
        }

        @Override
        public String toString() {
            if (this.subdocs.isEmpty()) {
                return this.builder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder(this.builder.toString());
            for (String string2 : this.subdocs.keySet()) {
                stringBuilder.append("<hr/>").append(string2).append("<br/><ul>");
                this.subdocs.get(string2).forEach((string, doc2) -> stringBuilder.append("<li><b>").append((String)string).append("</b>: ").append(doc2.toString()));
                stringBuilder.append("</ul><br/>");
            }
            return stringBuilder.toString();
        }

        @Override
        public void set(String string, String string2, Doc doc2) {
            Map<String, Doc> map = this.subdocs.get(string);
            if (map == null) {
                map = new LinkedHashMap<String, Doc>();
                this.subdocs.put(string, map);
            }
            map.put(string2, doc2);
        }

        @Override
        public Doc get(String string) {
            for (String string2 : this.subdocs.keySet()) {
                Doc doc2 = this.subdocs.get(string2).get(string);
                if (doc2 == null) continue;
                return doc2;
            }
            return EMPTY_DOC;
        }
    }
}

