/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.IField;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.types.GamaFieldType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import one.util.streamex.IntStreamEx;

public class Random {
    static GamaPoint NULL_POINT = new GamaPoint(0.0, 0.0, 0.0);
    private static final short[] SUPPLY = IntStreamEx.rangeClosed((int)0, (int)255).toShortArray();
    private static final int[] GRADIENT;
    private static final double F2;
    private static final double G2;

    static {
        int[] nArray = new int[24];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = -1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = 1;
        nArray[10] = -1;
        nArray[12] = 1;
        nArray[14] = -1;
        nArray[17] = 1;
        nArray[19] = -1;
        nArray[21] = 1;
        nArray[23] = -1;
        GRADIENT = nArray;
        F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
        G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
    }

    public static RandomUtils RANDOM(IScope iScope) {
        RandomUtils randomUtils = iScope.getRandom();
        if (randomUtils == null) {
            randomUtils = new RandomUtils();
        }
        return randomUtils;
    }

    @GamlAnnotations.operator(value={"truncated_gauss", "TGauss"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="A random value from a normally distributed random variable in the interval ]mean - standardDeviation; mean + standardDeviation[.", usages={@GamlAnnotations.usage(value="when the operand is a point, it is read as {mean, standardDeviation}")}, examples={@GamlAnnotations.example(value="truncated_gauss ({0, 0.3})", equals="a float between -0.3 and 0.3", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "weibull_rnd", "gamma_trunc_rnd", "weibull_trunc_rnd", "lognormal_trunc_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; TGauss({0,0.3}) = 0.10073201959421514")
    public static Double opTGauss(IScope iScope, GamaPoint gamaPoint) {
        return Random.opTGauss(iScope, GamaListFactory.wrap((IType)Types.FLOAT, gamaPoint.x, gamaPoint.y));
    }

    @GamlAnnotations.operator(value={"truncated_gauss", "TGauss"}, category={"Random operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the operand is a list, only the two first elements are taken into account as [mean, standardDeviation]"), @GamlAnnotations.usage(value="when truncated_gauss is called with a list of only one element mean, it will always return 0.0")}, examples={@GamlAnnotations.example(value="truncated_gauss ([0.5, 0.0])", equals="0.5")}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "weibull_rnd", "gamma_trunc_rnd", "weibull_trunc_rnd", "lognormal_trunc_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; truncated_gauss ([0.5, 0.2]) = 0.5671546797294768")
    public static Double opTGauss(IScope iScope, IList iList) {
        if (iList.size() < 2) {
            return 0.0;
        }
        double d = Cast.asFloat(iScope, iList.get(0));
        double d2 = Cast.asFloat(iScope, iList.get(1));
        double d3 = 0.0;
        while ((d3 = Random.RANDOM(iScope).createGaussian(d, d2 / 2.0)) > d + d2 || d3 < d - d2) {
        }
        return d3;
    }

    @GamlAnnotations.operator(value={"gauss", "gauss_rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="The operator can be used with an operand of type point {meand,standardDeviation}.", usages={@GamlAnnotations.usage(value="when the operand is a point, it is read as {mean, standardDeviation}")}, examples={@GamlAnnotations.example(value="gauss({0,0.3})", equals="0.22354", test=false)}, see={"binomial", "gamma_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; gauss({0.5, 0.2}) = 0.6343093594589535")
    public static Double opGauss(IScope iScope, GamaPoint gamaPoint) {
        double d = gamaPoint.x;
        double d2 = gamaPoint.y;
        return Random.RANDOM(iScope).createGaussian(d, d2);
    }

    @GamlAnnotations.operator(value={"gauss", "gauss_rnd"}, category={"Random operators"}, concept={})
    @GamlAnnotations.doc(value="A value from a normally distributed random variable with expected value (mean as first operand) and variance (standardDeviation as second operand). The probability density function of such a variable is a Gaussian.", usages={@GamlAnnotations.usage(value="when standardDeviation value is 0.0, it always returns the mean value")}, examples={@GamlAnnotations.example(value="gauss(0,0.3)", equals="0.22354", test=false)}, see={"binomial", "gamma_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; gauss(0.5, 0.2) = 0.6343093594589535")
    public static Double opGauss(IScope iScope, double d, double d2) {
        return Random.RANDOM(iScope).createGaussian(d, d2);
    }

    @GamlAnnotations.operator(value={"skew_gauss"}, category={"Random operators"}, concept={})
    @GamlAnnotations.doc(value="A value from a skew normally distributed random variable with min value (the minimum skewed value possible), max value (the maximum skewed value possible), skew (the degree to which the values cluster around the mode of the distribution; higher values mean tighter clustering) and bias (the tendency of the mode to approach the min, max or midpoint value; positive values bias toward max, negative values toward min).The algorithm was taken from http://stackoverflow.com/questions/5853187/skewing-java-random-number-generation-toward-a-certain-number", examples={@GamlAnnotations.example(value="skew_gauss(0.0, 1.0, 0.7,0.1)", equals="0.1729218460343077", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; skew_gauss(0.0, 1.0, 0.7,0.1) = 0.7425668006838585")
    public static Double opGauss(IScope iScope, double d, double d2, double d3, double d4) {
        double d5 = d2 - d;
        double d6 = d + d5 / 2.0;
        double d7 = Random.RANDOM(iScope).createGaussian(0.0, 1.0);
        double d8 = Math.exp(d4);
        return d6 + d5 * (d8 / (d8 + Math.exp(-d7 / d3)) - 0.5);
    }

    @GamlAnnotations.operator(value={"poisson"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="A value from a random variable following a Poisson distribution (with the positive expected number of occurence lambda as operand).", comment="The Poisson distribution is a discrete probability distribution that expresses the probability of a given number of events occurring in a fixed interval of time and/or space if these events occur with a known average rate and independently of the time since the last event, cf. Poisson distribution on Wikipedia.", examples={@GamlAnnotations.example(value="poisson(3.5)", equals="a random positive integer", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; poisson(3.5) = 6")
    public static Integer opPoisson(IScope iScope, Double d) {
        RandomUtils randomUtils = Random.RANDOM(iScope);
        int n = 0;
        double d2 = 0.0;
        while (!((d2 -= Math.log(randomUtils.next()) / d) > 1.0)) {
            ++n;
        }
        return n;
    }

    @GamlAnnotations.operator(value={"binomial"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="A value from a random variable following a binomial distribution. The operands represent the number of experiments n and the success probability p.", comment="The binomial distribution is the discrete probability distribution of the number of successes in a sequence of n independent yes/no experiments, each of which yields success with probability p, cf. Binomial distribution on Wikipedia.", examples={@GamlAnnotations.example(value="binomial(15,0.6)", equals="a random positive integer", test=false)}, see={"gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; binomial(15,0.6) = 9")
    public static Integer opBinomial(IScope iScope, Integer n, Double d) {
        double d2 = d;
        StringBuilder stringBuilder = new StringBuilder(64);
        double d3 = 0.5;
        while (d2 > 0.0) {
            if (d2 >= d3) {
                stringBuilder.append('1');
                d2 -= d3;
            } else {
                stringBuilder.append('0');
            }
            d3 /= 2.0;
        }
        BitString bitString = new BitString(stringBuilder.toString());
        RandomUtils randomUtils = Random.RANDOM(iScope);
        int n2 = n;
        int n3 = 0;
        int n4 = bitString.getLength() - 1;
        while (n2 > 0 && n4 >= 0) {
            BitString bitString2 = new BitString(n2, randomUtils.getGenerator());
            int n5 = bitString2.countSetBits();
            n2 -= n5;
            if (bitString.getBit(n4)) {
                n3 += n5;
            }
            --n4;
        }
        return n3;
    }

    @GamlAnnotations.operator(value={"shuffle"}, content_type=-299, category={"Random operators", "Containers-related operators"}, concept={"random"})
    @GamlAnnotations.doc(value="Returns a new list containing the randomly shuffled elements of the container.", usages={@GamlAnnotations.usage(value="if the operand is empty, returns an empty list (or string, matrix)")}, examples={@GamlAnnotations.example(value="shuffle ([12, 13, 14])", equals="[14,12,13] (for example)", test=false)}, see={"reverse"})
    @GamlAnnotations.test(value="seed <- 1.0; shuffle ([12, 13, 14]) = [12,13,14]")
    public static IList opShuffle(IScope iScope, IContainer iContainer) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaListFactory.create(iContainer == null ? Types.NO_TYPE : iContainer.getGamlType().getContentType());
        }
        IValue iValue = iContainer.listValue(iScope, iContainer.getGamlType().getContentType(), false).copy(iScope);
        Random.RANDOM(iScope).shuffleInPlace((List)((Object)iValue));
        return iValue;
    }

    @GamlAnnotations.operator(value={"shuffle"}, content_type=-299, category={"Random operators", "Matrix-related operators"}, concept={"random"})
    @GamlAnnotations.doc(value="Returns a new matrix of the same size as the operand, with randomly shuffled elements", examples={@GamlAnnotations.example(value="shuffle (matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]]))", equals="matrix([[\"c12\",\"c21\",\"c11\"],[\"c13\",\"c22\",\"c23\"]]) (for example)", test=false)})
    @GamlAnnotations.test(value="seed <- 1.0; shuffle (matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]])) = matrix([[\"c13\",\"c21\",\"c22\"],[\"c11\",\"c23\",\"c12\"]])")
    public static IMatrix opShuffle(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        IMatrix iMatrix2 = iMatrix.copy(iScope);
        iMatrix2.shuffleWith(Random.RANDOM(iScope));
        return iMatrix2;
    }

    @GamlAnnotations.operator(value={"shuffle"}, content_type=4, category={"Random operators", "Strings-related operators"}, concept={"random"})
    @GamlAnnotations.doc(value="Returns a new string with randomly shuffled letters", examples={@GamlAnnotations.example(value="shuffle ('abc')", equals="'bac' (for example)", test=false)})
    public static String opShuffle(IScope iScope, String string) {
        return Random.RANDOM(iScope).shuffle(string);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value in a range (the type value depends on the operand type): when called with an integer, it returns a random integer in the interval [0, operand]", masterDoc=true, comment="to obtain a probability between 0 and 1, use the expression (rnd n) / n, where n is used to indicate the precision", usages={}, examples={@GamlAnnotations.example(value="rnd (2)", equals="0, 1 or 2", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd(10) = 8")
    public static Integer opRnd(IScope iScope, Integer n) {
        return Random.opRnd(iScope, 0, n);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="a random integer in the interval [first operand, second operand]", examples={@GamlAnnotations.example(value="rnd (2, 4)", equals="2, 3 or 4", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd(1,5) = 4")
    public static Integer opRnd(IScope iScope, Integer n, Integer n2) {
        RandomUtils randomUtils = Random.RANDOM(iScope);
        return randomUtils.between(n, n2);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="a random integer in the interval [first operand, second operand], constrained by a step given by the last operand", examples={@GamlAnnotations.example(value="rnd (2, 12, 4)", equals="2, 6 or 10", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd (2, 12, 4) = 10")
    public static Integer opRnd(IScope iScope, Integer n, Integer n2, Integer n3) {
        RandomUtils randomUtils = Random.RANDOM(iScope);
        return randomUtils.between(n, n2, n3);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="a random float in the interval [first operand, second operand]", examples={@GamlAnnotations.example(value="rnd (2.0, 4.0)", equals="a float number between 2.0 and 4.0", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd (2.0, 4.0) = 3.548024306042759")
    public static Double opRnd(IScope iScope, Double d, Double d2) {
        RandomUtils randomUtils = Random.RANDOM(iScope);
        return randomUtils.between(d, d2);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="a random float in the interval [first operand, second operand] constrained by the last operand (step)", examples={@GamlAnnotations.example(value="rnd (2.0, 4.0, 0.5)", equals="a float number between 2.0 and 4.0 every 0.5", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd (2.0, 4.0, 0.5) = 3.5")
    public static Double opRnd(IScope iScope, Double d, Double d2, Double d3) {
        RandomUtils randomUtils = Random.RANDOM(iScope);
        return randomUtils.between(d, d2, d3);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="a random point in the interval [first operand, second operand]", examples={@GamlAnnotations.example(value="rnd ({2.0, 4.0}, {2.0, 5.0, 10.0})", equals="a point with x = 2.0, y between 2.0 and 4.0 and z between 0.0 and 10.0", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd ({2.0, 4.0}, {2.0, 5.0, 10.0}) = {2.0,4.785039740667429,5.087825199078746}")
    public static GamaPoint opRnd(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        double d = Random.opRnd(iScope, gamaPoint.x, gamaPoint2.x);
        double d2 = Random.opRnd(iScope, gamaPoint.y, gamaPoint2.y);
        double d3 = Random.opRnd(iScope, gamaPoint.z, gamaPoint2.z);
        return new GamaPoint(d, d2, d3);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="a random point in the interval [first operand, second operand], constained by the step provided by the last operand", examples={@GamlAnnotations.example(value="rnd ({2.0, 4.0}, {2.0, 5.0, 10.0}, 1)", equals="a point with x = 2.0, y equal to 2.0, 3.0 or 4.0 and z between 0.0 and 10.0 every 1.0", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd ({2.0, 4.0}, {2.0, 5.0, 10.0},1) = {2.0,5.0,5.0}")
    public static GamaPoint opRnd(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d) {
        double d2 = Random.opRnd(iScope, gamaPoint.x, gamaPoint2.x, d);
        double d3 = Random.opRnd(iScope, gamaPoint.y, gamaPoint2.y, d);
        double d4 = Random.opRnd(iScope, gamaPoint.z, gamaPoint2.z, d);
        return new GamaPoint(d2, d3, d4);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the operand is a point, returns a point with three random float ordinates, each in the interval [0, ordinate of argument]")}, examples={@GamlAnnotations.example(value="rnd ({2.5,3, 0.0})", equals="{x,y} with x in [0.0,2.0], y in [0.0,3.0], z = 0.0", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd ({2.5,3, 1.0}) = {1.935030382553449,2.3551192220022856,0.5087825199078746}")
    public static GamaPoint opRnd(IScope iScope, GamaPoint gamaPoint) {
        return Random.opRnd(iScope, NULL_POINT, gamaPoint);
    }

    @GamlAnnotations.operator(value={"rnd"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the operand is a float, returns an uniformly distributed float random number in [0.0, to]")}, examples={@GamlAnnotations.example(value="rnd(3.4)", equals="a random float between 0.0 and 3.4", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "skew_gauss", "truncated_gauss", "weibull_rnd"})
    @GamlAnnotations.test(value=" seed <- 1.0; rnd(100) = 78")
    public static Double opRnd(IScope iScope, Double d) {
        return Random.opRnd(iScope, 0.0, d);
    }

    @GamlAnnotations.operator(value={"flip"}, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="true or false given the probability represented by the operand", usages={@GamlAnnotations.usage(value="flip 0 always returns false, flip 1 true")}, examples={@GamlAnnotations.example(value="flip (0.66666)", equals="2/3 chances to return true.", test=false)}, see={"rnd"})
    @GamlAnnotations.test(value="flip(0) = false and flip(1) = true")
    public static Boolean opFlip(IScope iScope, Double d) {
        if (d > Random.RANDOM(iScope).between(0.0, 1.0)) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"rnd_choice"}, concept={"random"})
    @GamlAnnotations.doc(value="returns an index of the given list with a probability following the (normalized) distribution described in the list (a form of lottery)", examples={@GamlAnnotations.example(value="rnd_choice([0.2,0.5,0.3])", equals="2/10 chances to return 0, 5/10 chances to return 1, 3/10 chances to return 2", test=false)}, see={"rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd_choice([0.2,0.5,0.3]) = 2")
    public static Integer opRndChoice(IScope iScope, IList iList) {
        IList iList2 = GamaListFactory.create(Types.FLOAT);
        double d = 0.0;
        Double d2 = 0.0;
        for (Object e : iList) {
            Double d3 = Cast.asFloat(iScope, e);
            if (d3 < 0.0) {
                d2 = Math.max(d2, Math.abs(d3));
            }
            iList2.add(d3);
            d += d3.doubleValue();
        }
        int n = iList2.size();
        if (d2 > 0.0) {
            d += d2 * (double)n;
        }
        if (d == 0.0) {
            throw GamaRuntimeException.create(new RuntimeException("Distribution elements should not be all equal to 0"), iScope);
        }
        int n2 = 0;
        while (n2 < n) {
            iList2.set(n2, ((Double)iList2.get(n2) + d2) / d);
            ++n2;
        }
        double d4 = Random.RANDOM(iScope).between(0.0, 1.0);
        int n3 = 0;
        while (n3 < iList.size()) {
            if ((d4 -= ((Double)iList2.get(n3)).doubleValue()) <= 0.0) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    @GamlAnnotations.operator(value={"rnd_choice"}, concept={"random"}, type=-399)
    @GamlAnnotations.doc(value="returns a key from the map with a probability following the (normalized) distribution described in map values (a form of lottery)", examples={@GamlAnnotations.example(value="rnd_choice([\"toto\"::0.2,\"tata\"::0.5,\"tonton\"::0.3])", equals="2/10 chances to return \"toto\", 5/10 chances to return \"tata\", 3/10 chances to return \"tonton\"", test=false)}, see={"rnd"})
    @GamlAnnotations.test(value="seed <- 1.0; rnd_choice([\"toto\"::0.2,\"tata\"::0.5,\"tonton\"::0.3]) = \"tonton\"")
    public static <T> T opRndCoice(IScope iScope, IMap<T, ?> iMap) {
        IList<T> iList = iMap.getKeys();
        IList iList2 = GamaListFactory.create(Types.FLOAT);
        double d = 0.0;
        for (Object e : iList) {
            Object v = iMap.get(e);
            Double d2 = Cast.asFloat(iScope, v);
            if (d2 < 0.0) {
                throw GamaRuntimeException.create(new RuntimeException("Distribution elements should be positive."), iScope);
            }
            iList2.add(d2);
            d += d2.doubleValue();
        }
        if (d == 0.0) {
            throw GamaRuntimeException.create(new RuntimeException("Distribution elements should not be all equal to 0"), iScope);
        }
        int n = 0;
        while (n < iList2.size()) {
            iList2.set(n, (Double)iList2.get(n) / d);
            ++n;
        }
        double d3 = Random.RANDOM(iScope).between(0.0, 1.0);
        int n2 = 0;
        while (n2 < iMap.size()) {
            if ((d3 -= ((Double)iList2.get(n2)).doubleValue()) <= 0.0) {
                return (T)iList.get(n2);
            }
            ++n2;
        }
        throw GamaRuntimeException.create(new RuntimeException("Malformed distribution"), iScope);
    }

    @GamlAnnotations.operator(value={"sample"}, type=-199, content_type=-299, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="takes a sample of the specified size from the elements of x using either with or without replacement", examples={@GamlAnnotations.example(value="sample([2,10,1],2,false)", equals="[10,1]", test=false)})
    @GamlAnnotations.test(value="seed <- 1.0; list l1 <- sample([2,10,1],2,false);\r\n\t\tlist l2 <-  [1,10];l1 = l2")
    public static IList opSample(IScope iScope, IList iList, int n, boolean bl) {
        if ((double)n < 0.0) {
            throw GamaRuntimeException.create(new RuntimeException("The number of elements of the sample should be positive."), iScope);
        }
        IList iList2 = GamaListFactory.create(iList.getGamlType());
        IList iList3 = bl ? iList : iList.copy(iScope);
        while (iList2.size() < n && !iList3.isEmpty()) {
            int n2 = iScope.getRandom().between(0, iList3.size() - 1);
            if (bl) {
                iList2.add(iList3.get(n2));
                continue;
            }
            iList2.add(iList3.remove(n2));
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"sample"}, type=-199, content_type=-299, category={"Random operators"}, concept={})
    @GamlAnnotations.doc(value="takes a sample of the specified size from the elements of x using either with or without replacement with given weights", examples={@GamlAnnotations.example(value="sample([2,10,1],2,false,[0.1,0.7,0.2])", equals="[10,2]", test=false)})
    @GamlAnnotations.test(value="seed <- 1.0;\r\n\t\tlist l1 <- sample([2,10,1],2,false,[0.1,0.7,0.2]);\r\n\t\tlist l2 <-  [10,1];\r\n\t\tl1 = l2 ")
    public static IList opSample(IScope iScope, IList iList, int n, boolean bl, IList iList2) {
        if (iList2 == null) {
            return Random.opSample(iScope, iList, n, bl);
        }
        if ((double)n < 0.0) {
            throw GamaRuntimeException.create(new RuntimeException("The number of elements of the sample should be positive."), iScope);
        }
        if (iList2.size() != iList.size()) {
            throw GamaRuntimeException.create(new RuntimeException("The number of weights should be equal to the number of elements of the source."), iScope);
        }
        IList iList3 = GamaListFactory.create(iList.getGamlType());
        IList iList4 = bl ? iList : iList.copy(iScope);
        IList iList5 = bl ? iList2 : iList2.copy(iScope);
        while (iList3.size() < n && !iList4.isEmpty()) {
            int n2 = Random.opRndChoice(iScope, iList5);
            if (bl) {
                iList3.add(iList4.get(n2));
                continue;
            }
            iList3.add(iList4.remove(n2));
            iList5.remove(n2);
        }
        return iList3;
    }

    @GamlAnnotations.operator(value={"generate_terrain"})
    @GamlAnnotations.doc(value="This operator allows to generate a pseudo-terrain using a simplex noise generator. Its usage is kept simple: it takes first a seed (random or not), then the dimensions (width and height) of the field to generate, then a level (between 0 and 1) of details (which actually determines the number of passes to make), then the value (between 0 and 1) of smoothess, with 0 being completely rought and 1 super smooth, and finally the value (between 0 and 1) of scattering, with 0 building maps in 'one piece' and 1 completely scattered ones.")
    public static IField generateTerrain(IScope iScope, int n, int n2, int n3, double d, double d2, double d3) {
        double d4;
        double d5;
        RandomUtils randomUtils = new RandomUtils(Double.valueOf(n), "mersenne");
        short[] sArray = (short[])SUPPLY.clone();
        randomUtils.shuffleInPlace(sArray);
        short[] sArray2 = new short[512];
        short[] sArray3 = new short[512];
        int n4 = 0;
        while (n4 < 512) {
            short s;
            sArray2[n4] = s = sArray[n4 & 0xFF];
            sArray3[n4] = (short)(s % 12);
            ++n4;
        }
        double d6 = d2 <= 0.0 ? 1.0 : (d5 = d2 >= 1.0 ? 0.0 : 1.0 - d2);
        double d7 = d3 <= 0.0 ? 1.0E-4 : (d4 = d3 >= 1.0 ? 0.01 : d3 / 100.0);
        int n5 = d < 0.1 ? 1 : (d >= 1.0 ? 10 : (int)(d * 10.0));
        GamaField gamaField = (GamaField)GamaFieldType.buildField(iScope, n2, n3);
        double[] dArray = gamaField.getMatrix();
        double d8 = 1.0;
        double d9 = 0.0;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                while (n8 < n3) {
                    double d10;
                    double d11;
                    double d12;
                    int n9;
                    int n10;
                    double d13;
                    double d14;
                    int n11;
                    double d15;
                    double d16 = (double)n7 * d4;
                    double d17 = (double)n8 * d4;
                    double d18 = (d16 + d17) * F2;
                    int n12 = Maths.floor(d16 + d18);
                    double d19 = (double)n12 - (d15 = (double)(n12 + (n11 = Maths.floor(d17 + d18))) * G2);
                    double d20 = d16 - d19;
                    if (d20 > (d14 = d17 - (d13 = (double)n11 - d15))) {
                        n10 = 1;
                        n9 = 0;
                    } else {
                        n10 = 0;
                        n9 = 1;
                    }
                    double d21 = d20 - (double)n10 + G2;
                    double d22 = d14 - (double)n9 + G2;
                    double d23 = d20 - 1.0 + 2.0 * G2;
                    double d24 = d14 - 1.0 + 2.0 * G2;
                    int n13 = n12 & 0xFF;
                    int n14 = n11 & 0xFF;
                    short s = sArray3[n13 + sArray2[n14]];
                    short s2 = sArray3[n13 + n10 + sArray2[n14 + n9]];
                    short s3 = sArray3[n13 + 1 + sArray2[n14 + 1]];
                    double d25 = 0.5 - d20 * d20 - d14 * d14;
                    if (d25 < 0.0) {
                        d12 = 0.0;
                    } else {
                        d25 *= d25;
                        d12 = d25 * d25 * ((double)GRADIENT[s] * d20 + (double)GRADIENT[s + 1] * d14);
                    }
                    double d26 = 0.5 - d21 * d21 - d22 * d22;
                    if (d26 < 0.0) {
                        d11 = 0.0;
                    } else {
                        d26 *= d26;
                        d11 = d26 * d26 * ((double)GRADIENT[s2] * d21 + (double)GRADIENT[s2 + 1] * d22);
                    }
                    double d27 = 0.5 - d23 * d23 - d24 * d24;
                    if (d27 < 0.0) {
                        d10 = 0.0;
                    } else {
                        d27 *= d27;
                        d10 = d27 * d27 * ((double)GRADIENT[s3] * d23 + (double)GRADIENT[s3 + 1] * d24);
                    }
                    int n15 = n8 * n2 + n7;
                    dArray[n15] = dArray[n15] + 70.0 * (d12 + d11 + d10) * d8;
                    ++n8;
                }
                ++n7;
            }
            d4 *= 2.0;
            d9 += d8;
            d8 *= d5;
            ++n6;
        }
        n6 = 0;
        while (n6 < dArray.length) {
            int n16 = n6++;
            dArray[n16] = dArray[n16] / d9;
        }
        return gamaField;
    }

    private static class BitString {
        private static final int WORD_LENGTH = 32;
        private final int length;
        private final int[] data;

        public BitString(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Length must be non-negative.");
            }
            this.length = n;
            this.data = new int[(n + 32 - 1) / 32];
        }

        public BitString(int n, java.util.Random random) {
            this(n);
            int n2 = 0;
            while (n2 < this.data.length) {
                this.data[n2] = random.nextInt();
                ++n2;
            }
            n2 = n % 32;
            if (n2 < 32) {
                int n3 = 32 - n2;
                int n4 = -1 >>> n3;
                int n5 = this.data.length - 1;
                this.data[n5] = this.data[n5] & n4;
            }
        }

        public BitString(String string) {
            this(string.length());
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '1') {
                    this.setBit(string.length() - (n + 1), true);
                } else if (string.charAt(n) != '0') {
                    throw new IllegalArgumentException("Illegal character at position " + n);
                }
                ++n;
            }
        }

        public int getLength() {
            return this.length;
        }

        public boolean getBit(int n) {
            this.assertValidIndex(n);
            int n2 = n / 32;
            int n3 = n % 32;
            return (this.data[n2] & 1 << n3) != 0;
        }

        public void setBit(int n, boolean bl) {
            this.assertValidIndex(n);
            int n2 = n / 32;
            int n3 = n % 32;
            if (bl) {
                int n4 = n2;
                this.data[n4] = this.data[n4] | 1 << n3;
            } else {
                int n5 = n2;
                this.data[n5] = this.data[n5] & ~(1 << n3);
            }
        }

        private void assertValidIndex(int n) {
            if (n >= this.length || n < 0) {
                throw new IndexOutOfBoundsException("Invalid index: " + n + " (length: " + this.length + ")");
            }
        }

        public int countSetBits() {
            int n = 0;
            int[] nArray = this.data;
            int n2 = this.data.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                while (n4 != 0) {
                    n4 &= n4 - 1;
                    ++n;
                }
                ++n3;
            }
            return n;
        }
    }
}

