/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.species;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.gaml.architecture.IArchitecture;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Containers;
import gama.gaml.statements.ActionStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.UserCommandStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="actions", type=5, of=4, doc={@GamlAnnotations.doc(value="A list of the names of the actions defined in this species")}), @GamlAnnotations.variable(name="aspects", type=5, of=4, doc={@GamlAnnotations.doc(value="A list of the names of the aspects defined in this species")}), @GamlAnnotations.variable(name="attributes", type=5, of=4, doc={@GamlAnnotations.doc(value="A list of the names of the attributes of this species")}), @GamlAnnotations.variable(name="parent", type=14, doc={@GamlAnnotations.doc(value="The parent (if any) of this species")}), @GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="The name of the species")}), @GamlAnnotations.variable(name="subspecies", type=5, of=14, doc={@GamlAnnotations.doc(value="A list of the names of subspecies of this species")}), @GamlAnnotations.variable(name="microspecies", type=5, of=4, doc={@GamlAnnotations.doc(value="A list of the names of the micro-species declared inside this species")}), @GamlAnnotations.variable(name="population", type=5, of=-299, doc={@GamlAnnotations.doc(value="The population that corresponds to this species in an instance of its host")})})
public interface ISpecies
extends ISymbol,
IAddressableContainer<Integer, IAgent, Integer, IAgent>,
IPopulationSet<IAgent> {
    public static final String stepActionName = "_step_";
    public static final String initActionName = "_init_";
    public static final String POPULATION = "population";
    public static final String SUBSPECIES = "subspecies";
    public static final String MICROSPECIES = "microspecies";
    public static final String ACTIONS = "actions";
    public static final String ASPECTS = "aspects";

    public IExpression getFrequency();

    public IExpression getSchedule();

    public IExpression getConcurrency();

    public boolean extendsSpecies(ISpecies var1);

    public boolean isGrid();

    public boolean isGraph();

    public IList<ISpecies> getSubSpecies(IScope var1);

    @GamlAnnotations.getter(value="subspecies")
    @GamlAnnotations.doc(value="Returns all the direct subspecies names of this species")
    default public IList<String> getSubSpeciesNames(IScope iScope) {
        return (IList)StreamEx.of(this.getSubSpecies(iScope)).map(iSpecies -> iSpecies.getName()).toCollection((Supplier)Containers.listOf(Types.STRING));
    }

    @Override
    @GamlAnnotations.getter(value="name")
    public String getName();

    public IList<ISpecies> getMicroSpecies();

    public ISpecies getMicroSpecies(String var1);

    public boolean hasMicroSpecies();

    public boolean containMicroSpecies(ISpecies var1);

    @GamlAnnotations.getter(value="parent")
    @GamlAnnotations.doc(value="Returns the direct parent of the species. Experiments, models and species with no explicit parents will return nil")
    public ISpecies getParentSpecies();

    public boolean isPeer(ISpecies var1);

    public List<ISpecies> getSelfWithParents();

    public Collection<UserCommandStatement> getUserCommands();

    public <T extends IStatement> T getStatement(Class<T> var1, String var2);

    public IStatement.WithArgs getAction(String var1);

    @GamlAnnotations.getter(value="actions")
    @GamlAnnotations.doc(value="retuns the list of actions defined in this species (incl. the ones inherited from its parent)")
    default public IList<String> getActionNames(IScope iScope) {
        return GamaListFactory.create(iScope, (IType)Types.STRING, StreamEx.of(this.getActions()).map(actionStatement -> actionStatement.getName()).toList());
    }

    public Collection<ActionStatement> getActions();

    public IExecutable getAspect(String var1);

    public Collection<? extends IExecutable> getAspects();

    @GamlAnnotations.getter(value="aspects")
    @GamlAnnotations.doc(value="retuns the list of aspects defined in this species")
    public IList<String> getAspectNames();

    public IArchitecture getArchitecture();

    public String getArchitectureName();

    public ISpecies getMacroSpecies();

    public String getParentName();

    public IVariable getVar(String var1);

    public Collection<String> getVarNames();

    @GamlAnnotations.getter(value="attributes")
    @GamlAnnotations.doc(value="retuns the list of attributes defined in this species (incl. the ones inherited from its parent)")
    default public IList<String> getAttributeNames(IScope iScope) {
        return GamaListFactory.create(iScope, (IType)Types.STRING, this.getVarNames());
    }

    public Collection<IVariable> getVars();

    public boolean hasAspect(String var1);

    public boolean hasVar(String var1);

    public void setMacroSpecies(ISpecies var1);

    public boolean isMirror();

    public Boolean implementsSkill(String var1);

    @GamlAnnotations.getter(value="microspecies")
    @GamlAnnotations.doc(value="Returns all the direct microspecies names of this species")
    public Collection<String> getMicroSpeciesNames();

    @Override
    @GamlAnnotations.getter(value="population")
    @GamlAnnotations.doc(value="Returns the population of agents that belong to this species")
    public IPopulation<? extends IAgent> getPopulation(IScope var1);

    public void addTemporaryAction(ActionStatement var1);

    public Collection<IStatement> getBehaviors();

    public void removeTemporaryAction();

    @Override
    public SpeciesDescription getDescription();
}

