/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.IScope;
import gama.core.util.matrix.GamaField;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Comparison;
import gama.gaml.operators.Strings;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class ASCSaver
extends AbstractSaver {
    @Override
    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) throws IOException {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileWriter fileWriter = new FileWriter(file2, StandardCharsets.UTF_8, false);){
                this.save(iScope, iExpression, fileWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            ProjectionFactory.saveTargetCRSAsPRJFile(iScope, file2.getAbsolutePath());
        }
    }

    public void save(IScope iScope, IExpression iExpression, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return;
        }
        this.save(iScope, iExpression, new OutputStreamWriter(outputStream));
    }

    public void save(IScope iScope, IExpression iExpression, Writer writer) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try {
                Object object = iExpression.value(iScope);
                if (object instanceof GamaField) {
                    GamaField gamaField = (GamaField)object;
                    this.saveField(iScope, gamaField, writer);
                } else {
                    ISpecies iSpecies = Cast.asSpecies(iScope, object);
                    if (iSpecies == null || !iSpecies.isGrid()) {
                        return;
                    }
                    this.saveGrid(iScope, iSpecies, writer);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void saveGrid(IScope iScope, ISpecies iSpecies, Writer writer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        GridPopulation gridPopulation = (GridPopulation)iSpecies.getPopulation(iScope);
        int n = gridPopulation.getNbCols();
        int n2 = gridPopulation.getNbRows();
        stringBuilder.append("ncols         ").append(n).append(Strings.LN);
        stringBuilder.append("nrows         ").append(n2).append(Strings.LN);
        boolean bl = iScope.getSimulation().getProjectionFactory().getWorld() == null;
        stringBuilder.append("xllcorner     ").append(bl ? "0" : Double.valueOf(iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getMinX())).append(Strings.LN);
        stringBuilder.append("yllcorner     ").append(bl ? "0" : Double.valueOf(iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getMinY())).append(Strings.LN);
        double d = iScope.getSimulation().getEnvelope().getWidth() / (double)n;
        double d2 = iScope.getSimulation().getEnvelope().getHeight() / (double)n2;
        if (Comparison.equal((Double)d, (Double)d2).booleanValue()) {
            stringBuilder.append("cellsize      ").append(d).append(Strings.LN);
        } else {
            stringBuilder.append("dx            ").append(d).append(Strings.LN);
            stringBuilder.append("dy            ").append(d2).append(Strings.LN);
        }
        writer.write(stringBuilder.toString());
        int n3 = 0;
        while (n3 < n2) {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n4 = 0;
            while (n4 < n) {
                stringBuilder2.append(gridPopulation.getGridValue(n4, n3)).append(" ");
                ++n4;
            }
            writer.write(stringBuilder2.append(Strings.LN).toString());
            ++n3;
        }
    }

    private void saveField(IScope iScope, GamaField gamaField, Writer writer) throws IOException {
        if (gamaField == null || gamaField.isEmpty(iScope)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = gamaField.numCols;
        int n2 = gamaField.numRows;
        stringBuilder.append("ncols         ").append(n).append(Strings.LN);
        stringBuilder.append("nrows         ").append(n2).append(Strings.LN);
        boolean bl = iScope.getSimulation().getProjectionFactory().getWorld() == null;
        stringBuilder.append("xllcorner     ").append(bl ? "0" : Double.valueOf(iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getMinX())).append(Strings.LN);
        stringBuilder.append("yllcorner     ").append(bl ? "0" : Double.valueOf(iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getMinY())).append(Strings.LN);
        double d = iScope.getSimulation().getEnvelope().getWidth() / (double)n;
        double d2 = iScope.getSimulation().getEnvelope().getHeight() / (double)n2;
        if (Comparison.equal((Double)d, (Double)d2).booleanValue()) {
            stringBuilder.append("cellsize      ").append(d).append(Strings.LN);
        } else {
            stringBuilder.append("dx            ").append(d).append(Strings.LN);
            stringBuilder.append("dy            ").append(d2).append(Strings.LN);
        }
        writer.write(stringBuilder.toString());
        int n3 = 0;
        while (n3 < n2) {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n4 = 0;
            while (n4 < n) {
                stringBuilder2.append(gamaField.get(iScope, n4, n3)).append(" ");
                ++n4;
            }
            writer.write(stringBuilder2.append(Strings.LN).toString());
            ++n3;
        }
    }

    @Override
    public Set<String> computeFileTypes() {
        return Set.of("asc");
    }
}

