/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import gama.core.common.interfaces.ISerialisationConstants;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class TextSaver
extends AbstractSaver {
    @Override
    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) throws GamaRuntimeException {
        String string = Cast.asString(iScope, iExpression.value(iScope));
        char c = string.charAt(0);
        Charset charset = c == '*' || c == '+' ? ISerialisationConstants.STRING_BYTE_ARRAY_CHARSET : StandardCharsets.UTF_8;
        saveOptions.setCharSet(charset);
        try {
            GAMA.getBufferingController().askWriteFile(file2.getAbsolutePath(), iScope, string, saveOptions);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw gamaRuntimeException;
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create(exception, iScope);
        }
    }

    @Override
    protected Set<String> computeFileTypes() {
        return Set.of("text", "txt");
    }

    @Override
    public BiMap<String, String> getSynonyms() {
        return ImmutableBiMap.of((Object)"txt", (Object)"text");
    }
}

