/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.objects;

import gama.dependencies.kabeja.dxf.objects.DXFObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DXFDictionary
extends DXFObject {
    protected ArrayList<DXFDictionaryRecord> records = new ArrayList();

    @Override
    public String getObjectType() {
        return "DICTIONARY";
    }

    public boolean hasDXFObjectByID(String string) {
        return this.findByID(string) != null;
    }

    public String getNameForDXFObjectID(String string) {
        return this.findByID(string).getName();
    }

    public DXFObject getDXFObjectByID(String string) {
        DXFDictionaryRecord dXFDictionaryRecord;
        DXFDictionary dXFDictionary = this.getDXFDictionaryForID(string);
        if (dXFDictionary != null && (dXFDictionaryRecord = dXFDictionary.findByID(string)) != null) {
            return dXFDictionaryRecord.getDXFObject();
        }
        return null;
    }

    public DXFObject getDXFObjectByName(String string) {
        DXFDictionaryRecord dXFDictionaryRecord = this.findByName(string);
        if (dXFDictionaryRecord != null) {
            return dXFDictionaryRecord.getDXFObject();
        }
        return null;
    }

    public void putDXFObject(DXFObject dXFObject) {
        this.findByID(dXFObject.getID()).setDXFObject(dXFObject);
    }

    public void putDXFObjectRelation(String string, String string2) {
        DXFDictionaryRecord dXFDictionaryRecord = null;
        dXFDictionaryRecord = this.findByName(string);
        if (dXFDictionaryRecord != null) {
            dXFDictionaryRecord.setID(string2);
        } else {
            dXFDictionaryRecord = new DXFDictionaryRecord(string, string2);
            this.records.add(dXFDictionaryRecord);
        }
    }

    protected DXFDictionaryRecord findByName(String string) {
        int n = 0;
        while (n < this.records.size()) {
            DXFDictionaryRecord dXFDictionaryRecord = this.records.get(n);
            if (dXFDictionaryRecord.getName().equals(string)) {
                return dXFDictionaryRecord;
            }
            ++n;
        }
        return null;
    }

    protected DXFDictionaryRecord findByID(String string) {
        int n = 0;
        while (n < this.records.size()) {
            DXFDictionaryRecord dXFDictionaryRecord = this.records.get(n);
            if (dXFDictionaryRecord.getID().equals(string)) {
                return dXFDictionaryRecord;
            }
            ++n;
        }
        return null;
    }

    public DXFDictionary getDXFDictionaryForID(String string) {
        HashSet<DXFObject> hashSet = new HashSet<DXFObject>();
        DXFObject dXFObject = null;
        int n = 0;
        while (n < this.records.size()) {
            DXFDictionaryRecord object = this.records.get(n);
            if (object.getID().equals(string)) {
                return this;
            }
            dXFObject = object.getDXFObject();
            if (dXFObject != null && "DICTIONARY".equals(dXFObject.getObjectType())) {
                hashSet.add(dXFObject);
            }
            ++n;
        }
        for (DXFDictionary dXFDictionary : hashSet) {
            DXFDictionary dXFDictionary2 = dXFDictionary.getDXFDictionaryForID(string);
            if (dXFDictionary2 == null) continue;
            return dXFDictionary2;
        }
        return null;
    }

    public Iterator<?> getDXFObjectIterator() {
        return new Iterator<Object>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < DXFDictionary.this.records.size();
            }

            @Override
            public Object next() {
                return DXFDictionary.this.records.get(this.count++).getDXFObject();
            }

            @Override
            public void remove() {
                DXFDictionary.this.records.remove(this.count - 1);
            }
        };
    }

    private static class DXFDictionaryRecord {
        private String id;
        private final String name;
        private DXFObject obj;

        public DXFDictionaryRecord(String string, String string2) {
            this.id = string2;
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public void setID(String string) {
            this.id = string;
        }

        public void setDXFObject(DXFObject dXFObject) {
            this.obj = dXFObject;
        }

        public DXFObject getDXFObject() {
            return this.obj;
        }
    }
}

