/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class DXFLayer {
    private final Hashtable<String, ArrayList<DXFEntity>> entities = new Hashtable();
    private String name = "";
    private int color = 7;
    private DXFDocument doc;
    private String ltype = "";
    private int flags = 0;
    private int lineWeight = 0;
    private String plotStyle = "";

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addDXFEntity(DXFEntity dXFEntity) {
        dXFEntity.setDXFDocument(this.doc);
        if (this.entities.containsKey(dXFEntity.getType())) {
            this.entities.get(dXFEntity.getType()).add(dXFEntity);
        } else {
            ArrayList<DXFEntity> arrayList = new ArrayList<DXFEntity>();
            arrayList.add(dXFEntity);
            this.entities.put(dXFEntity.getType(), arrayList);
        }
    }

    public void removeDXFEntity(DXFEntity dXFEntity) {
        if (this.entities.containsKey(dXFEntity.getType())) {
            ArrayList<DXFEntity> arrayList = this.entities.get(dXFEntity.getType());
            arrayList.remove(dXFEntity);
            if (arrayList.isEmpty()) {
                this.entities.remove(dXFEntity.getType());
            }
        }
    }

    public void setDXFDocument(DXFDocument dXFDocument) {
        this.doc = dXFDocument;
    }

    public DXFDocument getDXFDocument() {
        return this.doc;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Enumeration<ArrayList<DXFEntity>> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            ArrayList<DXFEntity> arrayList = enumeration.nextElement();
            for (DXFEntity dXFEntity : arrayList) {
                Bounds bounds2 = dXFEntity.getBounds();
                if (!bounds2.isValid()) continue;
                bounds.addToBounds(bounds2);
            }
        }
        return bounds;
    }

    public Bounds getBounds(boolean bl) {
        Bounds bounds = new Bounds();
        Enumeration<ArrayList<DXFEntity>> enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            ArrayList<DXFEntity> arrayList = enumeration.nextElement();
            for (DXFEntity dXFEntity : arrayList) {
                if ((!bl || !dXFEntity.isModelSpace()) && (bl || dXFEntity.isModelSpace())) continue;
                Bounds bounds2 = dXFEntity.getBounds();
                if (bounds2.getMaximumX() == Double.NaN) {
                    System.out.println("NANA=" + String.valueOf(dXFEntity));
                }
                if (!bounds2.isValid()) continue;
                bounds.addToBounds(bounds2);
            }
        }
        return bounds;
    }

    public List<DXFEntity> getDXFEntities(String string) {
        if (this.entities.containsKey(string)) {
            return this.entities.get(string);
        }
        return null;
    }

    public boolean hasDXFEntities(String string) {
        return this.entities.containsKey(string);
    }

    public Iterator<String> getDXFEntityTypeIterator() {
        return this.entities.keySet().iterator();
    }

    public DXFEntity getDXFEntityByID(String string) {
        DXFEntity dXFEntity = null;
        Iterator<ArrayList<DXFEntity>> iterator = this.entities.values().iterator();
        while (iterator.hasNext()) {
            for (DXFEntity dXFEntity2 : (List)iterator.next()) {
                if (!dXFEntity2.getID().equals(string)) continue;
                return dXFEntity2;
            }
        }
        return dXFEntity;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setLineType(String string) {
        this.ltype = string;
    }

    public String getLineType() {
        return this.ltype;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public boolean isVisible() {
        return this.color >= 0;
    }

    public boolean isFrozen() {
        return (this.flags & 1) == 1;
    }

    public int getLineWeight() {
        return this.lineWeight;
    }

    public void setLineWeight(int n) {
        this.lineWeight = n;
    }

    public String getPlotStyle() {
        return this.plotStyle;
    }

    public void setPlotStyle(String string) {
        this.plotStyle = string;
    }
}

