/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser;

import gama.dependencies.kabeja.dxf.DXFBlock;
import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.parser.DXFEntitiesSectionHandler;
import gama.dependencies.kabeja.parser.DXFValue;

public class DXFBlocksSectionHandler
extends DXFEntitiesSectionHandler {
    public static final String SECTION_KEY = "BLOCKS";
    public static final String BLOCK_START = "BLOCK";
    public static final String BLOCK_END = "ENDBLK";
    public static final int BLOCK = 0;
    public static final int BLOCK_NAME = 2;
    public static final int BLOCK_NAME2 = 3;
    public static final int BLOCK_DESCRIPTION = 4;
    public static final int BLOCK_XREFPATHNAME = 1;
    public static final int BLOCK_BASE_X = 10;
    public static final int BLOCK_BASE_Y = 20;
    public static final int BLOCK_BASE_Z = 30;
    protected boolean parseBlockHeader = false;
    private DXFBlock block;

    @Override
    public String getSectionKey() {
        return SECTION_KEY;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 0: {
                if (BLOCK_START.equals(dXFValue.getValue())) {
                    this.parseBlockHeader = true;
                    this.block = new DXFBlock();
                    break;
                }
                if (BLOCK_END.equals(dXFValue.getValue())) {
                    this.endEntity();
                    this.doc.addDXFBlock(this.block);
                    break;
                }
                this.parseBlockHeader = false;
                super.parseGroup(n, dXFValue);
                break;
            }
            case 2: {
                if (this.parseBlockHeader) {
                    this.block.setName(dXFValue.getValue());
                    break;
                }
                super.parseGroup(n, dXFValue);
                break;
            }
            case 3: {
                if (this.parseBlockHeader) break;
                super.parseGroup(n, dXFValue);
                break;
            }
            case 4: {
                if (this.parseBlockHeader) {
                    this.block.setDescription(dXFValue.getValue());
                    break;
                }
                super.parseGroup(n, dXFValue);
                break;
            }
            case 8: {
                if (this.parseBlockHeader) {
                    this.block.setLayerID(dXFValue.getValue());
                    break;
                }
                super.parseGroup(n, dXFValue);
                break;
            }
            case 10: {
                if (this.parseBlockHeader) {
                    this.block.getReferencePoint().setX(dXFValue.getDoubleValue());
                    break;
                }
                super.parseGroup(n, dXFValue);
                break;
            }
            case 20: {
                if (this.parseBlockHeader) {
                    this.block.getReferencePoint().setY(dXFValue.getDoubleValue());
                    break;
                }
                super.parseGroup(n, dXFValue);
                break;
            }
            case 30: {
                if (this.parseBlockHeader) {
                    this.block.getReferencePoint().setZ(dXFValue.getDoubleValue());
                    break;
                }
                super.parseGroup(n, dXFValue);
                break;
            }
            default: {
                super.parseGroup(n, dXFValue);
            }
        }
    }

    @Override
    public void setDXFDocument(DXFDocument dXFDocument) {
        super.setDXFDocument(dXFDocument);
    }

    @Override
    public void startSection() {
        this.parseEntity = false;
    }

    @Override
    public void endSection() {
    }

    @Override
    protected void endEntity() {
        if (this.parseEntity) {
            this.handler.endDXFEntity();
            DXFEntity dXFEntity = this.handler.getDXFEntity();
            this.block.addDXFEntity(dXFEntity);
            this.parseEntity = false;
        }
    }
}

