/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.table;

import gama.dependencies.kabeja.dxf.DXFLineType;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.table.AbstractTableHandler;

public class DXFLineTypeTableHandler
extends AbstractTableHandler {
    public static final String TABLE_KEY = "LTYPE";
    public static final int GROUPCODE_LTYPE_NAME = 2;
    public static final int GROUPCODE_LTYPE_DESCRIPTION = 3;
    public static final int GROUPCODE_LTYPE_ALIGNMENT = 72;
    public static final int GROUPCODE_LTYPE_SEGMENT = 49;
    public static final int GROUPCODE_LTYPE_LENGTH = 40;
    public static final int GROUPCODE_LTYPE_SEGMENT_COUNT = 73;
    public static final int GROUPCODE_LTYPE_SCALE = 46;
    private DXFLineType ltype;
    private int segmentCount = 0;
    private double[] pattern;

    @Override
    public void endParsing() {
        this.ltype.setPattern(this.pattern);
        this.doc.addDXFLineType(this.ltype);
    }

    @Override
    public String getTableKey() {
        return TABLE_KEY;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 2: {
                this.ltype.setName(dXFValue.getValue());
                break;
            }
            case 3: {
                this.ltype.setDescritpion(dXFValue.getValue());
                break;
            }
            case 73: {
                int n2 = dXFValue.getIntegerValue();
                this.pattern = new double[n2];
                this.segmentCount = 0;
                break;
            }
            case 49: {
                this.pattern[this.segmentCount] = dXFValue.getDoubleValue();
                ++this.segmentCount;
                break;
            }
            case 40: {
                this.ltype.setPatternLength(dXFValue.getDoubleValue());
                break;
            }
            case 72: {
                this.ltype.setAlignment(dXFValue.getIntegerValue());
                break;
            }
            case 46: {
                this.ltype.setScale(dXFValue.getDoubleValue());
                break;
            }
        }
    }

    @Override
    public void startParsing() {
        this.ltype = new DXFLineType();
        this.segmentCount = 0;
        this.pattern = null;
    }
}

