/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.xml;

import gama.dependencies.kabeja.xml.AbstractSAXSerializer;
import gama.dependencies.kabeja.xml.SAXSerializer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXPrettyOutputter
extends AbstractSAXSerializer
implements SAXSerializer {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String SUFFIX = "svg";
    public static final String SUFFIX_GZIP = "svgz";
    public static final String MIMETYPE = "text/svg";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_GZIP = "gzip";
    private OutputStreamWriter out;
    private String encoding;
    private String dtd;
    private int indent = 0;
    private boolean parent = false;
    private final ArrayList<Boolean> textContentList = new ArrayList();
    protected HashMap<String, String> rootxmlns = new HashMap();
    protected boolean gzip = false;

    public SAXPrettyOutputter(OutputStream outputStream, String string) {
        this.encoding = string;
        this.setOutput(outputStream);
    }

    public SAXPrettyOutputter(OutputStream outputStream) {
        this(outputStream, DEFAULT_ENCODING);
    }

    public SAXPrettyOutputter() {
        this.encoding = DEFAULT_ENCODING;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (n2 > 0) {
                if (this.parent) {
                    this.out.write(">");
                    this.parent = false;
                }
                char[] cArray2 = SAXPrettyOutputter.encodeXML(new String(cArray, 0, n2)).toCharArray();
                this.out.write(cArray2, n, cArray2.length);
                this.textContentList.set(this.textContentList.size() - 1, true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.out.flush();
            this.out.close();
            this.textContentList.clear();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.parent) {
                this.out.write("/>");
            } else {
                Boolean bl = this.textContentList.remove(this.textContentList.size() - 1);
                if (!bl.booleanValue()) {
                    this.out.write(10);
                    this.indentOutput(this.indent);
                }
                this.out.write("</" + string3 + ">");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        --this.indent;
        this.parent = false;
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.indent = 0;
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>");
            if (this.dtd != null) {
                this.out.write("\n<!DOCTYPE " + this.dtd + ">");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.indent;
        try {
            if (this.parent) {
                this.out.write(">");
            } else {
                this.parent = true;
            }
            this.out.write(10);
            this.indentOutput(this.indent);
            this.out.write("<" + string3);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.indentOutput(1);
                String string4 = attributes.getQName(n2);
                String string5 = attributes.getValue(n2);
                if (string5 == null) {
                    string5 = "";
                }
                this.out.write(string4 + "=\"" + SAXPrettyOutputter.encodeXML(attributes.getValue(n2)) + "\"");
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.textContentList.add(false);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    private void indentOutput(int n) {
        try {
            int n2 = 0;
            while (n2 < n) {
                this.out.write(32);
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String encodeXML(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                default: {
                    if (Character.isIdentifierIgnorable(c)) break;
                    stringBuilder.append(c);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public void setDTD(String string) {
        this.dtd = string;
    }

    protected void queryXMLNS(Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getQName(n);
            if (string.startsWith("xmlns:")) {
                String string2 = attributes.getLocalName(n);
                String string3 = attributes.getValue(n);
                this.rootxmlns.put(string3, string2);
            }
            ++n;
        }
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public String getSuffix() {
        if (this.gzip) {
            return SUFFIX_GZIP;
        }
        return SUFFIX;
    }

    @Override
    public void setOutput(OutputStream outputStream) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = this.gzip ? new BufferedOutputStream(new GZIPOutputStream(outputStream)) : new BufferedOutputStream(outputStream);
            this.out = new OutputStreamWriter((OutputStream)bufferedOutputStream, this.encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setProperties(Map map) {
        this.properties = map;
        if (map.containsKey(PROPERTY_ENCODING)) {
            this.encoding = (String)map.get(PROPERTY_ENCODING);
        }
        if (map.containsKey(PROPERTY_GZIP)) {
            this.gzip = Boolean.getBoolean((String)map.get(PROPERTY_GZIP));
        }
    }
}

