/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.ElementProcessor;
import gama.dependencies.osmosis.EntityElementProcessor;
import gama.dependencies.osmosis.Node;
import gama.dependencies.osmosis.NodeContainer;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.TagElementProcessor;
import gama.dependencies.osmosis.TagListener;
import gama.dependencies.osmosis.TimestampContainer;
import org.xml.sax.Attributes;

public class NodeElementProcessor
extends EntityElementProcessor
implements TagListener {
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_USERID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_LATITUDE = "lat";
    private static final String ATTRIBUTE_NAME_LONGITUDE = "lon";
    private final TagElementProcessor tagElementProcessor;
    private Node node;
    private final boolean coordinatesRequired;

    public NodeElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl) {
        this(baseElementProcessor, sink, bl, true);
    }

    public NodeElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl, boolean bl2) {
        super(baseElementProcessor, sink, bl);
        this.coordinatesRequired = bl2;
        this.tagElementProcessor = new TagElementProcessor((BaseElementProcessor)this, this);
    }

    @Override
    public void begin(Attributes attributes) {
        long l = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        String string = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (string == null) {
            throw new OsmosisRuntimeException("Node " + l + " does not have a version attribute as OSM 0.6 are required to have.  Is this a 0.5 file?");
        }
        int n = Integer.parseInt(string);
        TimestampContainer timestampContainer = this.createTimestampContainer(attributes.getValue(ATTRIBUTE_NAME_TIMESTAMP));
        String string2 = attributes.getValue(ATTRIBUTE_NAME_USERID);
        String string3 = attributes.getValue(ATTRIBUTE_NAME_USER);
        long l2 = this.buildChangesetId(attributes.getValue(ATTRIBUTE_NAME_CHANGESET_ID));
        double d = this.getLatLonDouble(attributes, ATTRIBUTE_NAME_LATITUDE, l);
        double d2 = this.getLatLonDouble(attributes, ATTRIBUTE_NAME_LONGITUDE, l);
        OsmUser osmUser = this.buildUser(string2, string3);
        this.node = new Node(new CommonEntityData(l, n, timestampContainer, osmUser, l2), d, d2);
    }

    @Override
    public ElementProcessor getChild(String string, String string2, String string3) {
        if (ELEMENT_NAME_TAG.equals(string3)) {
            return this.tagElementProcessor;
        }
        return super.getChild(string, string2, string3);
    }

    @Override
    public void end() {
        this.getSink().process(new NodeContainer(this.node));
    }

    @Override
    public void processTag(Tag tag) {
        this.node.getTags().add(tag);
    }

    private double getLatLonDouble(Attributes attributes, String string, long l) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            if (this.coordinatesRequired) {
                throw new OsmosisRuntimeException(String.format("Node %s does not have its %s attribute set; this attribute is required in current context.", l, string));
            }
            return Double.NaN;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmosisRuntimeException(String.format("Node %s: cannot parse the %s attribute as a numeric value", l, string));
        }
    }
}

