/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.BoundsElementProcessor;
import gama.dependencies.osmosis.ElementProcessor;
import gama.dependencies.osmosis.LegacyBoundElementProcessor;
import gama.dependencies.osmosis.NodeElementProcessor;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.RelationElementProcessor;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.SourceElementProcessor;
import gama.dependencies.osmosis.WayElementProcessor;
import org.xml.sax.Attributes;

public class OsmElementProcessor
extends SourceElementProcessor {
    private static final String ELEMENT_NAME_BOUND_LEGACY = "bound";
    private static final String ELEMENT_NAME_BOUNDS = "bounds";
    private static final String ELEMENT_NAME_NODE = "node";
    private static final String ELEMENT_NAME_WAY = "way";
    private static final String ELEMENT_NAME_RELATION = "relation";
    private static final String ATTRIBUTE_NAME_GENERATOR = "generator";
    private final NodeElementProcessor nodeElementProcessor;
    private final WayElementProcessor wayElementProcessor;
    private final RelationElementProcessor relationElementProcessor;
    private boolean foundBound = false;
    private boolean foundEntities = false;
    private String generator;

    public OsmElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl, boolean bl2) {
        this(baseElementProcessor, sink, bl, bl2, true);
    }

    public OsmElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl, boolean bl2, boolean bl3) {
        super(baseElementProcessor, sink, bl);
        this.nodeElementProcessor = new NodeElementProcessor(this, this.getSink(), bl, bl3);
        this.wayElementProcessor = new WayElementProcessor(this, this.getSink(), bl);
        this.relationElementProcessor = new RelationElementProcessor(this, this.getSink(), bl);
    }

    @Override
    public void begin(Attributes attributes) {
        this.generator = attributes.getValue(ATTRIBUTE_NAME_GENERATOR);
    }

    @Override
    public ElementProcessor getChild(String string, String string2, String string3) {
        if (ELEMENT_NAME_BOUNDS.equals(string3) || ELEMENT_NAME_BOUND_LEGACY.equals(string3)) {
            if (this.foundEntities) {
                throw new OsmosisRuntimeException("Bound element must come before any entities.");
            }
            if (this.foundBound) {
                throw new OsmosisRuntimeException("Only one bound element allowed.");
            }
            this.foundBound = true;
            if (ELEMENT_NAME_BOUND_LEGACY.equals(string3)) {
                return new LegacyBoundElementProcessor(this, this.getSink(), true);
            }
            return new BoundsElementProcessor(this, this.getSink(), true, this.generator);
        }
        if (ELEMENT_NAME_NODE.equals(string3)) {
            this.foundEntities = true;
            return this.nodeElementProcessor;
        }
        if (ELEMENT_NAME_WAY.equals(string3)) {
            this.foundEntities = true;
            return this.wayElementProcessor;
        }
        if (ELEMENT_NAME_RELATION.equals(string3)) {
            this.foundEntities = true;
            return this.relationElementProcessor;
        }
        return super.getChild(string, string2, string3);
    }

    @Override
    public void end() {
    }
}

