/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.helpers.DXFTextParser;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.TextDocument;

public class DXFText
extends DXFEntity {
    public static final double DEFAULT_FONT_SIZE = 8.0;
    public static final int VALIGN_BASELINE = 0;
    public static final int VALIGN_BOTTOM = 1;
    public static final int VALIGN_CENTER = 2;
    public static final int VALIGN_TOP = 3;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_ALIGNED = 3;
    public static final int ALIGN_MIDDLE = 4;
    public static final int ALIGN_FIT = 5;
    protected double rotation = 0.0;
    protected double height = 0.0;
    protected double scale_x = 1.0;
    protected double oblique_angle = 0.0;
    protected double align_x = 0.0;
    protected double align_y = 0.0;
    protected double align_z = 0.0;
    protected int align = 0;
    protected int valign = 0;
    protected String text = "";
    protected String textStyle = "";
    protected Point p;
    protected Point align_p1;
    protected Point align_p2;
    protected boolean upsideDown = false;
    protected boolean backward = false;
    protected boolean alignmentPointSet = false;
    protected boolean top = false;
    protected boolean bottom = false;
    protected boolean vertical_center = false;
    protected TextDocument textDoc = new TextDocument();

    public DXFText() {
        this.p = new Point();
        this.align_p1 = new Point();
    }

    @Override
    public void setDXFDocument(DXFDocument dXFDocument) {
        super.setDXFDocument(dXFDocument);
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        double d = this.getTextDocument().getText().length();
        if (d > 0.0) {
            Point point = this.calculateAlignmentPoint();
            bounds.addToBounds(point);
            double d2 = this.getHeight();
            double d3 = d * d2 * 0.6;
            if (this.isBackward()) {
                d3 *= -1.0;
            }
            switch (this.align) {
                case 0: {
                    bounds.addToBounds(point.getX() + d3, point.getY(), point.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(point.getX() + d3 / 2.0, point.getY(), point.getZ());
                    bounds.addToBounds(point.getX() - d3 / 2.0, point.getY(), point.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(point.getX() - d3, point.getY(), point.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(point.getX() - d3, point.getY(), point.getZ());
                    break;
                }
                case 4: {
                    bounds.addToBounds(point.getX() + d3 / 2.0, point.getY(), point.getZ());
                    bounds.addToBounds(point.getX() - d3 / 2.0, point.getY(), point.getZ());
                    break;
                }
                case 5: {
                    bounds.addToBounds(point.getX() + d3 / 2.0, point.getY(), point.getZ());
                    bounds.addToBounds(point.getX() - d3 / 2.0, point.getY(), point.getZ());
                }
            }
            switch (this.valign) {
                case 0: {
                    bounds.addToBounds(point.getX(), point.getY() + d2 * 0.75, point.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(point.getX(), point.getY() + d2, point.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(point.getX(), point.getY() + d2 * 0.5, point.getZ());
                    bounds.addToBounds(point.getX(), point.getY() - d2 * 0.5, point.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(point.getX(), point.getY() - d2, point.getZ());
                }
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int n) {
        this.align = n;
    }

    public double getAlignX() {
        return this.align_p1.getX();
    }

    public void setAlignX(double d) {
        this.align_p1.setX(d);
    }

    public double getAlignY() {
        return this.align_p1.getY();
    }

    public void setAlignY(double d) {
        this.align_p1.setY(d);
    }

    public double getAlignZ() {
        return this.align_p1.getZ();
    }

    public void setAlignZ(double d) {
        this.align_p1.setZ(d);
    }

    public double getHeight() {
        if (this.height != 0.0) {
            return this.height;
        }
        if (this.doc.getDXFStyle(this.textStyle) != null) {
            return this.doc.getDXFStyle(this.textStyle).getTextHeight();
        }
        return 0.0;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getObliqueAngle() {
        return this.oblique_angle;
    }

    public void setObliqueAngle(double d) {
        this.oblique_angle = d;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public double getScaleX() {
        return this.scale_x;
    }

    public void setScaleX(double d) {
        this.scale_x = d;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.textDoc = DXFTextParser.parseDXFText(this);
    }

    public String getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(String string) {
        this.textStyle = string;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int n) {
        this.valign = n;
    }

    public void setX(double d) {
        this.p.setX(d);
    }

    public void setY(double d) {
        this.p.setY(d);
    }

    public void setZ(double d) {
        this.p.setZ(d);
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward(boolean bl) {
        this.backward = bl;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    public void setUpsideDown(boolean bl) {
        this.upsideDown = bl;
    }

    @Override
    public String getType() {
        return "TEXT";
    }

    public boolean isAlignmentPointSet() {
        return this.alignmentPointSet;
    }

    public void setAlignmentPoint(boolean bl) {
        this.alignmentPointSet = bl;
    }

    public TextDocument getTextDocument() {
        return this.textDoc;
    }

    public Point getInsertPoint() {
        return this.p;
    }

    public Point getAlignmentPoint() {
        return this.align_p1;
    }

    public Point calculateAlignmentPoint() {
        Point point = new Point(this.p.getX(), this.p.getY(), this.p.getZ());
        if (!this.isUpsideDown()) {
            switch (this.align) {
                case 1: {
                    if (!this.alignmentPointSet) break;
                    point.setX(this.align_p1.getX());
                    break;
                }
                case 2: {
                    if (!this.alignmentPointSet) break;
                    point.setX(this.align_p1.getX());
                    break;
                }
                case 3: {
                    if (!this.alignmentPointSet) break;
                    point.setX(this.align_p1.getX());
                    break;
                }
                case 4: {
                    if (!this.alignmentPointSet) break;
                    point.setX(this.align_p1.getX());
                    break;
                }
                case 5: {
                    if (!this.alignmentPointSet) break;
                    point.setX(this.align_p1.getX());
                }
            }
            if (this.alignmentPointSet) {
                point.setY(this.align_p1.getY());
            }
        }
        return point;
    }

    @Override
    public boolean isOmitLineType() {
        return true;
    }

    @Override
    public double getLength() {
        return 0.0;
    }
}

