/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFSpline;
import gama.dependencies.kabeja.dxf.helpers.SplinePoint;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFSplineHandler
extends AbstractEntityHandler {
    public static final int CONTROL_POINT_X = 10;
    public static final int CONTROL_POINT_Y = 20;
    public static final int CONTROL_POINT_Z = 30;
    public static final int FIT_POINT_X = 11;
    public static final int FIT_POINT_Y = 21;
    public static final int FIT_POINT_Z = 31;
    public static final int START_TANGENT_X = 12;
    public static final int START_TANGENT_Y = 22;
    public static final int START_TANGENT_Z = 32;
    public static final int END_TANGENT_X = 13;
    public static final int END_TANGENT_Y = 23;
    public static final int END_TANGENT_Z = 33;
    public static final int FIT_TOLERANCE = 44;
    public static final int KNOTS = 40;
    public static final int WEIGHTS = 41;
    public static final int CONTROLPOINT_TOLERANCE = 42;
    public static final int KNOT_TOLERANCE = 43;
    public static final int NUMBER_OF_FIT_POINTS = 74;
    public static final int NUMBER_OF_CONTROL_POINTS = 73;
    public static final int NUMBER_OF_CONTROL_POINTS2 = 96;
    public static final int NUMBER_OF_NODES = 72;
    public static final int NUMBER_OF_NODES2 = 95;
    public static final int DEGREE = 71;
    private DXFSpline spline;
    private SplinePoint point;
    private double[] knots;
    private double[] weights;
    private int knotsCount;
    private int controlPointCount;

    @Override
    public String getDXFEntityName() {
        return "SPLINE";
    }

    @Override
    public void endDXFEntity() {
        this.spline.setKnots(this.knots);
        this.spline.setWeights(this.weights);
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.spline;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 71: {
                this.spline.setDegree(dXFValue.getIntegerValue());
                break;
            }
            case 73: {
                this.weights = new double[dXFValue.getIntegerValue()];
                this.controlPointCount = 0;
                this.spline.setControlPointSize(dXFValue.getIntegerValue());
                break;
            }
            case 74: {
                this.spline.setFitPointSize(dXFValue.getIntegerValue());
                break;
            }
            case 72: {
                this.knots = new double[dXFValue.getIntegerValue()];
                this.knotsCount = 0;
                this.spline.setNodePointsSize(dXFValue.getIntegerValue());
                break;
            }
            case 95: {
                this.knots = new double[dXFValue.getIntegerValue()];
                this.knotsCount = 0;
                this.spline.setNodePointsSize(dXFValue.getIntegerValue());
                break;
            }
            case 44: {
                this.spline.setFitTolerance(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.knots[this.knotsCount] = dXFValue.getDoubleValue();
                ++this.knotsCount;
                break;
            }
            case 43: {
                this.spline.setKnotsTolerance(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.weights[this.controlPointCount] = dXFValue.getDoubleValue();
                ++this.controlPointCount;
                break;
            }
            case 42: {
                this.spline.setControlPointTolerance(dXFValue.getDoubleValue());
                break;
            }
            case 11: {
                this.point = new SplinePoint();
                this.point.setType(1);
                this.point.setX(dXFValue.getDoubleValue());
                this.spline.addSplinePoint(this.point);
                break;
            }
            case 21: {
                this.point.setY(dXFValue.getDoubleValue());
                break;
            }
            case 31: {
                this.point.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 10: {
                this.point = new SplinePoint();
                this.point.setType(0);
                this.point.setX(dXFValue.getDoubleValue());
                this.spline.addSplinePoint(this.point);
                break;
            }
            case 20: {
                this.point.setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.point.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 12: {
                this.point = new SplinePoint();
                this.point.setType(2);
                this.point.setX(dXFValue.getDoubleValue());
                this.spline.addSplinePoint(this.point);
                break;
            }
            case 22: {
                this.point.setY(dXFValue.getDoubleValue());
                break;
            }
            case 32: {
                this.point.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 13: {
                this.point = new SplinePoint();
                this.point.setType(3);
                this.point.setX(dXFValue.getDoubleValue());
                this.spline.addSplinePoint(this.point);
                break;
            }
            case 23: {
                this.point.setY(dXFValue.getDoubleValue());
                break;
            }
            case 33: {
                this.point.setZ(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.spline);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.spline = new DXFSpline();
    }
}

