/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.tools;

import gama.dependencies.kabeja.parser.Parser;
import gama.dependencies.kabeja.parser.SAXParserBuilder;
import gama.dependencies.kabeja.processing.PostProcessor;
import gama.dependencies.kabeja.processing.PostProcessorConfig;
import gama.dependencies.kabeja.processing.ProcessPipeline;
import gama.dependencies.kabeja.processing.ProcessingManager;
import gama.dependencies.kabeja.tools.SAXFilterConfig;
import gama.dependencies.kabeja.xml.AggregatorGenerator;
import gama.dependencies.kabeja.xml.SAXFilter;
import gama.dependencies.kabeja.xml.SAXGenerator;
import gama.dependencies.kabeja.xml.SAXSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXProcessingManagerBuilder
implements ContentHandler {
    public static String XMLNS_KABEJA_PROCESSING = "http://kabeja.org/processing/1.0";
    public static final String ELEMENT_CONFIGURATION = "configuration";
    public static final String ELEMENT_PARSER = "parser";
    public static final String ELEMENT_PARSERS = "parsers";
    public static final String ELEMENT_SAXSERIALIZER = "serializer";
    public static final String ELEMENT_SAXSERIALIZERS = "serializers";
    public static final String ELEMENT_SAXFILTER = "filter";
    public static final String ELEMENT_FILTER = "filter";
    public static final String ELEMENT_SAXFILTERS = "filters";
    public static final String ELEMENT_PIPELINE = "pipeline";
    public static final String ELEMENT_PIPELINES = "pipelines";
    public static final String ELEMENT_SERIALIZE = "serialize";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ELEMENT_POSTPROCESSOR = "postprocessor";
    public static final String ELEMENT_POSTPROCESS = "postprocess";
    public static final String ELEMENT_AGGREGATE = "aggregate";
    public static final String ELEMENT_SAXGENERATOR = "generator";
    public static final String ELEMENT_GENERATE = "generate";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    private ProcessingManager manager;
    private SAXFilter saxfilter;
    private SAXSerializer saxserializer;
    private PostProcessor postprocessor;
    private SAXGenerator saxgenerator;
    private AggregatorGenerator aggregator;
    private Map<String, String> properties;
    private String name;
    private ProcessPipeline pipeline;
    private boolean config = false;
    private boolean aggregate = false;
    protected SAXParserBuilder parserBuilder;

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string.equals(XMLNS_KABEJA_PROCESSING)) {
            if ("filter".equals(string2) && this.config) {
                this.saxfilter.setProperties(this.properties);
                this.manager.addSAXFilter(this.saxfilter, this.name);
            } else if (ELEMENT_SAXSERIALIZER.equals(string2)) {
                this.saxserializer.setProperties(this.properties);
                this.manager.addSAXSerializer(this.saxserializer, this.name);
            } else if (ELEMENT_PIPELINE.equals(string2)) {
                this.manager.addProcessPipeline(this.pipeline);
            } else if (ELEMENT_SERIALIZE.equals(string2)) {
                this.pipeline.setSAXSerializer(this.manager.getSAXSerializer(this.name));
                this.pipeline.setSAXSerializerProperties(this.properties);
            } else if ("filter".equals(string2)) {
                SAXFilterConfig sAXFilterConfig = new SAXFilterConfig(this.properties);
                sAXFilterConfig.setFilterName(this.name);
                this.pipeline.addSAXFilterConfig(sAXFilterConfig);
            } else if (ELEMENT_POSTPROCESS.equals(string2)) {
                PostProcessorConfig postProcessorConfig = new PostProcessorConfig(this.properties);
                postProcessorConfig.setPostProcessorName(this.name);
                this.pipeline.addPostProcessorConfig(postProcessorConfig);
            } else if (ELEMENT_POSTPROCESSOR.equals(string2)) {
                this.postprocessor.setProperties(this.properties);
                this.manager.addPostProcessor(this.postprocessor, this.name);
            } else if (ELEMENT_CONFIGURATION.equals(string2)) {
                this.config = false;
            } else if (ELEMENT_GENERATE.equals(string2)) {
                if (this.aggregate) {
                    this.aggregator.addSAXGenerator(this.manager.getSAXGenerator(this.name));
                } else {
                    this.pipeline.setSAXGeneratorProperties(this.properties);
                    this.pipeline.setSAXGenerator(this.manager.getSAXGenerator(this.name));
                }
            } else if (ELEMENT_SAXGENERATOR.equals(string2)) {
                this.saxgenerator.setProperties(this.properties);
                this.manager.addSAXGenerator(this.saxgenerator, this.name);
            }
        } else if (string.equals(SAXParserBuilder.XMLNS_KABEJA_PARSER)) {
            this.parserBuilder.endElement(string, string2, string3);
            if (ELEMENT_PARSER.equals(string2)) {
                this.parserBuilder.endDocument();
                Parser parser = this.parserBuilder.getParser();
                this.manager.addParser(parser);
            }
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.manager = new ProcessingManager();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string.equals(XMLNS_KABEJA_PROCESSING)) {
            if ("filter".equals(string2) && this.config) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
                this.saxfilter = (SAXFilter)this.createInstance(attributes.getValue(ATTRIBUTE_CLASS));
            } else if (ELEMENT_SAXSERIALIZER.equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
                this.saxserializer = (SAXSerializer)this.createInstance(attributes.getValue(ATTRIBUTE_CLASS));
            } else if (ELEMENT_POSTPROCESSOR.equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
                String string4 = attributes.getValue(ATTRIBUTE_CLASS);
                this.postprocessor = (PostProcessor)this.createInstance(string4);
            } else if (ELEMENT_PIPELINE.equals(string2)) {
                this.aggregate = false;
                this.pipeline = new ProcessPipeline();
                this.pipeline.setName(attributes.getValue(ATTRIBUTE_NAME));
                String string5 = attributes.getValue(ATTRIBUTE_DESCRIPTION);
                if (string5 != null) {
                    this.pipeline.setDescription(string5);
                }
            } else if (ELEMENT_SERIALIZE.equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
            } else if ("filter".equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
            } else if (ELEMENT_PROPERTY.equals(string2)) {
                this.properties.put(attributes.getValue(ATTRIBUTE_NAME), attributes.getValue(ATTRIBUTE_VALUE));
            } else if (ELEMENT_POSTPROCESS.equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
            } else if (ELEMENT_CONFIGURATION.equals(string2)) {
                this.config = true;
            } else if (ELEMENT_SAXGENERATOR.equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
                String string6 = attributes.getValue(ATTRIBUTE_CLASS);
                this.saxgenerator = (SAXGenerator)this.createInstance(string6);
            } else if (ELEMENT_GENERATE.equals(string2)) {
                this.properties = new HashMap<String, String>();
                this.name = attributes.getValue(ATTRIBUTE_NAME);
            } else if (ELEMENT_AGGREGATE.equals(string2)) {
                this.aggregate = true;
                this.aggregator = new AggregatorGenerator();
                this.pipeline.setSAXGenerator(this.aggregator);
            }
        } else if (string.equals(SAXParserBuilder.XMLNS_KABEJA_PARSER)) {
            if (ELEMENT_PARSER.equals(string2)) {
                this.parserBuilder = new SAXParserBuilder();
                this.parserBuilder.startDocument();
            }
            this.parserBuilder.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public ProcessingManager getManager() {
        return this.manager;
    }

    protected Object createInstance(String string) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static ProcessingManager buildFromStream(InputStream inputStream) {
        SAXProcessingManagerBuilder sAXProcessingManagerBuilder = new SAXProcessingManagerBuilder();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            try {
                sAXParserFactory.setFeature("http://apache.org/xml/features/xinclude", true);
            }
            catch (Exception exception) {
                System.out.println("No XInclude support (use JAXP 1.4 or later for XInclude)");
            }
            try {
                XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                xMLReader.setContentHandler(sAXProcessingManagerBuilder);
                xMLReader.parse(new InputSource(inputStream));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
        catch (IOException | SAXException exception) {
            exception.printStackTrace();
        }
        return sAXProcessingManagerBuilder.getManager();
    }
}

