/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.webb;

import gama.dependencies.webb.Response;
import gama.dependencies.webb.WebbException;
import gama.dev.THREADS;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;

public class RetryManager {
    protected static final int[] BACKOFF = new int[]{1, 2, 4, 7, 12, 20, 30, 60, 120};
    static final RetryManager DEFAULT = new RetryManager();

    public boolean isRetryUseful(Response<?> response) {
        int n = response.getStatusCode();
        return n == 503 || n == 504 || n >= 520;
    }

    public boolean isRecoverable(WebbException webbException) {
        SSLException sSLException;
        Throwable throwable = webbException.getCause();
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SSLException && (sSLException = (SSLException)throwable).toString().toLowerCase().contains("connection reset by peer")) {
            return true;
        }
        return throwable instanceof SocketTimeoutException;
    }

    public void wait(int n) {
        long l = (long)BACKOFF[Math.min(n, BACKOFF.length - 1)] * 1000L;
        if (!THREADS.WAIT((long)l, (String[])new String[0])) {
            throw new WebbException("Wait interrupted");
        }
    }
}

