/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.fipa;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaList;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.extension.fipa.FIPAMessage;
import gama.extension.fipa.FIPAProtocol;
import gama.extension.fipa.MessageBroker;
import gama.extension.fipa.Performative;
import gama.extension.fipa.ProtocolNode;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="messages", type=5, of=24, doc={@GamlAnnotations.doc(value="Returns the list of messages that compose this conversation")}), @GamlAnnotations.variable(name="protocol", type=4, doc={@GamlAnnotations.doc(value="Returns the name of the protocol followed by the conversation")}), @GamlAnnotations.variable(name="initiator", type=11, doc={@GamlAnnotations.doc(value="Returns the agent that has initiated this conversation")}), @GamlAnnotations.variable(name="participants", type=5, of=11, doc={@GamlAnnotations.doc(value="Returns the list of agents that participate to this conversation")}), @GamlAnnotations.variable(name="ended", type=3, init="false", doc={@GamlAnnotations.doc(value="Returns whether this conversation has ended or not")})})
public class Conversation
extends GamaList<FIPAMessage> {
    private FIPAProtocol protocol;
    public static final String PROTOCOL = "protocol";
    public static final String INITIATOR = "initiator";
    public static final String PARTICIPANTS = "participants";
    public static final String ENDED = "ended";
    public static final String MESSAGES = "messages";
    private IAgent initiator;
    private final IList<IAgent> participants = GamaListFactory.create((IType)Types.AGENT);
    private final Map<IAgent, ProtocolNode> protocolNodeParticipantMap = new HashMap<IAgent, ProtocolNode>();
    private final Map<IAgent, FIPAMessage> noProtocolNodeParticipantMap = new HashMap<IAgent, FIPAMessage>();
    private final IList<FIPAMessage> messages = GamaListFactory.create((IType)Types.get((int)24));
    private boolean ended = false;

    protected Conversation(IScope iScope, String string, FIPAMessage fIPAMessage) throws GamaRuntimeException {
        super(0, Types.get((int)24));
        if (string == null) {
            throw GamaRuntimeException.error((String)"Undefined protocol name", (IScope)iScope);
        }
        try {
            FIPAProtocol.Names names = FIPAProtocol.Names.valueOf(string.replace('-', '_'));
            this.protocol = names.protocol;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw GamaRuntimeException.error((String)("Unknown protocol: " + string), (IScope)iScope);
        }
        this.initiator = fIPAMessage.getSender();
        this.participants.addAll(fIPAMessage.getReceivers());
        if (this.participants.isEmpty() || this.participants.contains(null)) {
            throw GamaRuntimeException.warning((String)("The message : " + fIPAMessage.toString() + " has no receivers."), (IScope)iScope);
        }
        MessageBroker.getInstance(iScope).addConversation(this);
    }

    public void setProtocol(FIPAProtocol fIPAProtocol) {
        this.protocol = fIPAProtocol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addMessage(IScope iScope, FIPAMessage fIPAMessage, IAgent iAgent) throws GamaRuntimeException {
        Conversation conversation = fIPAMessage.getConversation();
        if (conversation == null || conversation != this) {
            throw GamaRuntimeException.warning((String)"Conversation is invalid or not specified", (IScope)iScope);
        }
        if (this.protocol.hasProtocol()) {
            boolean bl = fIPAMessage.getSender().equals(this.initiator);
            if (bl) {
                if (!fIPAMessage.getReceivers().contains((Object)iAgent)) throw GamaRuntimeException.warning((String)("Receiver " + iAgent.getName() + " is not in the available message's receivers."), (IScope)iScope);
                if (this.protocolNodeParticipantMap.containsKey(iAgent)) {
                    ProtocolNode protocolNode = this.protocolNodeParticipantMap.remove(iAgent);
                    this.protocolNodeParticipantMap.put(iAgent, this.protocol.getNode(iScope, fIPAMessage, protocolNode, fIPAMessage.getPerformative(), bl));
                } else {
                    ProtocolNode protocolNode = this.protocol.getNode(iScope, fIPAMessage, null, fIPAMessage.getPerformative(), bl);
                    if (protocolNode != null) {
                        this.protocolNodeParticipantMap.put(iAgent, protocolNode);
                    }
                }
            } else if (this.participants.contains((Object)fIPAMessage.getSender())) {
                if (this.protocolNodeParticipantMap.containsKey(fIPAMessage.getSender())) {
                    ProtocolNode protocolNode = this.protocolNodeParticipantMap.remove(fIPAMessage.getSender());
                    this.protocolNodeParticipantMap.put(fIPAMessage.getSender(), this.protocol.getNode(iScope, fIPAMessage, protocolNode, fIPAMessage.getPerformative(), bl));
                } else {
                    ProtocolNode protocolNode = this.protocol.getNode(iScope, fIPAMessage, null, fIPAMessage.getPerformative(), bl);
                    if (protocolNode != null) {
                        this.protocolNodeParticipantMap.put(fIPAMessage.getSender(), protocolNode);
                    }
                }
            }
        } else {
            boolean bl = fIPAMessage.getSender().equals(this.initiator);
            if (bl) {
                FIPAMessage fIPAMessage2 = this.noProtocolNodeParticipantMap.get(iAgent);
                if (fIPAMessage2 != null && fIPAMessage2.getPerformative() == Performative.end_conversation) {
                    throw GamaRuntimeException.warning((String)("Message received in conversation which has already ended." + String.valueOf((Object)fIPAMessage) + String.valueOf((Object)this)), (IScope)iScope);
                }
                if (fIPAMessage2 != null) {
                    this.noProtocolNodeParticipantMap.remove(iAgent);
                }
                this.noProtocolNodeParticipantMap.put(iAgent, fIPAMessage);
            } else if (this.participants.contains((Object)fIPAMessage.getSender())) {
                FIPAMessage fIPAMessage3 = this.noProtocolNodeParticipantMap.get(fIPAMessage.getSender());
                if (fIPAMessage3 != null && fIPAMessage3.getPerformative() == Performative.end_conversation) {
                    throw GamaRuntimeException.warning((String)("Message received in conversation which has already ended." + String.valueOf((Object)fIPAMessage) + String.valueOf((Object)this)), (IScope)iScope);
                }
                if (fIPAMessage3 != null) {
                    this.noProtocolNodeParticipantMap.remove(fIPAMessage.getSender());
                }
                this.noProtocolNodeParticipantMap.put(fIPAMessage.getSender(), fIPAMessage);
            }
        }
        this.messages.add((Object)fIPAMessage);
    }

    @GamlAnnotations.getter(value="messages")
    public IList<FIPAMessage> getMessages() {
        return this.messages;
    }

    @GamlAnnotations.getter(value="initiator")
    public IAgent getIntitiator() {
        return this.initiator;
    }

    @GamlAnnotations.getter(value="participants")
    public IList<IAgent> getParticipants() {
        return this.participants;
    }

    @GamlAnnotations.getter(value="protocol")
    public String getProtocolName() {
        if (this.protocol == null) {
            return null;
        }
        return this.protocol.getName();
    }

    @GamlAnnotations.getter(value="ended")
    public boolean isEnded() {
        return this.ended || this.areAllNodeEnded();
    }

    public boolean areMessagesRead() {
        for (FIPAMessage fIPAMessage : this.messages) {
            if (!fIPAMessage.isUnread()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllNodeEnded() {
        if (this.protocol != null && this.protocol.hasProtocol()) {
            Collection<ProtocolNode> collection = this.protocolNodeParticipantMap.values();
            if (collection.isEmpty()) {
                return false;
            }
            for (ProtocolNode protocolNode : collection) {
                if (protocolNode != null && protocolNode.isTerminal()) continue;
                return false;
            }
            return true;
        }
        Collection<FIPAMessage> collection = this.noProtocolNodeParticipantMap.values();
        if (collection.isEmpty()) {
            return false;
        }
        for (FIPAMessage fIPAMessage : collection) {
            if (fIPAMessage.getPerformative() == Performative.end_conversation) continue;
            return false;
        }
        return true;
    }

    protected void end() {
        this.ended = true;
    }

    public synchronized void dispose() {
        this.end();
        this.protocolNodeParticipantMap.clear();
        this.noProtocolNodeParticipantMap.clear();
        this.participants.clear();
        this.initiator = null;
    }

    public String serializeToGaml(boolean bl) {
        return "Conversation between initiator: " + String.valueOf(this.getIntitiator()) + " and participants: " + String.valueOf(this.getParticipants());
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "Conversation between initiator: " + String.valueOf(this.getIntitiator()) + " and participants: " + String.valueOf(this.getParticipants());
    }

    public String toString() {
        return "Conversation between initiator: " + String.valueOf(this.getIntitiator()) + " and participants: " + String.valueOf(this.getParticipants());
    }
}

