/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.fipa;

import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.extension.fipa.Conversation;
import gama.extension.fipa.FIPAMessage;
import gama.extension.fipa.Performative;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageBroker {
    private final Map<IAgent, List<FIPAMessage>> messagesToDeliver = new HashMap<IAgent, List<FIPAMessage>>();
    private final Map<IAgent, ConversationsMessages> conversationsMessages = new HashMap<IAgent, ConversationsMessages>();
    private static Map<SimulationAgent, MessageBroker> instances = new HashMap<SimulationAgent, MessageBroker>();

    public IList<FIPAMessage> deliverMessagesFor(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        List<FIPAMessage> list = this.messagesToDeliver.get(iAgent);
        if (list == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        IList iList = GamaListFactory.create((IType)Types.get((int)24));
        IList iList2 = GamaListFactory.create((IType)Types.get((int)24));
        for (FIPAMessage fIPAMessage : list) {
            Conversation conversation = fIPAMessage.getConversation();
            try {
                try {
                    conversation.addMessage(iScope, fIPAMessage, iAgent);
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    iList2.add((Object)fIPAMessage);
                    this.failureMessageInReplyTo(iScope, fIPAMessage);
                    conversation.end();
                    throw gamaRuntimeException;
                }
            }
            finally {
                if (!iList2.contains((Object)fIPAMessage)) {
                    iList.add((Object)fIPAMessage);
                }
            }
        }
        this.messagesToDeliver.remove(iAgent);
        return iList;
    }

    protected FIPAMessage failureMessageInReplyTo(IScope iScope, FIPAMessage fIPAMessage) throws GamaRuntimeException {
        if (fIPAMessage.getPerformative() == Performative.failure) {
            return null;
        }
        FIPAMessage fIPAMessage2 = new FIPAMessage(iScope);
        fIPAMessage2.setSender(null);
        IList iList = GamaListFactory.create((IType)Types.AGENT);
        iList.add((Object)fIPAMessage.getSender());
        fIPAMessage2.setReceivers(iList);
        fIPAMessage2.setPerformative(Performative.failure);
        fIPAMessage2.setConversation(fIPAMessage.getConversation());
        fIPAMessage2.setContents(fIPAMessage.getContents(iScope));
        return fIPAMessage2;
    }

    public void scheduleForDelivery(IScope iScope, FIPAMessage fIPAMessage) {
        for (IAgent iAgent : fIPAMessage.getReceivers().iterable(iScope)) {
            this.scheduleForDelivery(fIPAMessage.copy(iScope), iAgent);
        }
    }

    private void scheduleForDelivery(FIPAMessage fIPAMessage, IAgent iAgent) {
        List<FIPAMessage> list = this.messagesToDeliver.get(iAgent);
        if (list == null) {
            list = new ArrayList<FIPAMessage>();
            this.messagesToDeliver.put(iAgent, list);
        }
        list.add(fIPAMessage);
    }

    public void scheduleForDelivery(IScope iScope, FIPAMessage fIPAMessage, String string) {
        Conversation conversation = new Conversation(iScope, string, fIPAMessage);
        fIPAMessage.setConversation(conversation);
        this.scheduleForDelivery(iScope, fIPAMessage);
    }

    public static MessageBroker getInstance(IScope iScope2) {
        MessageBroker messageBroker = instances.get(iScope2.getSimulation());
        if (messageBroker == null) {
            messageBroker = new MessageBroker();
            instances.put(iScope2.getSimulation(), messageBroker);
            iScope2.getSimulation().postEndAction(iScope -> {
                instances.get(iScope.getSimulation()).manageConversationsAndMessages();
                return null;
            });
            iScope2.getSimulation().postDisposeAction(iScope -> {
                if (instances.get(iScope.getSimulation()) != null) {
                    instances.get(iScope.getSimulation()).schedulerDisposed();
                }
                instances.remove(iScope.getSimulation());
                return null;
            });
        }
        return messageBroker;
    }

    public IList<FIPAMessage> getMessagesFor(IAgent iAgent) {
        if (!this.conversationsMessages.containsKey(iAgent)) {
            return GamaListFactory.EMPTY_LIST;
        }
        return this.conversationsMessages.get((Object)iAgent).messages;
    }

    public List<Conversation> getConversationsFor(IAgent iAgent) {
        if (!this.conversationsMessages.containsKey(iAgent)) {
            return GamaListFactory.EMPTY_LIST;
        }
        return this.conversationsMessages.get((Object)iAgent).conversations;
    }

    public void addConversation(Conversation conversation) {
        IList iList = GamaListFactory.create((IType)Types.AGENT);
        iList.add((Object)conversation.getIntitiator());
        for (IAgent iAgent : conversation.getParticipants()) {
            iList.add((Object)iAgent);
        }
        for (IAgent iAgent : iList) {
            this.addConversation(iAgent, conversation);
        }
    }

    private void addConversation(IAgent iAgent, Conversation conversation) {
        ConversationsMessages conversationsMessages = this.conversationsMessages.get(iAgent);
        if (conversationsMessages == null) {
            conversationsMessages = new ConversationsMessages();
            this.conversationsMessages.put(iAgent, conversationsMessages);
        }
        conversationsMessages.conversations.add((Object)conversation);
    }

    public void manageConversationsAndMessages() throws GamaRuntimeException {
        IList iList = GamaListFactory.create((IType)Types.get((int)98));
        for (IAgent iAgent : this.conversationsMessages.keySet()) {
            Object object2;
            if (iAgent.dead()) {
                object2 = this.conversationsMessages.get(iAgent);
                object2.conversations.clear();
                object2.messages.clear();
                object2.conversations = null;
                object2.messages = null;
                this.conversationsMessages.remove(iAgent);
                return;
            }
            IList<Conversation> iList2 = this.conversationsMessages.get((Object)iAgent).conversations;
            iList.clear();
            for (Object object2 : iList2) {
                if (!((Conversation)((Object)object2)).isEnded() || !((Conversation)((Object)object2)).areMessagesRead()) continue;
                iList.add(object2);
            }
            for (Object object2 : iList) {
                ((Conversation)((Object)object2)).dispose();
            }
            object2 = GamaListFactory.create((IType)Types.get((int)24));
            for (Object object3 : this.conversationsMessages.get((Object)iAgent).messages) {
                if (object3.isUnread()) continue;
                object2.add(object3);
            }
            this.conversationsMessages.get((Object)iAgent).messages.removeAll((Collection)object2);
            iList2.removeAll((Collection<?>)iList);
        }
    }

    public void schedulerDisposed() {
        this.messagesToDeliver.clear();
        for (IAgent iAgent : this.conversationsMessages.keySet()) {
            ConversationsMessages conversationsMessages = this.conversationsMessages.get(iAgent);
            conversationsMessages.conversations.clear();
            conversationsMessages.conversations = null;
            conversationsMessages.messages.clear();
            conversationsMessages.messages = null;
        }
        this.conversationsMessages.clear();
    }

    class ConversationsMessages {
        IList<Conversation> conversations = GamaListFactory.create((IType)Types.get((int)98));
        IList<FIPAMessage> messages = GamaListFactory.create((IType)Types.get((int)24));

        ConversationsMessages() {
        }
    }
}

