/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.file.IGamaFile;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import gama.extension.image.GamaImageFile;
import gama.extension.image.ImageCache;
import gama.extension.image.ImageOperators;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGGraphicsElement;
import org.apache.batik.anim.dom.SVGOMAnimatedTransformList;
import org.apache.batik.anim.dom.SVGOMCircleElement;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMEllipseElement;
import org.apache.batik.anim.dom.SVGOMLineElement;
import org.apache.batik.anim.dom.SVGOMRectElement;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.AWTPolygonProducer;
import org.apache.batik.parser.AWTPolylineProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@GamlAnnotations.file(name="svg", extensions={"svg"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"svg"}, doc={@GamlAnnotations.doc(value="Represents 2D geometries described in a SVG file. The internal representation is a list of geometries")})
public class GamaSVGFile
extends GamaGeometryFile {
    static final SAXSVGDocumentFactory SVG_FACTORY = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
    static final PNGTranscoder PNG_TRANSCODER = new CustomTranscoder();
    private SVGOMDocument document;

    static {
        DEBUG.OFF();
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a svg file", examples={@GamlAnnotations.example(value="file f <-svg_file(\"file.svg\");", isExecutable=false)})
    public GamaSVGFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    protected IShape buildGeometry(IScope iScope) {
        return GamaGeometryType.geometriesToGeometry((IScope)iScope, (IContainer)this.getBuffer());
    }

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create((IType)Types.STRING);
    }

    private SVGOMDocument getDocument(IScope iScope) {
        if (this.document == null) {
            File file2 = this.getFile(iScope);
            try {
                InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);
                this.document = (SVGOMDocument)SVG_FACTORY.createSVGDocument(file2.toURI().toString(), inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.document;
    }

    private void parseGroup(Element element, AffineTransform affineTransform) throws ParseException, IOException {
        AffineTransform affineTransform2 = this.computeTransform(element, affineTransform);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if ("g".equals(string)) {
                    this.parseGroup(element2, affineTransform2);
                }
                if ("path".equals(string)) {
                    this.parsePath(element2, affineTransform2);
                }
                if ("rect".equals(string)) {
                    this.parseRect(element2, affineTransform2);
                }
                if ("circle".equals(string)) {
                    this.parseCircle(element2, affineTransform2);
                }
                if ("ellipse".equals(string)) {
                    this.parseEllipse(element2, affineTransform2);
                }
                if ("line".equals(string)) {
                    this.parseLine(element2, affineTransform2);
                }
                if ("polyline".equals(string)) {
                    this.parsePolyline(element2, affineTransform2);
                }
                if ("polygon".equals(string)) {
                    this.parsePolygon(element2, affineTransform2);
                }
            }
            ++n;
        }
    }

    private void parseRect(Element element, AffineTransform affineTransform) {
        AbstractSVGAnimatedLength abstractSVGAnimatedLength;
        float f;
        SVGOMRectElement sVGOMRectElement = (SVGOMRectElement)element;
        AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGOMRectElement.getX();
        float f2 = abstractSVGAnimatedLength2.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGOMRectElement.getY();
        float f3 = abstractSVGAnimatedLength3.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength4 = (AbstractSVGAnimatedLength)sVGOMRectElement.getWidth();
        float f4 = abstractSVGAnimatedLength4.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength5 = (AbstractSVGAnimatedLength)sVGOMRectElement.getHeight();
        float f5 = abstractSVGAnimatedLength5.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength6 = (AbstractSVGAnimatedLength)sVGOMRectElement.getRx();
        float f6 = abstractSVGAnimatedLength6.getCheckedValue();
        if (f6 > f4 / 2.0f) {
            f6 = f4 / 2.0f;
        }
        if ((f = (abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGOMRectElement.getRy()).getCheckedValue()) > f5 / 2.0f) {
            f = f5 / 2.0f;
        }
        AffineTransform affineTransform2 = this.computeTransform(element, affineTransform);
        if (f6 == 0.0f || f == 0.0f) {
            this.addShape(new Rectangle2D.Float(f2, f3, f4, f5), affineTransform2);
        } else {
            this.addShape(new RoundRectangle2D.Float(f2, f3, f4, f5, f6 * 2.0f, f * 2.0f), affineTransform2);
        }
    }

    private void parseCircle(Element element, AffineTransform affineTransform) {
        SVGOMCircleElement sVGOMCircleElement = (SVGOMCircleElement)element;
        AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGOMCircleElement.getCx();
        float f = abstractSVGAnimatedLength.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGOMCircleElement.getCy();
        float f2 = abstractSVGAnimatedLength2.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGOMCircleElement.getR();
        float f3 = abstractSVGAnimatedLength3.getCheckedValue();
        float f4 = f - f3;
        float f5 = f2 - f3;
        float f6 = f3 * 2.0f;
        this.addShape(new Ellipse2D.Float(f4, f5, f6, f6), this.computeTransform(element, affineTransform));
    }

    private void parseLine(Element element, AffineTransform affineTransform) {
        SVGOMLineElement sVGOMLineElement = (SVGOMLineElement)element;
        AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGOMLineElement.getX1();
        float f = abstractSVGAnimatedLength.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGOMLineElement.getY1();
        float f2 = abstractSVGAnimatedLength2.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGOMLineElement.getX2();
        float f3 = abstractSVGAnimatedLength3.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength4 = (AbstractSVGAnimatedLength)sVGOMLineElement.getY2();
        float f4 = abstractSVGAnimatedLength4.getCheckedValue();
        this.addShape(new Line2D.Float(f, f2, f3, f4), this.computeTransform(element, affineTransform));
    }

    private void parseEllipse(Element element, AffineTransform affineTransform) {
        SVGOMEllipseElement sVGOMEllipseElement = (SVGOMEllipseElement)element;
        AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getCx();
        float f = abstractSVGAnimatedLength.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getCy();
        float f2 = abstractSVGAnimatedLength2.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getRx();
        float f3 = abstractSVGAnimatedLength3.getCheckedValue();
        AbstractSVGAnimatedLength abstractSVGAnimatedLength4 = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getRy();
        float f4 = abstractSVGAnimatedLength4.getCheckedValue();
        this.addShape(new Ellipse2D.Float(f - f3, f2 - f4, f3 * 2.0f, f4 * 2.0f), this.computeTransform(element, affineTransform));
    }

    private void parsePolyline(Element element, AffineTransform affineTransform) throws ParseException, IOException {
        this.addShape(AWTPolylineProducer.createShape((Reader)new StringReader(element.getAttribute("points")), (int)this.getWindindRule(element)), this.computeTransform(element, affineTransform));
    }

    private void parsePolygon(Element element, AffineTransform affineTransform) throws ParseException, IOException {
        this.addShape(AWTPolygonProducer.createShape((Reader)new StringReader(element.getAttribute("points")), (int)this.getWindindRule(element)), this.computeTransform(element, affineTransform));
    }

    private void parsePath(Element element, AffineTransform affineTransform) throws ParseException, IOException {
        this.addShape(AWTPathProducer.createShape((Reader)new StringReader(element.getAttribute("d")), (int)this.getWindindRule(element)), this.computeTransform(element, affineTransform));
    }

    private int getWindindRule(Element element) {
        Value value = CSSUtilities.getComputedStyle((Element)element, (int)17);
        return value != null && value.getStringValue().charAt(0) == 'n' ? 1 : 0;
    }

    private AffineTransform computeTransform(Element element, AffineTransform affineTransform) {
        if (element instanceof SVGGraphicsElement) {
            SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(((SVGOMAnimatedTransformList.BaseSVGTransformList)sVGGraphicsElement.getTransform().getBaseVal()).getAffineTransform());
            return affineTransform2;
        }
        return affineTransform;
    }

    private void addShape(Shape shape, AffineTransform affineTransform) {
        PathIterator pathIterator = shape.getPathIterator(affineTransform, 1.0);
        Geometry geometry = ShapeReader.read((PathIterator)pathIterator, (GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);
        geometry = GeometryUtils.cleanGeometry((Geometry)geometry);
        GamaShape gamaShape = GamaShapeFactory.createFrom((Geometry)geometry);
        DEBUG.OUT((Object)("Adding shape with type " + gamaShape.getInnerGeometry().getGeometryType() + " envelope " + gamaShape.getEnvelope().getWidth() + " " + gamaShape.getEnvelope().getHeight() + " at " + gamaShape.getEnvelope().getMinX() + " " + gamaShape.getEnvelope().getMinY()));
        ((IList)this.getBuffer()).add((Object)gamaShape);
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer((IAddressableContainer)GamaListFactory.create());
        try {
            this.parseGroup(this.getDocument(iScope).getDocumentElement(), new AffineTransform());
            Envelope3D envelope3D = Envelope3D.of((List)((List)this.getBuffer()));
            DEBUG.OUT((Object)("Total resulting envelope " + envelope3D.getWidth() + " " + envelope3D.getHeight() + " at " + envelope3D.getMinX() + " " + envelope3D.getMinY()));
            for (IShape iShape : (IList)this.getBuffer()) {
                iShape.setLocation(iShape.getLocation().minus(envelope3D.getMinX(), envelope3D.getMinY(), 0.0));
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, (IScope)iScope);
        }
    }

    public BufferedImage getImage(IScope iScope, boolean bl) {
        Dimension dimension = this.correctSize(iScope);
        return this.getImage(iScope, bl, dimension.width, dimension.height);
    }

    public BufferedImage getImage(IScope iScope, boolean bl, int n, int n2) {
        if (bl) {
            String string = this.getPath(iScope) + n + "x" + n2;
            BufferedImage bufferedImage = ImageCache.getInstance().getImage(string);
            if (bufferedImage == null) {
                bufferedImage = this.getImage(iScope, false, n, n2);
                ImageCache.getInstance().forceCacheImage(bufferedImage, string);
            }
            return bufferedImage;
        }
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                SVGOMDocument sVGOMDocument = this.getDocument(iScope);
                TranscoderInput transcoderInput = new TranscoderInput((Document)sVGOMDocument);
                transcoderInput.setURI(sVGOMDocument.getDocumentURI());
                PNG_TRANSCODER.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(n2));
                PNG_TRANSCODER.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(n));
                TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)byteArrayOutputStream);
                DEBUG.OUT((Object)("Retrieving image at " + n + " " + n2));
                PNG_TRANSCODER.transcode(transcoderInput, transcoderOutput);
                byteArrayOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return ImageIO.read(new ByteArrayInputStream(byArray));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TranscoderException throwable) {
            throw GamaRuntimeException.create((Throwable)throwable, (IScope)iScope);
        }
    }

    private Dimension correctSize(IScope iScope) {
        Element element = this.getDocument(iScope).getDocumentElement();
        String string = element.getAttribute("width");
        String string2 = element.getAttribute("height");
        int n = -1;
        int n2 = -1;
        string = GamaSVGFile.stripOffPx(string);
        string2 = GamaSVGFile.stripOffPx(string2);
        float f = string.isBlank() ? 0.0f : Float.parseFloat(string);
        float f2 = string2.isBlank() ? 0.0f : Float.parseFloat(string2);
        n = Math.round(f);
        n2 = Math.round(f2);
        if (n == 0 && n2 == 0) {
            Envelope3D envelope3D = Envelope3D.of((List)((List)this.getBuffer()));
            n = (int)envelope3D.getWidth();
            n2 = (int)envelope3D.getHeight();
        }
        element.setAttribute("width", String.valueOf(n));
        element.setAttribute("height", String.valueOf(n2));
        return new Dimension(n, n2);
    }

    private static String stripOffPx(String string) {
        if (string.endsWith("px")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    @GamlAnnotations.operator(can_be_const=true, value={"image"})
    @GamlAnnotations.doc(value="Builds a new image from the specified file, p\tassing the width and height in parameter ")
    public static GamaImage image(IScope iScope, IGamaFile iGamaFile, int n, int n2) {
        if (iGamaFile instanceof GamaSVGFile) {
            GamaSVGFile gamaSVGFile = (GamaSVGFile)iGamaFile;
            return GamaImage.from(gamaSVGFile.getImage(iScope, true, n, n2), true, iGamaFile.getPath(iScope) + n + "x" + n2);
        }
        if (iGamaFile instanceof GamaImageFile) {
            GamaImageFile gamaImageFile = (GamaImageFile)iGamaFile;
            return ImageOperators.with_size(iScope, GamaImage.from(gamaImageFile.getImage(iScope, true), true, gamaImageFile.getOriginalPath()), n, n2);
        }
        return null;
    }

    public static final class CustomTranscoder
    extends PNGTranscoder {
        protected ImageRenderer createRenderer() {
            StaticRenderer staticRenderer = new StaticRenderer();
            RenderingHints renderingHints = staticRenderer.getRenderingHints();
            renderingHints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
            staticRenderer.setRenderingHints(renderingHints);
            return staticRenderer;
        }
    }
}

