/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sun.media.jai.codec.FileSeekableStream;
import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.extension.image.GifImageContainer;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class ImageCache {
    private static BufferedImage NO_IMAGE;
    private final Cache<String, BufferedImage> cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).removalListener(removalNotification -> ((BufferedImage)removalNotification.getValue()).flush()).build();
    private final Cache<String, GifImageContainer> gifCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).removalListener(removalNotification -> ((GifImageContainer)removalNotification.getValue()).dispose()).build();
    private static final Set<String> tiffExt;
    private static final Set<String> gifExt;
    private static ImageCache instance;

    static {
        DEBUG.OFF();
        tiffExt = Set.of(".tiff", ".tif", ".TIF", ".TIFF");
        gifExt = Set.of(".gif", ".GIF");
        instance = new ImageCache();
    }

    public static BufferedImage getNoImage() {
        if (NO_IMAGE == null) {
            NO_IMAGE = new BufferedImage(4, 4, 2);
        }
        return NO_IMAGE;
    }

    public static ImageCache getInstance() {
        return instance;
    }

    private ImageCache() {
    }

    public BufferedImage getImageFromFile(IScope iScope, String string, boolean bl, IIOReadProgressListener iIOReadProgressListener, String string2) {
        Object object;
        Object object2;
        if (bl) {
            object2 = (BufferedImage)this.cache.getIfPresent((Object)string);
            if (object2 != null) {
                return object2;
            }
            object = (GifImageContainer)this.gifCache.getIfPresent((Object)string);
            if (object != null) {
                return ((GifImageContainer)object).getImage();
            }
        }
        return (object = this.getImageFromFile((File)(object2 = new File(string)), bl, iIOReadProgressListener, string2)) == ImageCache.getNoImage() ? null : object;
    }

    public int getFrameCount(String string) {
        GifImageContainer gifImageContainer = (GifImageContainer)this.gifCache.getIfPresent((Object)string);
        if (gifImageContainer == null) {
            return 1;
        }
        return gifImageContainer.getFrameCount();
    }

    private BufferedImage privateReadFromFile(File file2, IIOReadProgressListener iIOReadProgressListener, String string) throws IOException {
        BufferedImage bufferedImage = ImageCache.getNoImage();
        if (file2 == null) {
            return bufferedImage;
        }
        String string2 = file2.getName();
        String string3 = null;
        if (string2.contains(".")) {
            string3 = string2.substring(file2.getName().lastIndexOf(46));
        }
        if (tiffExt.contains(string3)) {
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileSeekableStream fileSeekableStream = new FileSeekableStream(file2.getAbsolutePath());){
                ParameterBlock parameterBlock = new ParameterBlock();
                parameterBlock.add(fileSeekableStream);
                RenderedOp renderedOp = JAI.create((String)"tiff", (ParameterBlock)parameterBlock);
                return renderedOp.getAsBufferedImage();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (gifExt.contains(string3)) {
            GifImageContainer gifImageContainer = new GifImageContainer();
            gifImageContainer.read(Files.newInputStream(file2.toPath(), new OpenOption[0]));
            return gifImageContainer.getImage();
        }
        try {
            bufferedImage = AbstractDisplayGraphics.toCompatibleImage((BufferedImage)this.ioRead(file2, iIOReadProgressListener, string));
        }
        catch (Exception exception) {
            return ImageCache.getNoImage();
        }
        return bufferedImage;
    }

    private BufferedImage ioRead(File file2, IIOReadProgressListener iIOReadProgressListener, String string) throws IOException {
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string != null ? string : com.google.common.io.Files.getFileExtension((String)file2.getName()));
            imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(file2);
        }
        catch (Exception exception) {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix("jpg");
            imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(file2);
        }
        imageReader.setInput(imageInputStream, false);
        if (iIOReadProgressListener != null) {
            imageReader.addIIOReadProgressListener(iIOReadProgressListener);
        }
        return imageReader.read(0);
    }

    private GifImageContainer privateReadGifFromFile(File file2) throws IOException {
        GifImageContainer gifImageContainer = new GifImageContainer();
        gifImageContainer.read(Files.newInputStream(file2.toPath(), new OpenOption[0]));
        return gifImageContainer;
    }

    public BufferedImage getImageFromFile(File file2, boolean bl, IIOReadProgressListener iIOReadProgressListener, String string) {
        String string2 = null;
        try {
            String string3 = file2.getName();
            if (string3.contains(".")) {
                string2 = string3.substring(file2.getName().lastIndexOf(46));
            }
            BufferedImage bufferedImage = gifExt.contains(string2) ? (bl ? ((GifImageContainer)this.gifCache.get((Object)file2.getAbsolutePath(), () -> this.privateReadGifFromFile(file2))).getImage() : this.privateReadGifFromFile(file2).getImage()) : (bl ? (BufferedImage)this.cache.get((Object)file2.getAbsolutePath(), () -> this.privateReadFromFile(file2, iIOReadProgressListener, string)) : this.privateReadFromFile(file2, iIOReadProgressListener, string));
            return bufferedImage == ImageCache.getNoImage() ? null : bufferedImage;
        }
        catch (IOException | ExecutionException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void clearCache(String string) {
        this.cache.invalidate((Object)string);
    }

    public void forceCacheImage(BufferedImage bufferedImage, String string) {
        this.cache.put((Object)string, (Object)bufferedImage);
    }

    public boolean containsEntry(String string) {
        return this.cache.asMap().containsKey(string);
    }

    public BufferedImage getImage(String string) {
        return (BufferedImage)this.cache.getIfPresent((Object)string);
    }
}

