/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.extension.image.GamaImage;
import gama.extension.image.ImageConstants;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImagingOpException;
import java.awt.image.WritableRaster;

public class ImageHelper
implements ImageConstants {
    static GamaImage apply(GamaImage gamaImage, BufferedImageOp bufferedImageOp) {
        return ImageHelper.apply(gamaImage, bufferedImageOp, 1);
    }

    static GamaImage apply(GamaImage gamaImage, BufferedImageOp bufferedImageOp, int n) {
        Rectangle2D rectangle2D;
        if (n == 0) {
            return gamaImage;
        }
        int n2 = gamaImage.getType();
        if (n2 != 1 && n2 != 2) {
            gamaImage = ImageHelper.copyToOptimalImage(gamaImage);
        }
        if ((rectangle2D = bufferedImageOp.getBounds2D(gamaImage)) == null) {
            return gamaImage;
        }
        Image image = null;
        int n3 = 0;
        while (n3 < n) {
            if (image != null) {
                image.flush();
            }
            image = GamaImage.bestFor(gamaImage, (int)Math.round(rectangle2D.getWidth()), (int)Math.round(rectangle2D.getHeight()));
            gamaImage = (GamaImage)bufferedImageOp.filter(gamaImage, (BufferedImage)image);
            ++n3;
        }
        gamaImage.setId(gamaImage.getId() + (String)DESCRIPTIONS.get(bufferedImageOp) + "|" + n);
        return gamaImage;
    }

    protected static GamaImage copyToOptimalImage(Image image) {
        String string;
        BufferedImage bufferedImage;
        if (image == null) {
            return null;
        }
        int n = image instanceof BufferedImage && (bufferedImage = (BufferedImage)image).getTransparency() == 1 ? 1 : 2;
        GamaImage gamaImage = GamaImage.ofDimensions(image.getWidth(null), image.getHeight(null), n);
        Graphics graphics = gamaImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        if (image instanceof GamaImage) {
            GamaImage gamaImage2 = (GamaImage)image;
            string = gamaImage2.getId();
        } else {
            string = "image";
        }
        gamaImage.setId(string + "optimized");
        graphics.dispose();
        return gamaImage;
    }

    static GamaImage rotate(GamaImage gamaImage, int n) throws IllegalArgumentException, ImagingOpException {
        int n2 = gamaImage.getWidth();
        int n3 = gamaImage.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        switch (n) {
            case 90: {
                n2 = n3;
                n3 = gamaImage.getWidth();
                affineTransform.translate(n2, 0.0);
                affineTransform.quadrantRotate(1);
                break;
            }
            case 270: {
                n2 = n3;
                n3 = gamaImage.getWidth();
                affineTransform.translate(0.0, n3);
                affineTransform.quadrantRotate(3);
                break;
            }
            case 180: {
                affineTransform.translate(n2, n3);
                affineTransform.quadrantRotate(2);
                break;
            }
            case 0: {
                affineTransform.translate(n2, 0.0);
                affineTransform.scale(-1.0, 1.0);
                break;
            }
            case 1: {
                affineTransform.translate(0.0, n3);
                affineTransform.scale(1.0, -1.0);
            }
        }
        GamaImage gamaImage2 = GamaImage.bestFor(gamaImage, n2, n3);
        Graphics2D graphics2D = gamaImage2.createGraphics();
        graphics2D.setRenderingHints(HINTS);
        graphics2D.drawImage(gamaImage, affineTransform, null);
        graphics2D.dispose();
        gamaImage2.setId(gamaImage.getId() + "rotated" + n);
        return gamaImage2;
    }

    static GamaImage resize(GamaImage gamaImage, Mode mode, int n, int n2) throws IllegalArgumentException, ImagingOpException {
        GamaImage gamaImage2 = null;
        int n3 = gamaImage.getWidth();
        int n4 = gamaImage.getHeight();
        float f = (float)n4 / (float)n3;
        if (mode == Mode.FIT_TO_WIDTH) {
            n2 = (int)Math.ceil((float)n * f);
        } else if (mode == Mode.FIT_TO_HEIGHT) {
            n = Math.round((float)n2 / f);
        }
        gamaImage2 = n > n3 || n2 > n4 ? ImageHelper.scaleImage(gamaImage, n, n2) : ImageHelper.scaleImageIncrementally(gamaImage, n, n2);
        gamaImage2.setId(gamaImage.getId() + "resized" + n + "|" + n2);
        return gamaImage2;
    }

    static GamaImage scaleImageIncrementally(GamaImage gamaImage, int n, int n2) {
        boolean bl = false;
        int n3 = gamaImage.getWidth();
        int n4 = gamaImage.getHeight();
        do {
            int n5 = n3;
            int n6 = n4;
            if (n3 > n && (n3 -= n3 / 2) < n) {
                n3 = n;
            }
            if (n4 > n2 && (n4 -= n4 / 2) < n2) {
                n4 = n2;
            }
            if (n5 == n3 && n6 == n4) break;
            GamaImage gamaImage2 = ImageHelper.scaleImage(gamaImage, n3, n4);
            if (bl) {
                gamaImage.flush();
            }
            gamaImage = gamaImage2;
            bl = true;
        } while (n3 != n || n4 != n2);
        gamaImage.setId(gamaImage.getId() + "resized" + n + "|" + n2);
        return gamaImage;
    }

    public static GamaImage scaleImage(Image image, int n, int n2) {
        GamaImage gamaImage = GamaImage.bestFor(image, n, n2);
        Graphics2D graphics2D = gamaImage.createGraphics();
        graphics2D.setRenderingHints(ImageConstants.HINTS);
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return gamaImage;
    }

    public static GamaImage createPremultipliedBlankImage(int n, int n2) {
        return GamaImage.ofDimensions(n != 0 ? n : 1024, n2 != 0 ? n2 : 1024, 3);
    }

    public static GamaImage createCompatibleImage(int n, int n2, boolean bl) {
        if (bl) {
            return ImageHelper.createPremultipliedBlankImage(n, n2);
        }
        return GamaImage.ofDimensions(n, n2, 2);
    }

    public static void flipImageVertically(GamaImage gamaImage) {
        WritableRaster writableRaster = gamaImage.getRaster();
        Object object = null;
        Object object2 = null;
        int n = 0;
        while (n < gamaImage.getHeight() / 2) {
            object = writableRaster.getDataElements(0, n, gamaImage.getWidth(), 1, object);
            object2 = writableRaster.getDataElements(0, gamaImage.getHeight() - n - 1, gamaImage.getWidth(), 1, object2);
            writableRaster.setDataElements(0, n, gamaImage.getWidth(), 1, object2);
            writableRaster.setDataElements(0, gamaImage.getHeight() - n - 1, gamaImage.getWidth(), 1, object);
            ++n;
        }
    }

    public static enum Mode {
        FIT_EXACT,
        FIT_TO_WIDTH,
        FIT_TO_HEIGHT;

    }

    record TransferableImage(Image i) implements Transferable
    {
        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray;
            DataFlavor[] dataFlavorArray2 = dataFlavorArray = this.getTransferDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor dataFlavor2 = dataFlavorArray2[n2];
                if (dataFlavor.equals(dataFlavor2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

