/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.tcp;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.network.common.IConnector;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.common.socket.AbstractProtocol;
import gama.extension.network.common.socket.IListener;
import gama.extension.network.common.socket.SocketService;
import gama.extension.network.tcp.ClientService;
import gama.extension.network.tcp.TCPConnector;
import gama.gaml.operators.Cast;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class ServerService
extends Thread
implements SocketService,
IListener {
    protected ServerSocket serverSocket;
    protected final IAgent myAgent;
    protected final int port;
    protected boolean isAlive;
    protected boolean isOnline;
    protected PrintWriter sender;
    protected IConnector connector;

    public IConnector getConnector() {
        return this.connector;
    }

    public ServerService(IAgent iAgent, int n, IConnector iConnector) {
        this.port = n;
        this.isAlive = false;
        this.isOnline = false;
        this.connector = iConnector;
        this.myAgent = iAgent;
    }

    @Override
    public String getRemoteAddress() {
        if (this.serverSocket == null) {
            return null;
        }
        return String.valueOf(this.serverSocket.getInetAddress()) + ":" + this.port;
    }

    @Override
    public String getLocalAddress() {
        if (this.serverSocket == null) {
            return null;
        }
        return String.valueOf(this.serverSocket.getLocalSocketAddress()) + ":" + this.port;
    }

    @Override
    public void startService() throws UnknownHostException, IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.isAlive = true;
        this.isOnline = true;
        this.start();
    }

    @Override
    public void run() {
        while (this.isAlive) {
            this.isOnline = true;
            try {
                IList iList;
                if (this.myAgent.dead()) {
                    this.isOnline = false;
                    this.interrupt();
                    return;
                }
                Socket socket = this.serverSocket.accept();
                String string = socket.toString();
                DEBUG.OUT((Object)(String.valueOf(socket) + " connected"));
                if (socket.isClosed() || socket.isInputShutdown() || (iList = Cast.asList((IScope)this.myAgent.getScope(), (Object)this.myAgent.getAttribute("network_groups"))) == null || iList.contains((Object)string)) continue;
                iList.addValue(this.myAgent.getScope(), (Object)string);
                this.myAgent.setAttribute("network_groups", (Object)iList);
                ClientService clientService = new ClientService(socket, this.connector);
                clientService.startService();
                this.myAgent.setAttribute("__tcp_client" + string, (Object)clientService);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                DEBUG.LOG((Object)"Socket timeout");
            }
            catch (SocketException socketException) {
                DEBUG.LOG((Object)"Socket closed");
            }
            catch (IOException iOException) {
                DEBUG.LOG((Object)("Socket error" + String.valueOf(iOException)));
            }
            catch (Exception exception) {
                DEBUG.LOG((Object)("Exception occured in socket " + exception.getMessage()));
                if (!this.serverSocket.isClosed()) continue;
                this.isOnline = false;
            }
        }
        try {
            this.myAgent.setAttribute("__tcp_server" + this.serverSocket.getLocalPort(), null);
            this.serverSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isOnline() {
        return this.isAlive && this.isOnline;
    }

    @Override
    public void stopService() {
        this.isOnline = false;
        this.isAlive = false;
        if (this.sender != null) {
            this.sender.close();
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.interrupt();
    }

    @Override
    public void sendMessage(String string, String string2) throws IOException {
        ClientService clientService = (ClientService)this.myAgent.getAttribute("__tcp_client" + string2);
        String string3 = string;
        if (clientService == null || clientService.socket == null || !this.isOnline()) {
            return;
        }
        this.sender = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(clientService.socket.getOutputStream())), true);
        if (this.connector.isRaw()) {
            this.sender.print(string3);
            this.sender.flush();
        } else {
            string3 = string3.replace("\n", "@n@");
            string3 = string3.replace("\b\r", "@b@@r@");
            this.sender.println(string3);
            this.sender.flush();
        }
    }

    @Override
    public void sendMessage(String string) throws IOException {
    }

    @Override
    public void receivedMessage(String string, String string2) {
        MessageFactory.MessageType messageType = MessageFactory.identifyMessageType(string2);
        if (MessageFactory.MessageType.COMMAND_MESSAGE.equals((Object)messageType)) {
            ((TCPConnector)this.connector).extractAndApplyCommand(string, string2);
        } else {
            String string3 = ((TCPConnector)this.connector).isRaw() ? string2 : MessageFactory.unpackReceiverName(string2);
            ((TCPConnector)this.connector).storeMessage(string, string3, string2);
        }
    }

    @Override
    public void onOpen(AbstractProtocol abstractProtocol) {
    }

    @Override
    public void onClose(AbstractProtocol abstractProtocol, int n, String string, boolean bl) {
    }

    @Override
    public void onMessage(AbstractProtocol abstractProtocol, String string) {
    }

    @Override
    public void onMessage(AbstractProtocol abstractProtocol, ByteBuffer byteBuffer) {
    }

    @Override
    public void onError(AbstractProtocol abstractProtocol, Exception exception) {
    }

    @Override
    public void onStart() {
    }
}

