/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.udp;

import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.network.common.ConnectorMessage;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.common.NetworkMessage;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;

public class MultiThreadedUDPSocketServer
extends Thread {
    private final IAgent myAgent;
    private volatile boolean closed = false;
    private DatagramSocket myUDPServerSocket;
    private int nbBits;

    static {
        DEBUG.ON();
    }

    public DatagramSocket getMyServerSocket() {
        return this.myUDPServerSocket;
    }

    public void setMyServerSocket(DatagramSocket datagramSocket) {
        this.myUDPServerSocket = datagramSocket;
    }

    public MultiThreadedUDPSocketServer(IAgent iAgent, DatagramSocket datagramSocket, String string) {
        this.myAgent = iAgent;
        this.myUDPServerSocket = datagramSocket;
        this.nbBits = string == null ? 1024 : Integer.parseInt(string);
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                if (this.myAgent.dead()) {
                    this.interrupt();
                }
                byte[] byArray = new byte[this.nbBits];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.myUDPServerSocket.receive(datagramPacket);
                String string = new String(datagramPacket.getData());
                IList iList = (IList)this.myAgent.getAttribute("messages" + String.valueOf(this.myAgent));
                if (iList == null) {
                    iList = GamaListFactory.create(ConnectorMessage.class);
                }
                if (this.myAgent.dead()) {
                    this.interrupt();
                }
                NetworkMessage networkMessage = MessageFactory.buildNetworkMessage(this.myUDPServerSocket.toString(), string);
                iList.addValue(this.myAgent.getScope(), (Object)networkMessage);
                this.myAgent.setAttribute("messages" + String.valueOf(this.myAgent), (Object)iList);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.closed = true;
            }
            catch (Exception exception) {
                if (this.myUDPServerSocket.isClosed()) {
                    this.closed = true;
                    this.interrupt();
                    continue;
                }
                exception.printStackTrace();
            }
        }
    }
}

