/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.VertexData;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.PrimitiveManagerBase;
import com.bulletphysics.extras.gimpact.PrimitiveTriangle;
import com.bulletphysics.extras.gimpact.TriangleShapeEx;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

class TrimeshPrimitiveManager
extends PrimitiveManagerBase {
    public float margin;
    public StridingMeshInterface meshInterface;
    public final Vector3f scale = new Vector3f();
    public int part;
    public int lock_count;
    private final int[] tmpIndices = new int[3];
    private VertexData vertexData;

    public TrimeshPrimitiveManager() {
        this.meshInterface = null;
        this.part = 0;
        this.margin = 0.01f;
        this.scale.set(1.0f, 1.0f, 1.0f);
        this.lock_count = 0;
    }

    public TrimeshPrimitiveManager(TrimeshPrimitiveManager trimeshPrimitiveManager) {
        this.meshInterface = trimeshPrimitiveManager.meshInterface;
        this.part = trimeshPrimitiveManager.part;
        this.margin = trimeshPrimitiveManager.margin;
        this.scale.set(trimeshPrimitiveManager.scale);
        this.lock_count = 0;
    }

    public TrimeshPrimitiveManager(StridingMeshInterface stridingMeshInterface, int n) {
        this.meshInterface = stridingMeshInterface;
        this.part = n;
        this.meshInterface.getScaling(this.scale);
        this.margin = 0.1f;
        this.lock_count = 0;
    }

    public void lock() {
        if (this.lock_count > 0) {
            ++this.lock_count;
            return;
        }
        this.vertexData = this.meshInterface.getLockedReadOnlyVertexIndexBase(this.part);
        this.lock_count = 1;
    }

    public void unlock() {
        if (this.lock_count == 0) {
            return;
        }
        if (this.lock_count > 1) {
            --this.lock_count;
            return;
        }
        this.meshInterface.unLockReadOnlyVertexBase(this.part);
        this.vertexData = null;
        this.lock_count = 0;
    }

    @Override
    public boolean is_trimesh() {
        return true;
    }

    @Override
    public int get_primitive_count() {
        return this.vertexData.getIndexCount() / 3;
    }

    public int get_vertex_count() {
        return this.vertexData.getVertexCount();
    }

    public void get_indices(int n, int[] nArray) {
        nArray[0] = this.vertexData.getIndex(n * 3 + 0);
        nArray[1] = this.vertexData.getIndex(n * 3 + 1);
        nArray[2] = this.vertexData.getIndex(n * 3 + 2);
    }

    public void get_vertex(int n, Vector3f vector3f) {
        this.vertexData.getVertex(n, vector3f);
        VectorUtil.mul(vector3f, vector3f, this.scale);
    }

    @Override
    public void get_primitive_box(int n, BoxCollision.AABB aABB) {
        PrimitiveTriangle primitiveTriangle = (PrimitiveTriangle)Pools.TRIANGLES.get();
        this.get_primitive_triangle(n, primitiveTriangle);
        aABB.calc_from_triangle_margin(primitiveTriangle.vertices[0], primitiveTriangle.vertices[1], primitiveTriangle.vertices[2], primitiveTriangle.margin);
        Pools.TRIANGLES.release((Object[])new PrimitiveTriangle[]{primitiveTriangle});
    }

    @Override
    public void get_primitive_triangle(int n, PrimitiveTriangle primitiveTriangle) {
        this.get_indices(n, this.tmpIndices);
        this.get_vertex(this.tmpIndices[0], primitiveTriangle.vertices[0]);
        this.get_vertex(this.tmpIndices[1], primitiveTriangle.vertices[1]);
        this.get_vertex(this.tmpIndices[2], primitiveTriangle.vertices[2]);
        primitiveTriangle.margin = this.margin;
    }

    public void get_bullet_triangle(int n, TriangleShapeEx triangleShapeEx) {
        this.get_indices(n, this.tmpIndices);
        this.get_vertex(this.tmpIndices[0], triangleShapeEx.vertices1[0]);
        this.get_vertex(this.tmpIndices[1], triangleShapeEx.vertices1[1]);
        this.get_vertex(this.tmpIndices[2], triangleShapeEx.vertices1[2]);
        triangleShapeEx.setMargin(this.margin);
    }
}

