/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class Rot
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float s;
    public float c;

    public Rot() {
        this.setIdentity();
    }

    public Rot(float f) {
        this.set(f);
    }

    public float getSin() {
        return this.s;
    }

    public String toString() {
        return "Rot(s:" + this.s + ", c:" + this.c + ")";
    }

    public float getCos() {
        return this.c;
    }

    public Rot set(float f) {
        this.s = MathUtils.sin(f);
        this.c = MathUtils.cos(f);
        return this;
    }

    public Rot set(Rot rot) {
        this.s = rot.s;
        this.c = rot.c;
        return this;
    }

    public Rot setIdentity() {
        this.s = 0.0f;
        this.c = 1.0f;
        return this;
    }

    public float getAngle() {
        return MathUtils.atan2(this.s, this.c);
    }

    public void getXAxis(Vec2 vec2) {
        vec2.set(this.c, this.s);
    }

    public void getYAxis(Vec2 vec2) {
        vec2.set(-this.s, this.c);
    }

    public Rot clone() {
        Rot rot = new Rot();
        rot.s = this.s;
        rot.c = this.c;
        return rot;
    }

    public static final void mul(Rot rot, Rot rot2, Rot rot3) {
        float f = rot.c * rot2.c - rot.s * rot2.s;
        rot3.s = rot.s * rot2.c + rot.c * rot2.s;
        rot3.c = f;
    }

    public static final void mulUnsafe(Rot rot, Rot rot2, Rot rot3) {
        assert (rot2 != rot3);
        assert (rot != rot3);
        rot3.s = rot.s * rot2.c + rot.c * rot2.s;
        rot3.c = rot.c * rot2.c - rot.s * rot2.s;
    }

    public static final void mulTrans(Rot rot, Rot rot2, Rot rot3) {
        float f = rot.c * rot2.c + rot.s * rot2.s;
        rot3.s = rot.c * rot2.s - rot.s * rot2.c;
        rot3.c = f;
    }

    public static final void mulTransUnsafe(Rot rot, Rot rot2, Rot rot3) {
        rot3.s = rot.c * rot2.s - rot.s * rot2.c;
        rot3.c = rot.c * rot2.c + rot.s * rot2.s;
    }

    public static final void mulToOut(Rot rot, Vec2 vec2, Vec2 vec22) {
        float f = rot.s * vec2.x + rot.c * vec2.y;
        vec22.x = rot.c * vec2.x - rot.s * vec2.y;
        vec22.y = f;
    }

    public static final void mulToOutUnsafe(Rot rot, Vec2 vec2, Vec2 vec22) {
        vec22.x = rot.c * vec2.x - rot.s * vec2.y;
        vec22.y = rot.s * vec2.x + rot.c * vec2.y;
    }

    public static final void mulTrans(Rot rot, Vec2 vec2, Vec2 vec22) {
        float f = -rot.s * vec2.x + rot.c * vec2.y;
        vec22.x = rot.c * vec2.x + rot.s * vec2.y;
        vec22.y = f;
    }

    public static final void mulTransUnsafe(Rot rot, Vec2 vec2, Vec2 vec22) {
        vec22.x = rot.c * vec2.x + rot.s * vec2.y;
        vec22.y = -rot.s * vec2.x + rot.c * vec2.y;
    }
}

