/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.broadphase;

import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.OverlapCallback;
import com.bulletphysics.collision.broadphase.OverlapFilterCallback;
import com.bulletphysics.collision.broadphase.OverlappingPairCache;
import com.bulletphysics.collision.broadphase.OverlappingPairCallback;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.util.IntArrayList;
import com.bulletphysics.util.ObjectArrayList;

public class HashedOverlappingPairCache
implements OverlappingPairCache {
    private static final int NULL_PAIR = -1;
    private final ObjectArrayList<BroadphasePair> overlappingPairArray = new ObjectArrayList();
    private OverlapFilterCallback overlapFilterCallback;
    private final IntArrayList hashTable = new IntArrayList();
    private final IntArrayList next = new IntArrayList();
    protected OverlappingPairCallback ghostPairCallback;

    public HashedOverlappingPairCache() {
        this.growTables();
    }

    @Override
    public BroadphasePair addOverlappingPair(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2) {
        if (!this.needsBroadphaseCollision(broadphaseProxy, broadphaseProxy2)) {
            return null;
        }
        return this.internalAddPair(broadphaseProxy, broadphaseProxy2);
    }

    @Override
    public Object removeOverlappingPair(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2, Dispatcher dispatcher) {
        int n;
        int n2;
        int n3;
        BroadphasePair broadphasePair;
        if (broadphaseProxy.getUid() > broadphaseProxy2.getUid()) {
            BroadphaseProxy broadphaseProxy3 = broadphaseProxy;
            broadphaseProxy = broadphaseProxy2;
            broadphaseProxy2 = broadphaseProxy3;
        }
        if ((broadphasePair = this.internalFindPair(broadphaseProxy, broadphaseProxy2, n3 = this.getHash(n2 = broadphaseProxy.getUid(), n = broadphaseProxy2.getUid()) & this.overlappingPairArray.capacity() - 1)) == null) {
            return null;
        }
        this.cleanOverlappingPair(broadphasePair, dispatcher);
        Object object = broadphasePair.userInfo;
        assert (broadphasePair.pProxy0.getUid() == n2);
        assert (broadphasePair.pProxy1.getUid() == n);
        int n4 = this.overlappingPairArray.indexOf(broadphasePair);
        assert (n4 != -1);
        assert (n4 < this.overlappingPairArray.size());
        int n5 = this.hashTable.get(n3);
        assert (n5 != -1);
        int n6 = -1;
        while (n5 != n4) {
            n6 = n5;
            n5 = this.next.get(n5);
        }
        if (n6 != -1) {
            assert (this.next.get(n6) == n4);
            this.next.set(n6, this.next.get(n4));
        } else {
            this.hashTable.set(n3, this.next.get(n4));
        }
        int n7 = this.overlappingPairArray.size() - 1;
        if (this.ghostPairCallback != null) {
            this.ghostPairCallback.removeOverlappingPair(broadphaseProxy, broadphaseProxy2, dispatcher);
        }
        if (n7 == n4) {
            this.overlappingPairArray.removeQuick(this.overlappingPairArray.size() - 1);
            return object;
        }
        BroadphasePair broadphasePair2 = this.overlappingPairArray.getQuick(n7);
        int n8 = this.getHash(broadphasePair2.pProxy0.getUid(), broadphasePair2.pProxy1.getUid()) & this.overlappingPairArray.capacity() - 1;
        n5 = this.hashTable.get(n8);
        assert (n5 != -1);
        n6 = -1;
        while (n5 != n7) {
            n6 = n5;
            n5 = this.next.get(n5);
        }
        if (n6 != -1) {
            assert (this.next.get(n6) == n7);
            this.next.set(n6, this.next.get(n7));
        } else {
            this.hashTable.set(n8, this.next.get(n7));
        }
        this.overlappingPairArray.getQuick(n4).set(this.overlappingPairArray.getQuick(n7));
        this.next.set(n4, this.hashTable.get(n8));
        this.hashTable.set(n8, n4);
        this.overlappingPairArray.removeQuick(this.overlappingPairArray.size() - 1);
        return object;
    }

    public boolean needsBroadphaseCollision(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2) {
        boolean bl;
        if (this.overlapFilterCallback != null) {
            return this.overlapFilterCallback.needBroadphaseCollision(broadphaseProxy, broadphaseProxy2);
        }
        boolean bl2 = bl = (broadphaseProxy.collisionFilterGroup & broadphaseProxy2.collisionFilterMask) != 0;
        return bl && (broadphaseProxy2.collisionFilterGroup & broadphaseProxy.collisionFilterMask) != 0;
    }

    @Override
    public void processAllOverlappingPairs(OverlapCallback overlapCallback, Dispatcher dispatcher) {
        int n = 0;
        while (n < this.overlappingPairArray.size()) {
            BroadphasePair broadphasePair = this.overlappingPairArray.getQuick(n);
            if (overlapCallback.processOverlap(broadphasePair)) {
                this.removeOverlappingPair(broadphasePair.pProxy0, broadphasePair.pProxy1, dispatcher);
                continue;
            }
            ++n;
        }
    }

    @Override
    public void removeOverlappingPairsContainingProxy(BroadphaseProxy broadphaseProxy, Dispatcher dispatcher) {
        this.processAllOverlappingPairs(new RemovePairCallback(broadphaseProxy), dispatcher);
    }

    @Override
    public void cleanProxyFromPairs(BroadphaseProxy broadphaseProxy, Dispatcher dispatcher) {
        this.processAllOverlappingPairs(new CleanPairCallback(broadphaseProxy, this, dispatcher), dispatcher);
    }

    public ObjectArrayList<BroadphasePair> getOverlappingPairArray() {
        return this.overlappingPairArray;
    }

    @Override
    public void cleanOverlappingPair(BroadphasePair broadphasePair, Dispatcher dispatcher) {
        if (broadphasePair.algorithm != null) {
            dispatcher.freeCollisionAlgorithm(broadphasePair.algorithm);
            broadphasePair.algorithm = null;
        }
    }

    @Override
    public BroadphasePair findPair(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2) {
        int n;
        int n2;
        int n3;
        if (broadphaseProxy.getUid() > broadphaseProxy2.getUid()) {
            BroadphaseProxy broadphaseProxy3 = broadphaseProxy;
            broadphaseProxy = broadphaseProxy2;
            broadphaseProxy2 = broadphaseProxy3;
        }
        if ((n3 = this.getHash(n2 = broadphaseProxy.getUid(), n = broadphaseProxy2.getUid()) & this.overlappingPairArray.capacity() - 1) >= this.hashTable.size()) {
            return null;
        }
        int n4 = this.hashTable.get(n3);
        while (n4 != -1 && !this.equalsPair(this.overlappingPairArray.getQuick(n4), n2, n)) {
            n4 = this.next.get(n4);
        }
        if (n4 == -1) {
            return null;
        }
        assert (n4 < this.overlappingPairArray.size());
        return this.overlappingPairArray.getQuick(n4);
    }

    public int getCount() {
        return this.overlappingPairArray.size();
    }

    public OverlapFilterCallback getOverlapFilterCallback() {
        return this.overlapFilterCallback;
    }

    @Override
    public void setOverlapFilterCallback(OverlapFilterCallback overlapFilterCallback) {
        this.overlapFilterCallback = overlapFilterCallback;
    }

    @Override
    public int getNumOverlappingPairs() {
        return this.overlappingPairArray.size();
    }

    @Override
    public boolean hasDeferredRemoval() {
        return false;
    }

    private BroadphasePair internalAddPair(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2) {
        int n;
        int n2;
        int n3;
        int n4;
        BroadphasePair broadphasePair;
        if (broadphaseProxy.getUid() > broadphaseProxy2.getUid()) {
            BroadphaseProxy broadphaseProxy3 = broadphaseProxy;
            broadphaseProxy = broadphaseProxy2;
            broadphaseProxy2 = broadphaseProxy3;
        }
        if ((broadphasePair = this.internalFindPair(broadphaseProxy, broadphaseProxy2, n4 = this.getHash(n3 = broadphaseProxy.getUid(), n2 = broadphaseProxy2.getUid()) & this.overlappingPairArray.capacity() - 1)) != null) {
            return broadphasePair;
        }
        int n5 = this.overlappingPairArray.size();
        int n6 = this.overlappingPairArray.capacity();
        this.overlappingPairArray.add(null);
        if (this.ghostPairCallback != null) {
            this.ghostPairCallback.addOverlappingPair(broadphaseProxy, broadphaseProxy2);
        }
        if (n6 < (n = this.overlappingPairArray.capacity())) {
            this.growTables();
            n4 = this.getHash(n3, n2) & this.overlappingPairArray.capacity() - 1;
        }
        broadphasePair = new BroadphasePair(broadphaseProxy, broadphaseProxy2);
        broadphasePair.algorithm = null;
        broadphasePair.userInfo = null;
        this.overlappingPairArray.setQuick(this.overlappingPairArray.size() - 1, broadphasePair);
        this.next.set(n5, this.hashTable.get(n4));
        this.hashTable.set(n4, n5);
        return broadphasePair;
    }

    private void growTables() {
        int n = this.overlappingPairArray.capacity();
        if (this.hashTable.size() < n) {
            int n2 = this.hashTable.size();
            MiscUtil.resize(this.hashTable, n, 0);
            MiscUtil.resize(this.next, n, 0);
            int n3 = 0;
            while (n3 < n) {
                this.hashTable.set(n3, -1);
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                this.next.set(n3, -1);
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                BroadphasePair broadphasePair = this.overlappingPairArray.getQuick(n3);
                int n4 = broadphasePair.pProxy0.getUid();
                int n5 = broadphasePair.pProxy1.getUid();
                int n6 = this.getHash(n4, n5) & this.overlappingPairArray.capacity() - 1;
                this.next.set(n3, this.hashTable.get(n6));
                this.hashTable.set(n6, n3);
                ++n3;
            }
        }
    }

    private boolean equalsPair(BroadphasePair broadphasePair, int n, int n2) {
        return broadphasePair.pProxy0.getUid() == n && broadphasePair.pProxy1.getUid() == n2;
    }

    private int getHash(int n, int n2) {
        int n3 = n | n2 << 16;
        n3 += ~(n3 << 15);
        n3 ^= n3 >>> 10;
        n3 += n3 << 3;
        n3 ^= n3 >>> 6;
        n3 += ~(n3 << 11);
        n3 ^= n3 >>> 16;
        return n3;
    }

    private BroadphasePair internalFindPair(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2, int n) {
        int n2 = broadphaseProxy.getUid();
        int n3 = broadphaseProxy2.getUid();
        int n4 = this.hashTable.get(n);
        while (n4 != -1 && !this.equalsPair(this.overlappingPairArray.getQuick(n4), n2, n3)) {
            n4 = this.next.get(n4);
        }
        if (n4 == -1) {
            return null;
        }
        assert (n4 < this.overlappingPairArray.size());
        return this.overlappingPairArray.getQuick(n4);
    }

    @Override
    public void setInternalGhostPairCallback(OverlappingPairCallback overlappingPairCallback) {
        this.ghostPairCallback = overlappingPairCallback;
    }

    private static class CleanPairCallback
    implements OverlapCallback {
        private final BroadphaseProxy cleanProxy;
        private final OverlappingPairCache pairCache;
        private final Dispatcher dispatcher;

        public CleanPairCallback(BroadphaseProxy broadphaseProxy, OverlappingPairCache overlappingPairCache, Dispatcher dispatcher) {
            this.cleanProxy = broadphaseProxy;
            this.pairCache = overlappingPairCache;
            this.dispatcher = dispatcher;
        }

        @Override
        public boolean processOverlap(BroadphasePair broadphasePair) {
            if (broadphasePair.pProxy0 == this.cleanProxy || broadphasePair.pProxy1 == this.cleanProxy) {
                this.pairCache.cleanOverlappingPair(broadphasePair, this.dispatcher);
            }
            return false;
        }
    }

    private static class RemovePairCallback
    implements OverlapCallback {
        private final BroadphaseProxy obsoleteProxy;

        public RemovePairCallback(BroadphaseProxy broadphaseProxy) {
            this.obsoleteProxy = broadphaseProxy;
        }

        @Override
        public boolean processOverlap(BroadphasePair broadphasePair) {
            return broadphasePair.pProxy0 == this.obsoleteProxy || broadphasePair.pProxy1 == this.obsoleteProxy;
        }
    }
}

