/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.DispatcherInfo;
import com.bulletphysics.collision.broadphase.OverlapCallback;
import com.bulletphysics.collision.broadphase.OverlappingPairCache;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.DefaultNearCallback;
import com.bulletphysics.collision.dispatch.NearCallback;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import java.util.ArrayList;
import java.util.Collections;

public class CollisionDispatcher
implements Dispatcher {
    private static final int MAX_BROADPHASE_COLLISION_TYPES = BroadphaseNativeType.MAX_BROADPHASE_COLLISION_TYPES.ordinal();
    private final ArrayList<PersistentManifold> manifoldsPtr = new ArrayList();
    private boolean staticWarningReported = false;
    private NearCallback nearCallback;
    private final CollisionAlgorithmCreateFunc[][] doubleDispatch = new CollisionAlgorithmCreateFunc[MAX_BROADPHASE_COLLISION_TYPES][MAX_BROADPHASE_COLLISION_TYPES];
    private CollisionConfiguration collisionConfiguration;
    private final CollisionAlgorithmConstructionInfo tmpCI = new CollisionAlgorithmConstructionInfo();
    private final CollisionPairCallback collisionPairCallback = new CollisionPairCallback();

    public CollisionDispatcher(CollisionConfiguration collisionConfiguration) {
        this.collisionConfiguration = collisionConfiguration;
        this.setNearCallback(new DefaultNearCallback());
        int n = 0;
        while (n < MAX_BROADPHASE_COLLISION_TYPES) {
            int n2 = 0;
            while (n2 < MAX_BROADPHASE_COLLISION_TYPES) {
                this.doubleDispatch[n][n2] = collisionConfiguration.getCollisionAlgorithmCreateFunc(BroadphaseNativeType.forValue(n), BroadphaseNativeType.forValue(n2));
                assert (this.doubleDispatch[n][n2] != null);
                ++n2;
            }
            ++n;
        }
    }

    public void registerCollisionCreateFunc(int n, int n2, CollisionAlgorithmCreateFunc collisionAlgorithmCreateFunc) {
        this.doubleDispatch[n][n2] = collisionAlgorithmCreateFunc;
    }

    public NearCallback getNearCallback() {
        return this.nearCallback;
    }

    public void setNearCallback(NearCallback nearCallback) {
        this.nearCallback = nearCallback;
    }

    public CollisionConfiguration getCollisionConfiguration() {
        return this.collisionConfiguration;
    }

    public void setCollisionConfiguration(CollisionConfiguration collisionConfiguration) {
        this.collisionConfiguration = collisionConfiguration;
    }

    @Override
    public CollisionAlgorithm findAlgorithm(CollisionObject collisionObject, CollisionObject collisionObject2, PersistentManifold persistentManifold) {
        CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo = this.tmpCI;
        collisionAlgorithmConstructionInfo.dispatcher1 = this;
        collisionAlgorithmConstructionInfo.manifold = persistentManifold;
        CollisionAlgorithmCreateFunc collisionAlgorithmCreateFunc = this.doubleDispatch[collisionObject.getCollisionShape().getShapeType().ordinal()][collisionObject2.getCollisionShape().getShapeType().ordinal()];
        CollisionAlgorithm collisionAlgorithm = collisionAlgorithmCreateFunc.createCollisionAlgorithm(collisionAlgorithmConstructionInfo, collisionObject, collisionObject2);
        collisionAlgorithm.internalSetCreateFunc(collisionAlgorithmCreateFunc);
        return collisionAlgorithm;
    }

    @Override
    public void freeCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
        CollisionAlgorithmCreateFunc collisionAlgorithmCreateFunc = collisionAlgorithm.internalGetCreateFunc();
        collisionAlgorithm.internalSetCreateFunc(null);
        if (collisionAlgorithmCreateFunc != null) {
            collisionAlgorithmCreateFunc.releaseCollisionAlgorithm(collisionAlgorithm);
        }
        collisionAlgorithm.destroy();
    }

    @Override
    public PersistentManifold getNewManifold(Object object, Object object2) {
        CollisionObject collisionObject = (CollisionObject)object;
        CollisionObject collisionObject2 = (CollisionObject)object2;
        PersistentManifold persistentManifold = (PersistentManifold)Pools.MANIFOLDS.get();
        persistentManifold.init(collisionObject, collisionObject2, 0);
        persistentManifold.index1a = this.manifoldsPtr.size();
        this.manifoldsPtr.add(persistentManifold);
        return persistentManifold;
    }

    @Override
    public void releaseManifold(PersistentManifold persistentManifold) {
        int n = persistentManifold.index1a;
        assert (n < this.manifoldsPtr.size());
        Collections.swap(this.manifoldsPtr, n, this.manifoldsPtr.size() - 1);
        this.manifoldsPtr.get((int)n).index1a = n;
        this.manifoldsPtr.remove(this.manifoldsPtr.size() - 1);
        Pools.MANIFOLDS.release((Object[])new PersistentManifold[]{persistentManifold});
    }

    @Override
    public boolean needsCollision(CollisionObject collisionObject, CollisionObject collisionObject2) {
        assert (collisionObject != null);
        assert (collisionObject2 != null);
        boolean bl = true;
        if (!this.staticWarningReported && (collisionObject.isStaticObject() || collisionObject.isKinematicObject()) && (collisionObject2.isStaticObject() || collisionObject2.isKinematicObject())) {
            this.staticWarningReported = true;
            System.err.println("warning CollisionDispatcher.needsCollision: static-static collision!");
        }
        if (!collisionObject.isActive() && !collisionObject2.isActive()) {
            bl = false;
        } else if (!collisionObject.checkCollideWith(collisionObject2)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean needsResponse(CollisionObject collisionObject, CollisionObject collisionObject2) {
        boolean bl = collisionObject.hasContactResponse() && collisionObject2.hasContactResponse();
        bl = bl && (!collisionObject.isStaticOrKinematicObject() || !collisionObject2.isStaticOrKinematicObject());
        return bl;
    }

    @Override
    public void dispatchAllCollisionPairs(OverlappingPairCache overlappingPairCache, DispatcherInfo dispatcherInfo, Dispatcher dispatcher) {
        this.collisionPairCallback.init(dispatcherInfo, this);
        overlappingPairCache.processAllOverlappingPairs(this.collisionPairCallback, dispatcher);
    }

    @Override
    public int getNumManifolds() {
        return this.manifoldsPtr.size();
    }

    @Override
    public PersistentManifold getManifoldByIndexInternal(int n) {
        return this.manifoldsPtr.get(n);
    }

    @Override
    public ArrayList<PersistentManifold> getInternalManifoldPointer() {
        return this.manifoldsPtr;
    }

    private static class CollisionPairCallback
    implements OverlapCallback {
        private DispatcherInfo dispatchInfo;
        private CollisionDispatcher dispatcher;

        private CollisionPairCallback() {
        }

        public void init(DispatcherInfo dispatcherInfo, CollisionDispatcher collisionDispatcher) {
            this.dispatchInfo = dispatcherInfo;
            this.dispatcher = collisionDispatcher;
        }

        @Override
        public boolean processOverlap(BroadphasePair broadphasePair) {
            this.dispatcher.getNearCallback().handleCollision(broadphasePair, this.dispatcher, this.dispatchInfo);
            return false;
        }
    }
}

