/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.broadphase.DispatchFunc;
import com.bulletphysics.collision.broadphase.DispatcherInfo;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.dispatch.NearCallback;

public class DefaultNearCallback
extends NearCallback {
    private final ManifoldResult contactPointResult = new ManifoldResult();

    @Override
    public void handleCollision(BroadphasePair broadphasePair, CollisionDispatcher collisionDispatcher, DispatcherInfo dispatcherInfo) {
        CollisionObject collisionObject = (CollisionObject)broadphasePair.pProxy0.clientObject;
        CollisionObject collisionObject2 = (CollisionObject)broadphasePair.pProxy1.clientObject;
        if (collisionDispatcher.needsCollision(collisionObject, collisionObject2)) {
            if (broadphasePair.algorithm == null) {
                broadphasePair.algorithm = collisionDispatcher.findAlgorithm(collisionObject, collisionObject2);
            }
            if (broadphasePair.algorithm != null) {
                this.contactPointResult.init(collisionObject, collisionObject2);
                if (dispatcherInfo.dispatchFunc == DispatchFunc.DISPATCH_DISCRETE) {
                    broadphasePair.algorithm.processCollision(collisionObject, collisionObject2, this.contactPointResult);
                } else {
                    float f = broadphasePair.algorithm.calculateTimeOfImpact(collisionObject, collisionObject2, this.contactPointResult);
                    if (dispatcherInfo.timeOfImpact > f) {
                        dispatcherInfo.timeOfImpact = f;
                    }
                }
            }
        }
    }
}

