/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionObjectType;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.AabbUtil2;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import java.util.ArrayList;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class GhostObject
extends CollisionObject {
    protected ArrayList<CollisionObject> overlappingObjects = new ArrayList();

    public GhostObject() {
        this.internalType = CollisionObjectType.GHOST_OBJECT;
    }

    public void addOverlappingObjectInternal(BroadphaseProxy broadphaseProxy, BroadphaseProxy broadphaseProxy2) {
        CollisionObject collisionObject = (CollisionObject)broadphaseProxy.clientObject;
        assert (collisionObject != null);
        int n = this.overlappingObjects.indexOf(collisionObject);
        if (n == -1) {
            this.overlappingObjects.add(collisionObject);
        }
    }

    public void removeOverlappingObjectInternal(BroadphaseProxy broadphaseProxy, Dispatcher dispatcher, BroadphaseProxy broadphaseProxy2) {
        CollisionObject collisionObject = (CollisionObject)broadphaseProxy.clientObject;
        assert (collisionObject != null);
        int n = this.overlappingObjects.indexOf(collisionObject);
        if (n != -1) {
            this.overlappingObjects.set(n, this.overlappingObjects.get(this.overlappingObjects.size() - 1));
            this.overlappingObjects.remove(this.overlappingObjects.size() - 1);
        }
    }

    public void convexSweepTest(ConvexShape convexShape, Transform transform, Transform transform2, CollisionWorld.ConvexResultCallback convexResultCallback, float f) {
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        Transform transform4 = (Transform)Pools.TRANSFORMS.get();
        transform3.set(transform);
        transform4.set(transform2);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Object object = (Vector3f)Pools.VECTORS.get();
        Vector3f object22 = (Vector3f)Pools.VECTORS.get();
        TransformUtil.calculateVelocity(transform3, transform4, 1.0f, (Vector3f)object, object22);
        Transform transform5 = (Transform)Pools.TRANSFORMS.get();
        transform5.setIdentity();
        Cloneable cloneable = transform3.getRotation((Quat4f)Pools.QUATS.get());
        transform5.setRotation((Quat4f)cloneable);
        convexShape.calculateTemporalAabb(transform5, (Vector3f)object, object22, 1.0f, vector3f, vector3f2);
        Pools.QUATS.release((Object[])new Quat4f[]{cloneable});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform5});
        Pools.VECTORS.release((Object[])new Vector3f[]{object, object22});
        object = (Transform)Pools.TRANSFORMS.get();
        for (CollisionObject collisionObject : this.overlappingObjects) {
            if (!convexResultCallback.needsCollision(collisionObject.getBroadphaseHandle())) continue;
            cloneable = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            collisionObject.getCollisionShape().getAabb(collisionObject.getWorldTransform((Transform)object), (Vector3f)cloneable, vector3f3);
            AabbUtil2.aabbExpand((Vector3f)cloneable, vector3f3, vector3f, vector3f2);
            float[] fArray = new float[]{1.0f};
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            if (AabbUtil2.rayAabb(transform.origin, transform2.origin, (Vector3f)cloneable, vector3f3, fArray, vector3f4)) {
                CollisionWorld.objectQuerySingle(convexShape, transform3, transform4, collisionObject, collisionObject.getCollisionShape(), collisionObject.getWorldTransform((Transform)object), convexResultCallback, f);
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{cloneable, vector3f3, vector3f4});
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{object, transform3, transform4});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    public void rayTest(Vector3f vector3f, Vector3f vector3f2, CollisionWorld.RayResultCallback rayResultCallback) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        transform.origin.set(vector3f);
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        transform2.setIdentity();
        transform2.origin.set(vector3f2);
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        for (CollisionObject collisionObject : this.overlappingObjects) {
            if (!rayResultCallback.needsCollision(collisionObject.getBroadphaseHandle())) continue;
            CollisionWorld.rayTestSingle(transform, transform2, collisionObject, collisionObject.getCollisionShape(), collisionObject.getWorldTransform(transform3), rayResultCallback);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform, transform2});
    }

    public int getNumOverlappingObjects() {
        return this.overlappingObjects.size();
    }

    public CollisionObject getOverlappingObject(int n) {
        return this.overlappingObjects.get(n);
    }

    public ArrayList<CollisionObject> getOverlappingPairs() {
        return this.overlappingObjects;
    }

    public static GhostObject upcast(CollisionObject collisionObject) {
        if (collisionObject.getInternalType() == CollisionObjectType.GHOST_OBJECT) {
            return (GhostObject)collisionObject;
        }
        return null;
    }
}

