/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.UnionFind;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimulationIslandManager {
    private final UnionFind unionFind = new UnionFind();
    private final ArrayList<PersistentManifold> islandmanifold = new ArrayList();
    private final ArrayList<CollisionObject> islandBodies = new ArrayList();

    public void initUnionFind(int n) {
        this.unionFind.reset(n);
    }

    public UnionFind getUnionFind() {
        return this.unionFind;
    }

    public void findUnions(Dispatcher dispatcher, CollisionWorld collisionWorld) {
        List<BroadphasePair> list = collisionWorld.getPairCache().getOverlappingPairArray();
        for (BroadphasePair broadphasePair : list) {
            CollisionObject collisionObject = (CollisionObject)broadphasePair.pProxy0.clientObject;
            CollisionObject collisionObject2 = (CollisionObject)broadphasePair.pProxy1.clientObject;
            if (collisionObject == null || !collisionObject.mergesSimulationIslands() || collisionObject2 == null || !collisionObject2.mergesSimulationIslands()) continue;
            this.unionFind.unite(collisionObject.getIslandTag(), collisionObject2.getIslandTag());
        }
    }

    public void updateActivationState(CollisionWorld collisionWorld, Dispatcher dispatcher) {
        this.initUnionFind(collisionWorld.getCollisionObjectArray().size());
        int n = 0;
        int n2 = 0;
        while (n2 < collisionWorld.getCollisionObjectArray().size()) {
            CollisionObject collisionObject = collisionWorld.getCollisionObjectArray().get(n2);
            collisionObject.setIslandTag(n);
            collisionObject.setCompanionId(-1);
            collisionObject.setHitFraction(1.0f);
            ++n;
            ++n2;
        }
        this.findUnions(dispatcher, collisionWorld);
    }

    public void storeIslandActivationState(CollisionWorld collisionWorld) {
        int n = 0;
        int n2 = 0;
        while (n2 < collisionWorld.getCollisionObjectArray().size()) {
            CollisionObject collisionObject = collisionWorld.getCollisionObjectArray().get(n2);
            if (!collisionObject.isStaticOrKinematicObject()) {
                collisionObject.setIslandTag(this.unionFind.find(n));
                collisionObject.setCompanionId(-1);
            } else {
                collisionObject.setIslandTag(-1);
                collisionObject.setCompanionId(-2);
            }
            ++n;
            ++n2;
        }
    }

    public void buildIslands(Dispatcher dispatcher, List<CollisionObject> list) {
        CollisionObject collisionObject;
        int n;
        int n2;
        this.islandmanifold.clear();
        this.getUnionFind().sortIslands();
        int n3 = this.getUnionFind().getNumElements();
        int n4 = 1;
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            n2 = this.getUnionFind().getElement((int)n5).id;
            n4 = n5 + 1;
            while (n4 < n3 && this.getUnionFind().getElement((int)n4).id == n2) {
                ++n4;
            }
            n = 1;
            int n7 = n5;
            while (n7 < n4) {
                n6 = this.getUnionFind().getElement((int)n7).sz;
                collisionObject = list.get(n6);
                if (collisionObject.getIslandTag() != n2) {
                    collisionObject.getIslandTag();
                }
                assert (collisionObject.getIslandTag() == n2 || collisionObject.getIslandTag() == -1);
                if (collisionObject.getIslandTag() == n2) {
                    if (collisionObject.getActivationState() == 1) {
                        n = 0;
                    }
                    if (collisionObject.getActivationState() == 4) {
                        n = 0;
                    }
                }
                ++n7;
            }
            if (n != 0) {
                n7 = n5;
                while (n7 < n4) {
                    n6 = this.getUnionFind().getElement((int)n7).sz;
                    collisionObject = list.get(n6);
                    if (collisionObject.getIslandTag() != n2) {
                        collisionObject.getIslandTag();
                    }
                    assert (collisionObject.getIslandTag() == n2 || collisionObject.getIslandTag() == -1);
                    if (collisionObject.getIslandTag() == n2) {
                        collisionObject.setActivationState(2);
                    }
                    ++n7;
                }
            } else {
                n7 = n5;
                while (n7 < n4) {
                    n6 = this.getUnionFind().getElement((int)n7).sz;
                    collisionObject = list.get(n6);
                    if (collisionObject.getIslandTag() != n2) {
                        collisionObject.getIslandTag();
                    }
                    assert (collisionObject.getIslandTag() == n2 || collisionObject.getIslandTag() == -1);
                    if (collisionObject.getIslandTag() == n2 && collisionObject.getActivationState() == 2) {
                        collisionObject.setActivationState(3);
                    }
                    ++n7;
                }
            }
            n5 = n4;
        }
        n = dispatcher.getNumManifolds();
        n2 = 0;
        while (n2 < n) {
            PersistentManifold persistentManifold = dispatcher.getManifoldByIndexInternal(n2);
            if (persistentManifold != null) {
                CollisionObject collisionObject2 = (CollisionObject)persistentManifold.getBody0();
                collisionObject = (CollisionObject)persistentManifold.getBody1();
                if (collisionObject != null && collisionObject2 != null && (collisionObject2.getActivationState() != 2 || collisionObject.getActivationState() != 2)) {
                    if (collisionObject2.isKinematicObject() && collisionObject2.getActivationState() != 2) {
                        collisionObject.activate();
                    }
                    if (collisionObject.isKinematicObject() && collisionObject.getActivationState() != 2) {
                        collisionObject2.activate();
                    }
                    if (dispatcher.needsResponse(collisionObject2, collisionObject)) {
                        this.islandmanifold.add(persistentManifold);
                    }
                }
            }
            ++n2;
        }
    }

    public void buildAndProcessIslands(Dispatcher dispatcher, List<CollisionObject> list, IslandCallback islandCallback) {
        this.buildIslands(dispatcher, list);
        int n = 1;
        int n2 = this.getUnionFind().getNumElements();
        int n3 = this.islandmanifold.size();
        Collections.sort(this.islandmanifold);
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            int n8;
            int n9 = this.getUnionFind().getElement((int)n6).id;
            boolean bl = false;
            n = n6;
            while (n < n2 && this.getUnionFind().getElement((int)n).id == n9) {
                n8 = this.getUnionFind().getElement((int)n).sz;
                CollisionObject collisionObject = list.get(n8);
                this.islandBodies.add(collisionObject);
                if (!collisionObject.isActive()) {
                    bl = true;
                }
                ++n;
            }
            n8 = 0;
            int n10 = -1;
            if (n4 < n3 && (n7 = this.islandmanifold.get(n4).getIslandId()) == n9) {
                n10 = n4;
                n5 = n4 + 1;
                while (n5 < n3 && n9 == this.islandmanifold.get(n5).getIslandId()) {
                    ++n5;
                }
                n8 = n5 - n4;
            }
            if (!bl) {
                islandCallback.processIsland(this.islandBodies, this.islandBodies.size(), this.islandmanifold, n10, n8, n9);
            }
            if (n8 != 0) {
                n4 = n5;
            }
            this.islandBodies.clear();
            n6 = n;
        }
    }

    public static abstract class IslandCallback {
        public abstract void processIsland(ArrayList<CollisionObject> var1, int var2, ArrayList<PersistentManifold> var3, int var4, int var5, int var6);
    }
}

