/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.BulletGlobals;
import com.bulletphysics.Pools;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class PersistentManifold
implements Comparable<PersistentManifold> {
    public static final int MANIFOLD_CACHE_SIZE = 4;
    private final ManifoldPoint[] pointCache = new ManifoldPoint[4];
    private CollisionObject body0;
    private CollisionObject body1;
    private int cachedPoints;
    public int index1a;

    public PersistentManifold() {
        int n = 0;
        while (n < this.pointCache.length) {
            this.pointCache[n] = new ManifoldPoint();
            ++n;
        }
    }

    public PersistentManifold(CollisionObject collisionObject, CollisionObject collisionObject2, int n) {
        int n2 = 0;
        while (n2 < this.pointCache.length) {
            this.pointCache[n2] = new ManifoldPoint();
            ++n2;
        }
        this.init(collisionObject, collisionObject2, n);
    }

    public int getIslandId() {
        CollisionObject collisionObject = (CollisionObject)this.getBody0();
        CollisionObject collisionObject2 = (CollisionObject)this.getBody1();
        int n = collisionObject.getIslandTag() >= 0 ? collisionObject.getIslandTag() : collisionObject2.getIslandTag();
        return n;
    }

    @Override
    public int compareTo(PersistentManifold persistentManifold) {
        return Integer.compare(this.getIslandId(), persistentManifold.getIslandId());
    }

    public void init(CollisionObject collisionObject, CollisionObject collisionObject2, int n) {
        this.body0 = collisionObject;
        this.body1 = collisionObject2;
        this.cachedPoints = 0;
        this.index1a = 0;
    }

    private int sortCachedPoints(ManifoldPoint manifoldPoint) {
        Vector3f vector3f;
        Vector3f vector3f2;
        Cloneable cloneable;
        int n = -1;
        float f = manifoldPoint.getDistance();
        int n2 = 0;
        while (n2 < 4) {
            if (this.pointCache[n2].getDistance() < f) {
                n = n2;
                f = this.pointCache[n2].getDistance();
            }
            ++n2;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (n != 0) {
            cloneable = (Vector3f)Pools.VECTORS.get((Object)manifoldPoint.localPointA);
            ((Tuple3f)cloneable).sub(this.pointCache[1].localPointA);
            vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.pointCache[3].localPointA);
            vector3f2.sub(this.pointCache[2].localPointA);
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.cross((Vector3f)cloneable, vector3f2);
            f2 = vector3f.lengthSquared();
            Pools.VECTORS.release((Object[])new Vector3f[]{cloneable, vector3f2, vector3f});
        }
        if (n != 1) {
            cloneable = (Vector3f)Pools.VECTORS.get((Object)manifoldPoint.localPointA);
            ((Tuple3f)cloneable).sub(this.pointCache[0].localPointA);
            vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.pointCache[3].localPointA);
            vector3f2.sub(this.pointCache[2].localPointA);
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.cross((Vector3f)cloneable, vector3f2);
            f3 = vector3f.lengthSquared();
            Pools.VECTORS.release((Object[])new Vector3f[]{cloneable, vector3f2, vector3f});
        }
        if (n != 2) {
            cloneable = (Vector3f)Pools.VECTORS.get((Object)manifoldPoint.localPointA);
            ((Tuple3f)cloneable).sub(this.pointCache[0].localPointA);
            vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.pointCache[3].localPointA);
            vector3f2.sub(this.pointCache[1].localPointA);
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.cross((Vector3f)cloneable, vector3f2);
            f4 = vector3f.lengthSquared();
            Pools.VECTORS.release((Object[])new Vector3f[]{cloneable, vector3f2, vector3f});
        }
        if (n != 3) {
            cloneable = (Vector3f)Pools.VECTORS.get((Object)manifoldPoint.localPointA);
            ((Tuple3f)cloneable).sub(this.pointCache[0].localPointA);
            vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.pointCache[2].localPointA);
            vector3f2.sub(this.pointCache[1].localPointA);
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.cross((Vector3f)cloneable, vector3f2);
            f5 = vector3f.lengthSquared();
            Pools.VECTORS.release((Object[])new Vector3f[]{cloneable, vector3f2, vector3f});
        }
        cloneable = (Vector4f)Pools.VECTORS4.get();
        ((Tuple4f)cloneable).set(f2, f3, f4, f5);
        int n3 = VectorUtil.closestAxis4((Vector4f)cloneable);
        Pools.VECTORS4.release((Object[])new Vector4f[]{cloneable});
        return n3;
    }

    public Object getBody0() {
        return this.body0;
    }

    public Object getBody1() {
        return this.body1;
    }

    public void setBodies(CollisionObject collisionObject, CollisionObject collisionObject2) {
        this.body0 = collisionObject;
        this.body1 = collisionObject2;
    }

    public int getNumContacts() {
        return this.cachedPoints;
    }

    public ManifoldPoint getContactPoint(int n) {
        return this.pointCache[n];
    }

    public float getContactBreakingThreshold() {
        return BulletGlobals.getContactBreakingThreshold();
    }

    public int getCacheEntry(ManifoldPoint manifoldPoint) {
        float f = this.getContactBreakingThreshold() * this.getContactBreakingThreshold();
        int n = this.getNumContacts();
        int n2 = -1;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        int n3 = 0;
        while (n3 < n) {
            ManifoldPoint manifoldPoint2 = this.pointCache[n3];
            vector3f.sub(manifoldPoint2.localPointA, manifoldPoint.localPointA);
            float f2 = vector3f.dot(vector3f);
            if (f2 < f) {
                f = f2;
                n2 = n3;
            }
            ++n3;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        return n2;
    }

    public int addManifoldPoint(ManifoldPoint manifoldPoint) {
        assert (this.validContactDistance(manifoldPoint));
        int n = this.getNumContacts();
        if (n == 4) {
            n = this.sortCachedPoints(manifoldPoint);
        } else {
            ++this.cachedPoints;
        }
        assert (this.pointCache[n].userPersistentData == null);
        this.pointCache[n].set(manifoldPoint);
        return n;
    }

    public void removeContactPoint(int n) {
        int n2 = this.getNumContacts() - 1;
        if (n != n2) {
            this.pointCache[n].set(this.pointCache[n2]);
            this.pointCache[n2].userPersistentData = null;
            this.pointCache[n2].appliedImpulse = 0.0f;
            this.pointCache[n2].lateralFrictionInitialized = false;
            this.pointCache[n2].appliedImpulseLateral1 = 0.0f;
            this.pointCache[n2].appliedImpulseLateral2 = 0.0f;
            this.pointCache[n2].lifeTime = 0;
        }
        assert (this.pointCache[n2].userPersistentData == null);
        --this.cachedPoints;
    }

    public void replaceContactPoint(ManifoldPoint manifoldPoint, int n) {
        assert (this.validContactDistance(manifoldPoint));
        int n2 = this.pointCache[n].getLifeTime();
        float f = this.pointCache[n].appliedImpulse;
        float f2 = this.pointCache[n].appliedImpulseLateral1;
        float f3 = this.pointCache[n].appliedImpulseLateral2;
        assert (n2 >= 0);
        Object object = this.pointCache[n].userPersistentData;
        this.pointCache[n].set(manifoldPoint);
        this.pointCache[n].userPersistentData = object;
        this.pointCache[n].appliedImpulse = f;
        this.pointCache[n].appliedImpulseLateral1 = f2;
        this.pointCache[n].appliedImpulseLateral2 = f3;
        this.pointCache[n].lifeTime = n2;
    }

    private boolean validContactDistance(ManifoldPoint manifoldPoint) {
        return manifoldPoint.distance1 <= this.getContactBreakingThreshold();
    }

    public void refreshContactPoints(Transform transform, Transform transform2) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        int n = this.getNumContacts() - 1;
        while (n >= 0) {
            ManifoldPoint manifoldPoint = this.pointCache[n];
            manifoldPoint.positionWorldOnA.set(manifoldPoint.localPointA);
            transform.transform(manifoldPoint.positionWorldOnA);
            manifoldPoint.positionWorldOnB.set(manifoldPoint.localPointB);
            transform2.transform(manifoldPoint.positionWorldOnB);
            vector3f.set(manifoldPoint.positionWorldOnA);
            vector3f.sub(manifoldPoint.positionWorldOnB);
            manifoldPoint.distance1 = vector3f.dot(manifoldPoint.normalWorldOnB);
            ++manifoldPoint.lifeTime;
            --n;
        }
        n = this.getNumContacts() - 1;
        while (n >= 0) {
            ManifoldPoint manifoldPoint = this.pointCache[n];
            if (!this.validContactDistance(manifoldPoint)) {
                this.removeContactPoint(n);
            } else {
                vector3f.scale(manifoldPoint.distance1, manifoldPoint.normalWorldOnB);
                vector3f3.sub(manifoldPoint.positionWorldOnA, vector3f);
                vector3f2.sub(manifoldPoint.positionWorldOnB, vector3f3);
                float f = vector3f2.dot(vector3f2);
                if (f > this.getContactBreakingThreshold() * this.getContactBreakingThreshold()) {
                    this.removeContactPoint(n);
                }
            }
            --n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3});
    }
}

