/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.PolyhedralConvexShape;
import com.bulletphysics.linearmath.AabbUtil2;
import com.bulletphysics.linearmath.ScalarUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class BoxShape
extends PolyhedralConvexShape {
    public BoxShape(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(this.getMargin(), this.getMargin(), this.getMargin());
        VectorUtil.mul(this.implicitShapeDimensions, vector3f, this.localScaling);
        this.implicitShapeDimensions.sub(vector3f2);
    }

    public Vector3f getHalfExtentsWithMargin(Vector3f vector3f) {
        Vector3f vector3f2 = this.getHalfExtentsWithoutMargin(vector3f);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(this.getMargin(), this.getMargin(), this.getMargin());
        vector3f2.add(vector3f3);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
        return vector3f;
    }

    public Vector3f getHalfExtentsWithoutMargin(Vector3f vector3f) {
        vector3f.set(this.implicitShapeDimensions);
        return vector3f;
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.BOX_SHAPE_PROXYTYPE;
    }

    @Override
    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.getHalfExtentsWithoutMargin(vector3f2);
        float f = this.getMargin();
        vector3f3.x += f;
        vector3f3.y += f;
        vector3f3.z += f;
        vector3f2.set(ScalarUtil.fsel(vector3f.x, vector3f3.x, -vector3f3.x), ScalarUtil.fsel(vector3f.y, vector3f3.y, -vector3f3.y), ScalarUtil.fsel(vector3f.z, vector3f3.z, -vector3f3.z));
        return vector3f2;
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.getHalfExtentsWithoutMargin(vector3f2);
        vector3f2.set(ScalarUtil.fsel(vector3f.x, vector3f3.x, -vector3f3.x), ScalarUtil.fsel(vector3f.y, vector3f3.y, -vector3f3.y), ScalarUtil.fsel(vector3f.z, vector3f3.z, -vector3f3.z));
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        Vector3f vector3f = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
        int n2 = 0;
        while (n2 < n) {
            Vector3f vector3f2 = vector3fArray[n2];
            vector3fArray2[n2].set(ScalarUtil.fsel(vector3f2.x, vector3f.x, -vector3f.x), ScalarUtil.fsel(vector3f2.y, vector3f.y, -vector3f.y), ScalarUtil.fsel(vector3f2.z, vector3f.z, -vector3f.z));
            ++n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    @Override
    public void setMargin(float f) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(this.getMargin(), this.getMargin(), this.getMargin());
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.add(this.implicitShapeDimensions, vector3f);
        super.setMargin(f);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(this.getMargin(), this.getMargin(), this.getMargin());
        this.implicitShapeDimensions.sub(vector3f2, vector3f3);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f3, vector3f2});
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(this.getMargin(), this.getMargin(), this.getMargin());
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.add(this.implicitShapeDimensions, vector3f2);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.div(vector3f4, vector3f3, this.localScaling);
        super.setLocalScaling(vector3f);
        VectorUtil.mul(this.implicitShapeDimensions, vector3f4, this.localScaling);
        this.implicitShapeDimensions.sub(vector3f2);
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
        AabbUtil2.transformAabb(vector3f3, this.getMargin(), transform, vector3f, vector3f2);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        Vector3f vector3f2 = this.getHalfExtentsWithMargin((Vector3f)Pools.VECTORS.get());
        float f2 = 2.0f * vector3f2.x;
        float f3 = 2.0f * vector3f2.y;
        float f4 = 2.0f * vector3f2.z;
        vector3f.set(f / 12.0f * (f3 * f3 + f4 * f4), f / 12.0f * (f2 * f2 + f4 * f4), f / 12.0f * (f2 * f2 + f3 * f3));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
    }

    @Override
    public void getPlane(Vector3f vector3f, Vector3f vector3f2, int n) {
        Vector4f vector4f = (Vector4f)Pools.VECTORS4.get();
        this.getPlaneEquation(vector4f, n);
        vector3f.set(vector4f.x, vector4f.y, vector4f.z);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.negate(vector3f);
        this.localGetSupportingVertex(vector3f3, vector3f2);
        Pools.VECTORS4.release((Object[])new Vector4f[]{vector4f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
    }

    @Override
    public int getNumPlanes() {
        return 6;
    }

    @Override
    public int getNumVertices() {
        return 8;
    }

    @Override
    public int getNumEdges() {
        return 12;
    }

    @Override
    public void getVertex(int n, Vector3f vector3f) {
        Vector3f vector3f2 = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
        vector3f.set(vector3f2.x * (float)(1 - (n & 1)) - vector3f2.x * (float)(n & 1), vector3f2.y * (float)(1 - ((n & 2) >> 1)) - vector3f2.y * (float)((n & 2) >> 1), vector3f2.z * (float)(1 - ((n & 4) >> 2)) - vector3f2.z * (float)((n & 4) >> 2));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
    }

    public void getPlaneEquation(Vector4f vector4f, int n) {
        Vector3f vector3f = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
        switch (n) {
            case 0: {
                vector4f.set(1.0f, 0.0f, 0.0f, -vector3f.x);
                break;
            }
            case 1: {
                vector4f.set(-1.0f, 0.0f, 0.0f, -vector3f.x);
                break;
            }
            case 2: {
                vector4f.set(0.0f, 1.0f, 0.0f, -vector3f.y);
                break;
            }
            case 3: {
                vector4f.set(0.0f, -1.0f, 0.0f, -vector3f.y);
                break;
            }
            case 4: {
                vector4f.set(0.0f, 0.0f, 1.0f, -vector3f.z);
                break;
            }
            case 5: {
                vector4f.set(0.0f, 0.0f, -1.0f, -vector3f.z);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    @Override
    public void getEdge(int n, Vector3f vector3f, Vector3f vector3f2) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                n3 = 1;
                break;
            }
            case 1: {
                n2 = 0;
                n3 = 2;
                break;
            }
            case 2: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 4: {
                n2 = 0;
                n3 = 4;
                break;
            }
            case 5: {
                n2 = 1;
                n3 = 5;
                break;
            }
            case 6: {
                n2 = 2;
                n3 = 6;
                break;
            }
            case 7: {
                n2 = 3;
                n3 = 7;
                break;
            }
            case 8: {
                n2 = 4;
                n3 = 5;
                break;
            }
            case 9: {
                n2 = 4;
                n3 = 6;
                break;
            }
            case 10: {
                n2 = 5;
                n3 = 7;
                break;
            }
            case 11: {
                n2 = 6;
                n3 = 7;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.getVertex(n2, vector3f);
        this.getVertex(n3, vector3f2);
    }

    @Override
    public boolean isInside(Vector3f vector3f, float f) {
        Vector3f vector3f2 = this.getHalfExtentsWithoutMargin((Vector3f)Pools.VECTORS.get());
        boolean bl = vector3f.x <= vector3f2.x + f && vector3f.x >= -vector3f2.x - f && vector3f.y <= vector3f2.y + f && vector3f.y >= -vector3f2.y - f && vector3f.z <= vector3f2.z + f && vector3f.z >= -vector3f2.z - f;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
        return bl;
    }

    @Override
    public String getName() {
        return "Box";
    }

    @Override
    public int getNumPreferredPenetrationDirections() {
        return 6;
    }

    @Override
    public void getPreferredPenetrationDirection(int n, Vector3f vector3f) {
        switch (n) {
            case 0: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                vector3f.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                vector3f.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case 4: {
                vector3f.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case 5: {
                vector3f.set(0.0f, 0.0f, -1.0f);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

