/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShapeChild;
import com.bulletphysics.collision.shapes.OptimizedBvh;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import java.util.ArrayList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class CompoundShape
implements CollisionShape {
    private final ArrayList<CompoundShapeChild> children = new ArrayList();
    private final Vector3f localAabbMin = new Vector3f(1.0E30f, 1.0E30f, 1.0E30f);
    private final Vector3f localAabbMax = new Vector3f(-1.0E30f, -1.0E30f, -1.0E30f);
    private final OptimizedBvh aabbTree = null;
    private float collisionMargin = 0.0f;
    protected final Vector3f localScaling = new Vector3f(1.0f, 1.0f, 1.0f);

    public void addChildShape(Transform transform, CollisionShape collisionShape) {
        CompoundShapeChild compoundShapeChild = new CompoundShapeChild();
        compoundShapeChild.transform.set(transform);
        compoundShapeChild.childShape = collisionShape;
        compoundShapeChild.childShapeType = collisionShape.getShapeType();
        compoundShapeChild.childMargin = collisionShape.getMargin();
        this.children.add(compoundShapeChild);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        collisionShape.getAabb(transform, vector3f, vector3f2);
        VectorUtil.setMin(this.localAabbMin, vector3f);
        VectorUtil.setMax(this.localAabbMax, vector3f2);
    }

    public void removeChildShape(CollisionShape collisionShape) {
        boolean bl;
        block0: do {
            bl = true;
            int n = 0;
            while (n < this.children.size()) {
                if (this.children.get((int)n).childShape == collisionShape) {
                    this.children.remove(n);
                    bl = false;
                    continue block0;
                }
                ++n;
            }
        } while (!bl);
        this.recalculateLocalAabb();
    }

    public int getNumChildShapes() {
        return this.children.size();
    }

    public CollisionShape getChildShape(int n) {
        return this.children.get((int)n).childShape;
    }

    public Transform getChildTransform(int n, Transform transform) {
        transform.set(this.children.get((int)n).transform);
        return transform;
    }

    public ArrayList<CompoundShapeChild> getChildList() {
        return this.children;
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.sub(this.localAabbMax, this.localAabbMin);
        vector3f3.scale(0.5f);
        vector3f3.x += this.getMargin();
        vector3f3.y += this.getMargin();
        vector3f3.z += this.getMargin();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.add(this.localAabbMax, this.localAabbMin);
        vector3f4.scale(0.5f);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)vector3f4);
        transform.transform(vector3f5);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f6);
        vector3f7.x = vector3f6.dot(vector3f3);
        matrix3f.getRow(1, vector3f6);
        vector3f7.y = vector3f6.dot(vector3f3);
        matrix3f.getRow(2, vector3f6);
        vector3f7.z = vector3f6.dot(vector3f3);
        vector3f.sub(vector3f5, vector3f7);
        vector3f2.add(vector3f5, vector3f7);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f7, vector3f6, vector3f3});
    }

    public void recalculateLocalAabb() {
        this.localAabbMin.set(1.0E30f, 1.0E30f, 1.0E30f);
        this.localAabbMax.set(-1.0E30f, -1.0E30f, -1.0E30f);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        for (CompoundShapeChild compoundShapeChild : this.children) {
            compoundShapeChild.childShape.getAabb(compoundShapeChild.transform, vector3f, vector3f2);
            int n = 0;
            while (n < 3) {
                if (VectorUtil.getCoord(this.localAabbMin, n) > VectorUtil.getCoord(vector3f, n)) {
                    VectorUtil.setCoord(this.localAabbMin, n, VectorUtil.getCoord(vector3f, n));
                }
                if (VectorUtil.getCoord(this.localAabbMax, n) < VectorUtil.getCoord(vector3f2, n)) {
                    VectorUtil.setCoord(this.localAabbMax, n, VectorUtil.getCoord(vector3f2, n));
                }
                ++n;
            }
        }
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.set(vector3f);
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        vector3f.set(this.localScaling);
        return vector3f;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        this.getAabb(transform, vector3f2, vector3f3);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f3, vector3f2);
        vector3f4.scale(0.5f);
        float f2 = 2.0f * vector3f4.x;
        float f3 = 2.0f * vector3f4.y;
        float f4 = 2.0f * vector3f4.z;
        vector3f.x = f / 12.0f * (f3 * f3 + f4 * f4);
        vector3f.y = f / 12.0f * (f2 * f2 + f4 * f4);
        vector3f.z = f / 12.0f * (f2 * f2 + f3 * f3);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4});
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.COMPOUND_SHAPE_PROXYTYPE;
    }

    @Override
    public void setMargin(float f) {
        this.collisionMargin = f;
    }

    @Override
    public float getMargin() {
        return this.collisionMargin;
    }

    @Override
    public String getName() {
        return "Compound";
    }

    public OptimizedBvh getAabbTree() {
        return this.aabbTree;
    }

    public void calculatePrincipalAxisTransform(float[] fArray, Transform transform, Vector3f vector3f) {
        int n = this.children.size();
        float f = 0.0f;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(0.0f, 0.0f, 0.0f);
        int n2 = 0;
        while (n2 < n) {
            vector3f2.scaleAdd(fArray[n2], this.children.get((int)n2).transform.origin, vector3f2);
            f += fArray[n2];
            ++n2;
        }
        vector3f2.scale(1.0f / f);
        transform.origin.set(vector3f2);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        matrix3f.setZero();
        int n3 = 0;
        while (n3 < n) {
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            this.children.get((int)n3).childShape.calculateLocalInertia(fArray[n3], vector3f3);
            Transform transform2 = this.children.get((int)n3).transform;
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.sub(transform2.origin, vector3f2);
            Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get();
            matrix3f2.transpose(transform2.basis);
            matrix3f2.m00 *= vector3f3.x;
            matrix3f2.m01 *= vector3f3.x;
            matrix3f2.m02 *= vector3f3.x;
            matrix3f2.m10 *= vector3f3.y;
            matrix3f2.m11 *= vector3f3.y;
            matrix3f2.m12 *= vector3f3.y;
            matrix3f2.m20 *= vector3f3.z;
            matrix3f2.m21 *= vector3f3.z;
            matrix3f2.m22 *= vector3f3.z;
            matrix3f2.mul(transform2.basis, matrix3f2);
            matrix3f.add(matrix3f2);
            float f2 = vector3f4.lengthSquared();
            matrix3f2.setRow(0, f2, 0.0f, 0.0f);
            matrix3f2.setRow(1, 0.0f, f2, 0.0f);
            matrix3f2.setRow(2, 0.0f, 0.0f, f2);
            matrix3f2.m00 += vector3f4.x * -vector3f4.x;
            matrix3f2.m01 += vector3f4.y * -vector3f4.x;
            matrix3f2.m02 += vector3f4.z * -vector3f4.x;
            matrix3f2.m10 += vector3f4.x * -vector3f4.y;
            matrix3f2.m11 += vector3f4.y * -vector3f4.y;
            matrix3f2.m12 += vector3f4.z * -vector3f4.y;
            matrix3f2.m20 += vector3f4.x * -vector3f4.z;
            matrix3f2.m21 += vector3f4.y * -vector3f4.z;
            matrix3f2.m22 += vector3f4.z * -vector3f4.z;
            matrix3f.m00 += fArray[n3] * matrix3f2.m00;
            matrix3f.m01 += fArray[n3] * matrix3f2.m01;
            matrix3f.m02 += fArray[n3] * matrix3f2.m02;
            matrix3f.m10 += fArray[n3] * matrix3f2.m10;
            matrix3f.m11 += fArray[n3] * matrix3f2.m11;
            matrix3f.m12 += fArray[n3] * matrix3f2.m12;
            matrix3f.m20 += fArray[n3] * matrix3f2.m20;
            matrix3f.m21 += fArray[n3] * matrix3f2.m21;
            matrix3f.m22 += fArray[n3] * matrix3f2.m22;
            Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f2});
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
            ++n3;
        }
        MatrixUtil.diagonalize(matrix3f, transform.basis, 1.0E-5f, 20);
        vector3f.set(matrix3f.m00, matrix3f.m11, matrix3f.m22);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
    }
}

