/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConvexInternalShape;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class ConeShape
extends ConvexInternalShape {
    private final float sinAngle;
    private final float radius;
    private final float height;
    private final int[] coneIndices = new int[3];

    public ConeShape(float f, float f2) {
        this.radius = f;
        this.height = f2;
        this.setConeUpIndex(1);
        this.sinAngle = f / (float)Math.sqrt(this.radius * this.radius + this.height * this.height);
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    private Vector3f coneLocalSupport(Vector3f vector3f, Vector3f vector3f2) {
        float f;
        float f2 = this.height * 0.5f;
        if (VectorUtil.getCoord(vector3f, this.coneIndices[1]) > vector3f.length() * this.sinAngle) {
            VectorUtil.setCoord(vector3f2, this.coneIndices[0], 0.0f);
            VectorUtil.setCoord(vector3f2, this.coneIndices[1], f2);
            VectorUtil.setCoord(vector3f2, this.coneIndices[2], 0.0f);
            return vector3f2;
        }
        float f3 = VectorUtil.getCoord(vector3f, this.coneIndices[0]);
        float f4 = (float)Math.sqrt(f3 * f3 + (f = VectorUtil.getCoord(vector3f, this.coneIndices[2])) * f);
        if (f4 > 1.1920929E-7f) {
            float f5 = this.radius / f4;
            VectorUtil.setCoord(vector3f2, this.coneIndices[0], VectorUtil.getCoord(vector3f, this.coneIndices[0]) * f5);
            VectorUtil.setCoord(vector3f2, this.coneIndices[1], -f2);
            VectorUtil.setCoord(vector3f2, this.coneIndices[2], VectorUtil.getCoord(vector3f, this.coneIndices[2]) * f5);
            return vector3f2;
        }
        VectorUtil.setCoord(vector3f2, this.coneIndices[0], 0.0f);
        VectorUtil.setCoord(vector3f2, this.coneIndices[1], -f2);
        VectorUtil.setCoord(vector3f2, this.coneIndices[2], 0.0f);
        return vector3f2;
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        return this.coneLocalSupport(vector3f, vector3f2);
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            Vector3f vector3f = vector3fArray[n2];
            this.coneLocalSupport(vector3f, vector3fArray2[n2]);
            ++n2;
        }
    }

    @Override
    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.coneLocalSupport(vector3f, vector3f2);
        if (this.getMargin() != 0.0f) {
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            if (vector3f4.lengthSquared() < 1.4210855E-14f) {
                vector3f4.set(-1.0f, -1.0f, -1.0f);
            }
            vector3f4.normalize();
            vector3f3.scaleAdd(this.getMargin(), vector3f4, vector3f3);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
        }
        return vector3f3;
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.CONE_SHAPE_PROXYTYPE;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        this.getAabb(transform, vector3f2, vector3f3);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f3, vector3f2);
        vector3f4.scale(0.5f);
        float f2 = this.getMargin();
        float f3 = 2.0f * (vector3f4.x + f2);
        float f4 = 2.0f * (vector3f4.y + f2);
        float f5 = 2.0f * (vector3f4.z + f2);
        float f6 = f3 * f3;
        float f7 = f4 * f4;
        float f8 = f5 * f5;
        float f9 = f * 0.08333333f;
        vector3f.set(f7 + f8, f6 + f8, f6 + f7);
        vector3f.scale(f9);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4});
    }

    @Override
    public String getName() {
        return "Cone";
    }

    protected void setConeUpIndex(int n) {
        switch (n) {
            case 0: {
                this.coneIndices[0] = 1;
                this.coneIndices[1] = 0;
                this.coneIndices[2] = 2;
                break;
            }
            case 1: {
                this.coneIndices[0] = 0;
                this.coneIndices[1] = 1;
                this.coneIndices[2] = 2;
                break;
            }
            case 2: {
                this.coneIndices[0] = 0;
                this.coneIndices[1] = 2;
                this.coneIndices[2] = 1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public int getConeUpIndex() {
        return this.coneIndices[1];
    }
}

