/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public interface VertexData {
    public int getVertexCount();

    public int getIndexCount();

    public <T extends Tuple3f> T getVertex(int var1, T var2);

    public void setVertex(int var1, float var2, float var3, float var4);

    default public void setVertex(int n, Tuple3f tuple3f) {
        this.setVertex(n, tuple3f.x, tuple3f.y, tuple3f.z);
    }

    public int getIndex(int var1);

    default public void getTriangle(int n, Vector3f vector3f, Vector3f[] vector3fArray) {
        int n2 = 0;
        while (n2 < 3) {
            this.getVertex(this.getIndex(n + n2), vector3fArray[n2]);
            VectorUtil.mul(vector3fArray[n2], vector3fArray[n2], vector3f);
            ++n2;
        }
    }
}

