/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.DispatcherInfo;
import com.bulletphysics.collision.broadphase.OverlappingPairCache;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.SimulationIslandManager;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.dynamics.ActionInterface;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorldType;
import com.bulletphysics.dynamics.InternalTickCallback;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverInfo;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.linearmath.ScalarUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import java.util.ArrayList;
import java.util.Comparator;
import javax.vecmath.Vector3f;

public class DiscreteDynamicsWorld
extends DynamicsWorld {
    protected ConstraintSolver constraintSolver;
    protected SimulationIslandManager islandManager;
    protected final ArrayList<TypedConstraint> constraints = new ArrayList();
    protected final Vector3f gravity = new Vector3f(0.0f, -10.0f, 0.0f);
    protected float localTime = 0.016666668f;
    protected boolean ownsIslandManager;
    protected boolean ownsConstraintSolver;
    protected ArrayList<RaycastVehicle> vehicles = new ArrayList();
    protected ArrayList<ActionInterface> actions = new ArrayList();
    protected int profileTimings = 0;
    protected InternalTickCallback preTickCallback;
    private final ArrayList<TypedConstraint> sortedConstraints = new ArrayList();
    private final InplaceSolverIslandCallback solverCallback = new InplaceSolverIslandCallback();
    private static final Comparator<TypedConstraint> sortConstraintOnIslandPredicate = (typedConstraint, typedConstraint2) -> {
        int n = DiscreteDynamicsWorld.getConstraintIslandId(typedConstraint2);
        int n2 = DiscreteDynamicsWorld.getConstraintIslandId(typedConstraint);
        return n2 < n ? -1 : 1;
    };

    public DiscreteDynamicsWorld(Dispatcher dispatcher, BroadphaseInterface broadphaseInterface, ConstraintSolver constraintSolver, CollisionConfiguration collisionConfiguration) {
        super(dispatcher, broadphaseInterface, collisionConfiguration);
        this.constraintSolver = constraintSolver;
        if (this.constraintSolver == null) {
            this.constraintSolver = new SequentialImpulseConstraintSolver();
            this.ownsConstraintSolver = true;
        } else {
            this.ownsConstraintSolver = false;
        }
        this.islandManager = new SimulationIslandManager();
        this.ownsIslandManager = true;
    }

    protected void saveKinematicState(float f) {
        for (CollisionObject collisionObject : this.collisionObjects) {
            RigidBody rigidBody = RigidBody.upcast(collisionObject);
            if (rigidBody == null || rigidBody.getActivationState() == 2 || !rigidBody.isKinematicObject()) continue;
            rigidBody.saveKinematicState(f);
        }
    }

    @Override
    public void clearForces() {
        for (CollisionObject collisionObject : this.collisionObjects) {
            RigidBody rigidBody = RigidBody.upcast(collisionObject);
            if (rigidBody == null) continue;
            rigidBody.clearForces();
        }
    }

    public void applyGravity() {
        for (CollisionObject collisionObject : this.collisionObjects) {
            RigidBody rigidBody = RigidBody.upcast(collisionObject);
            if (rigidBody == null || !rigidBody.isActive()) continue;
            rigidBody.applyGravity();
        }
    }

    protected void synchronizeMotionStates() {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        for (CollisionObject collisionObject : this.collisionObjects) {
            RigidBody rigidBody = RigidBody.upcast(collisionObject);
            if (rigidBody == null || rigidBody.getMotionState() == null || rigidBody.isStaticOrKinematicObject()) continue;
            TransformUtil.integrateTransform(rigidBody.getInterpolationWorldTransform(transform2), rigidBody.getInterpolationLinearVelocity(vector3f), rigidBody.getInterpolationAngularVelocity(vector3f2), this.localTime * rigidBody.getHitFraction(), transform);
            rigidBody.getMotionState().setWorldTransform(transform);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    @Override
    public int stepSimulation(float f, int n, float f2) {
        int n2 = 0;
        if (n != 0) {
            this.localTime += f;
            if (this.localTime >= f2) {
                n2 = (int)(this.localTime / f2);
                this.localTime -= (float)n2 * f2;
            }
        } else {
            f2 = f;
            this.localTime = f;
            if (ScalarUtil.fuzzyZero(f)) {
                n2 = 0;
                n = 0;
            } else {
                n2 = 1;
                n = 1;
            }
        }
        if (n2 != 0) {
            this.saveKinematicState(f2);
            this.applyGravity();
            int n3 = n2 > n ? n : n2;
            int n4 = 0;
            while (n4 < n3) {
                this.internalSingleStepSimulation(f2);
                this.synchronizeMotionStates();
                ++n4;
            }
        }
        this.synchronizeMotionStates();
        this.clearForces();
        return n2;
    }

    protected void internalSingleStepSimulation(float f) {
        if (this.preTickCallback != null) {
            this.preTickCallback.internalTick(this, f);
        }
        this.predictUnconstraintMotion(f);
        DispatcherInfo dispatcherInfo = this.getDispatchInfo();
        dispatcherInfo.timeStep = f;
        dispatcherInfo.stepCount = 0;
        this.performDiscreteCollisionDetection();
        this.calculateSimulationIslands();
        this.getSolverInfo().timeStep = f;
        this.solveConstraints(this.getSolverInfo());
        this.integrateTransforms(f);
        this.updateActions(f);
        this.updateVehicles(f);
        this.updateActivationState(f);
        if (this.internalTickCallback != null) {
            this.internalTickCallback.internalTick(this, f);
        }
    }

    @Override
    public void setGravity(Vector3f vector3f) {
        this.gravity.set(vector3f);
        for (CollisionObject collisionObject : this.collisionObjects) {
            RigidBody rigidBody = RigidBody.upcast(collisionObject);
            if (rigidBody == null) continue;
            rigidBody.setGravity(vector3f);
        }
    }

    @Override
    public Vector3f getGravity(Vector3f vector3f) {
        vector3f.set(this.gravity);
        return vector3f;
    }

    @Override
    public void removeRigidBody(RigidBody rigidBody) {
        this.removeCollisionObject(rigidBody);
    }

    @Override
    public void addRigidBody(RigidBody rigidBody) {
        if (!rigidBody.isStaticOrKinematicObject()) {
            rigidBody.setGravity(this.gravity);
        }
        if (rigidBody.getCollisionShape() != null) {
            boolean bl = !rigidBody.isStaticObject() && !rigidBody.isKinematicObject();
            short s = bl ? (short)1 : 2;
            short s2 = bl ? (short)-1 : -3;
            this.addCollisionObject(rigidBody, s, s2);
        }
    }

    public void addRigidBody(RigidBody rigidBody, short s, short s2) {
        if (!rigidBody.isStaticOrKinematicObject()) {
            rigidBody.setGravity(this.gravity);
        }
        if (rigidBody.getCollisionShape() != null) {
            this.addCollisionObject(rigidBody, s, s2);
        }
    }

    public void updateActions(float f) {
        for (ActionInterface actionInterface : this.actions) {
            actionInterface.updateAction(this, f);
        }
    }

    protected void updateVehicles(float f) {
        for (RaycastVehicle raycastVehicle : this.vehicles) {
            raycastVehicle.updateVehicle(f);
        }
    }

    protected void updateActivationState(float f) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        try {
            for (CollisionObject collisionObject : this.collisionObjects) {
                RigidBody rigidBody = RigidBody.upcast(collisionObject);
                if (rigidBody == null) continue;
                rigidBody.updateDeactivation(f);
                if (rigidBody.wantsSleeping()) {
                    if (rigidBody.isStaticOrKinematicObject()) {
                        rigidBody.setActivationState(2);
                        continue;
                    }
                    if (rigidBody.getActivationState() == 1) {
                        rigidBody.setActivationState(3);
                    }
                    if (rigidBody.getActivationState() != 2) continue;
                    vector3f.set(0.0f, 0.0f, 0.0f);
                    rigidBody.setAngularVelocity(vector3f);
                    rigidBody.setLinearVelocity(vector3f);
                    continue;
                }
                if (rigidBody.getActivationState() == 4) continue;
                rigidBody.setActivationState(1);
            }
        }
        catch (Throwable throwable) {
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            throw throwable;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    @Override
    public void addConstraint(TypedConstraint typedConstraint, boolean bl) {
        this.constraints.add(typedConstraint);
        if (bl) {
            typedConstraint.getRigidBodyA().addConstraintRef(typedConstraint);
            typedConstraint.getRigidBodyB().addConstraintRef(typedConstraint);
        }
    }

    @Override
    public void removeConstraint(TypedConstraint typedConstraint) {
        this.constraints.remove(typedConstraint);
        typedConstraint.getRigidBodyA().removeConstraintRef(typedConstraint);
        typedConstraint.getRigidBodyB().removeConstraintRef(typedConstraint);
    }

    @Override
    public void addAction(ActionInterface actionInterface) {
        this.actions.add(actionInterface);
    }

    @Override
    public void removeAction(ActionInterface actionInterface) {
        this.actions.remove(actionInterface);
    }

    @Override
    public void addVehicle(RaycastVehicle raycastVehicle) {
        this.vehicles.add(raycastVehicle);
    }

    @Override
    public void removeVehicle(RaycastVehicle raycastVehicle) {
        this.vehicles.remove(raycastVehicle);
    }

    private static int getConstraintIslandId(TypedConstraint typedConstraint) {
        RigidBody rigidBody = typedConstraint.getRigidBodyA();
        RigidBody rigidBody2 = typedConstraint.getRigidBodyB();
        int n = rigidBody.getIslandTag() >= 0 ? rigidBody.getIslandTag() : rigidBody2.getIslandTag();
        return n;
    }

    protected void solveConstraints(ContactSolverInfo contactSolverInfo) {
        this.sortedConstraints.clear();
        int n = 0;
        while (n < this.constraints.size()) {
            this.sortedConstraints.add(this.constraints.get(n));
            ++n;
        }
        this.sortedConstraints.sort(sortConstraintOnIslandPredicate);
        ArrayList<TypedConstraint> arrayList = this.getNumConstraints() != 0 ? this.sortedConstraints : null;
        this.solverCallback.init(contactSolverInfo, this.constraintSolver, arrayList, this.sortedConstraints.size(), this.dispatcher1);
        this.constraintSolver.prepareSolve(this.getCollisionWorld().getNumCollisionObjects(), this.getCollisionWorld().getDispatcher().getNumManifolds());
        this.islandManager.buildAndProcessIslands(this.getCollisionWorld().getDispatcher(), this.getCollisionWorld().getCollisionObjectArray(), this.solverCallback);
        this.constraintSolver.allSolved(contactSolverInfo);
    }

    protected void calculateSimulationIslands() {
        this.getSimulationIslandManager().updateActivationState(this.getCollisionWorld(), this.getCollisionWorld().getDispatcher());
        int n = this.constraints.size();
        int n2 = 0;
        while (n2 < n) {
            TypedConstraint typedConstraint = this.constraints.get(n2);
            RigidBody rigidBody = typedConstraint.getRigidBodyA();
            RigidBody rigidBody2 = typedConstraint.getRigidBodyB();
            if (rigidBody != null && !rigidBody.isStaticOrKinematicObject() && rigidBody2 != null && !rigidBody2.isStaticOrKinematicObject() && (rigidBody.isActive() || rigidBody2.isActive())) {
                this.getSimulationIslandManager().getUnionFind().unite(rigidBody.getIslandTag(), rigidBody2.getIslandTag());
            }
            ++n2;
        }
        this.getSimulationIslandManager().storeIslandActivationState(this.getCollisionWorld());
    }

    protected void integrateTransforms(float f) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        try {
            for (CollisionObject collisionObject : this.collisionObjects) {
                RigidBody rigidBody = RigidBody.upcast(collisionObject);
                if (rigidBody == null) continue;
                rigidBody.setHitFraction(1.0f);
                if (!rigidBody.isActive() || rigidBody.isStaticOrKinematicObject()) continue;
                rigidBody.predictIntegratedTransform(f, transform2);
                vector3f.sub(transform2.origin, rigidBody.getWorldTransform((Transform)transform).origin);
                float f2 = vector3f.lengthSquared();
                if (rigidBody.getCcdSquareMotionThreshold() != 0.0f && rigidBody.getCcdSquareMotionThreshold() < f2 && rigidBody.getCollisionShape().isConvex()) {
                    ClosestNotMeConvexResultCallback closestNotMeConvexResultCallback = new ClosestNotMeConvexResultCallback(rigidBody, rigidBody.getWorldTransform((Transform)transform).origin, transform2.origin, this.getBroadphase().getOverlappingPairCache(), this.getDispatcher());
                    SphereShape sphereShape = new SphereShape(rigidBody.getCcdSweptSphereRadius());
                    closestNotMeConvexResultCallback.collisionFilterGroup = rigidBody.getBroadphaseProxy().collisionFilterGroup;
                    closestNotMeConvexResultCallback.collisionFilterMask = rigidBody.getBroadphaseProxy().collisionFilterMask;
                    this.convexSweepTest(sphereShape, rigidBody.getWorldTransform(transform), transform2, closestNotMeConvexResultCallback);
                    if (closestNotMeConvexResultCallback.hasHit() && closestNotMeConvexResultCallback.closestHitFraction > 1.0E-4f) {
                        rigidBody.setHitFraction(closestNotMeConvexResultCallback.closestHitFraction);
                        rigidBody.predictIntegratedTransform(f * rigidBody.getHitFraction(), transform2);
                        rigidBody.setHitFraction(0.0f);
                    }
                }
                rigidBody.proceedToTransform(transform2);
            }
        }
        catch (Throwable throwable) {
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
            throw throwable;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
    }

    protected void predictUnconstraintMotion(float f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        try {
            for (CollisionObject collisionObject : this.collisionObjects) {
                RigidBody rigidBody = RigidBody.upcast(collisionObject);
                if (rigidBody == null || rigidBody.isStaticOrKinematicObject() || !rigidBody.isActive()) continue;
                rigidBody.integrateVelocities(f);
                rigidBody.applyDamping(f);
                rigidBody.predictIntegratedTransform(f, rigidBody.getInterpolationWorldTransform(transform));
            }
        }
        catch (Throwable throwable) {
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
            throw throwable;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    @Override
    public void setConstraintSolver(ConstraintSolver constraintSolver) {
        this.ownsConstraintSolver = false;
        this.constraintSolver = constraintSolver;
    }

    @Override
    public ConstraintSolver getConstraintSolver() {
        return this.constraintSolver;
    }

    @Override
    public int getNumConstraints() {
        return this.constraints.size();
    }

    @Override
    public TypedConstraint getConstraint(int n) {
        return this.constraints.get(n);
    }

    @Override
    public int getNumActions() {
        return this.actions.size();
    }

    @Override
    public ActionInterface getAction(int n) {
        return this.actions.get(n);
    }

    public SimulationIslandManager getSimulationIslandManager() {
        return this.islandManager;
    }

    public CollisionWorld getCollisionWorld() {
        return this;
    }

    @Override
    public DynamicsWorldType getWorldType() {
        return DynamicsWorldType.DISCRETE_DYNAMICS_WORLD;
    }

    public void setNumTasks(int n) {
    }

    public void setPreTickCallback(InternalTickCallback internalTickCallback) {
        this.preTickCallback = internalTickCallback;
    }

    private static class ClosestNotMeConvexResultCallback
    extends CollisionWorld.ClosestConvexResultCallback {
        private final CollisionObject me;
        private final float allowedPenetration = 0.0f;
        private final OverlappingPairCache pairCache;
        private final Dispatcher dispatcher;

        public ClosestNotMeConvexResultCallback(CollisionObject collisionObject, Vector3f vector3f, Vector3f vector3f2, OverlappingPairCache overlappingPairCache, Dispatcher dispatcher) {
            super(vector3f, vector3f2);
            this.me = collisionObject;
            this.pairCache = overlappingPairCache;
            this.dispatcher = dispatcher;
        }

        @Override
        public float addSingleResult(CollisionWorld.LocalConvexResult localConvexResult, boolean bl) {
            if (localConvexResult.hitCollisionObject == this.me) {
                return 1.0f;
            }
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f.sub(this.convexToWorld, this.convexFromWorld);
            vector3f2.set(0.0f, 0.0f, 0.0f);
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.sub(vector3f, vector3f2);
            if (localConvexResult.hitNormalLocal.dot(vector3f3) >= -0.0f) {
                return 1.0f;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3});
            return super.addSingleResult(localConvexResult, bl);
        }

        @Override
        public boolean needsCollision(BroadphaseProxy broadphaseProxy) {
            if (broadphaseProxy.clientObject == this.me) {
                return false;
            }
            if (!super.needsCollision(broadphaseProxy)) {
                return false;
            }
            CollisionObject collisionObject = (CollisionObject)broadphaseProxy.clientObject;
            if (this.dispatcher.needsResponse(this.me, collisionObject)) {
                ArrayList<PersistentManifold> arrayList = new ArrayList<PersistentManifold>();
                BroadphasePair broadphasePair = this.pairCache.findPair(this.me.getBroadphaseHandle(), broadphaseProxy);
                if (broadphasePair != null && broadphasePair.algorithm != null) {
                    broadphasePair.algorithm.getAllContactManifolds(arrayList);
                    for (PersistentManifold persistentManifold : arrayList) {
                        if (persistentManifold.getNumContacts() <= 0) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static class InplaceSolverIslandCallback
    extends SimulationIslandManager.IslandCallback {
        public ContactSolverInfo solverInfo;
        public ConstraintSolver solver;
        public ArrayList<TypedConstraint> sortedConstraints;
        public int numConstraints;
        public Dispatcher dispatcher;

        private InplaceSolverIslandCallback() {
        }

        public void init(ContactSolverInfo contactSolverInfo, ConstraintSolver constraintSolver, ArrayList<TypedConstraint> arrayList, int n, Dispatcher dispatcher) {
            this.solverInfo = contactSolverInfo;
            this.solver = constraintSolver;
            this.sortedConstraints = arrayList;
            this.numConstraints = n;
            this.dispatcher = dispatcher;
        }

        @Override
        public void processIsland(ArrayList<CollisionObject> arrayList, int n, ArrayList<PersistentManifold> arrayList2, int n2, int n3, int n4) {
            if (n4 < 0) {
                this.solver.solveGroup(arrayList, n, arrayList2, n2, n3, this.sortedConstraints, 0, this.numConstraints, this.solverInfo, this.dispatcher);
            } else {
                int n5 = -1;
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.numConstraints) {
                    if (DiscreteDynamicsWorld.getConstraintIslandId(this.sortedConstraints.get(n7)) == n4) {
                        n5 = n7;
                        break;
                    }
                    ++n7;
                }
                while (n7 < this.numConstraints) {
                    if (DiscreteDynamicsWorld.getConstraintIslandId(this.sortedConstraints.get(n7)) == n4) {
                        ++n6;
                    }
                    ++n7;
                }
                if (n3 + n6 > 0) {
                    this.solver.solveGroup(arrayList, n, arrayList2, n2, n3, this.sortedConstraints, n5, n6, this.solverInfo, this.dispatcher);
                }
            }
        }
    }
}

