/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics;

import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.dynamics.ActionInterface;
import com.bulletphysics.dynamics.DynamicsWorldType;
import com.bulletphysics.dynamics.InternalTickCallback;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverInfo;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import javax.vecmath.Vector3f;

public abstract class DynamicsWorld
extends CollisionWorld {
    protected InternalTickCallback internalTickCallback;
    protected Object worldUserInfo;
    protected final ContactSolverInfo solverInfo = new ContactSolverInfo();

    public DynamicsWorld(Dispatcher dispatcher, BroadphaseInterface broadphaseInterface, CollisionConfiguration collisionConfiguration) {
        super(dispatcher, broadphaseInterface, collisionConfiguration);
    }

    public final int stepSimulation(float f) {
        return this.stepSimulation(f, 1, 0.016666668f);
    }

    public final int stepSimulation(float f, int n) {
        return this.stepSimulation(f, n, 0.016666668f);
    }

    public abstract int stepSimulation(float var1, int var2, float var3);

    public final void addConstraint(TypedConstraint typedConstraint) {
        this.addConstraint(typedConstraint, false);
    }

    public void addConstraint(TypedConstraint typedConstraint, boolean bl) {
    }

    public void removeConstraint(TypedConstraint typedConstraint) {
    }

    public void addAction(ActionInterface actionInterface) {
    }

    public void removeAction(ActionInterface actionInterface) {
    }

    public void addVehicle(RaycastVehicle raycastVehicle) {
    }

    public void removeVehicle(RaycastVehicle raycastVehicle) {
    }

    public abstract void setGravity(Vector3f var1);

    public abstract Vector3f getGravity(Vector3f var1);

    public abstract void addRigidBody(RigidBody var1);

    public abstract void removeRigidBody(RigidBody var1);

    public abstract void setConstraintSolver(ConstraintSolver var1);

    public abstract ConstraintSolver getConstraintSolver();

    public int getNumConstraints() {
        return 0;
    }

    public TypedConstraint getConstraint(int n) {
        return null;
    }

    public int getNumActions() {
        return 0;
    }

    public ActionInterface getAction(int n) {
        return null;
    }

    public abstract DynamicsWorldType getWorldType();

    public abstract void clearForces();

    public void setInternalTickCallback(InternalTickCallback internalTickCallback, Object object) {
        this.internalTickCallback = internalTickCallback;
        this.worldUserInfo = object;
    }

    public void setWorldUserInfo(Object object) {
        this.worldUserInfo = object;
    }

    public Object getWorldUserInfo() {
        return this.worldUserInfo;
    }

    public ContactSolverInfo getSolverInfo() {
        return this.solverInfo;
    }
}

