/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics;

import com.bulletphysics.BulletGlobals;
import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionObjectType;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import java.util.ArrayList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class RigidBody
extends CollisionObject {
    protected static final float MAX_ANGVEL = 1.5707964f;
    protected final Matrix3f invInertiaTensorWorld = new Matrix3f();
    protected final Vector3f linearVelocity = new Vector3f();
    protected final Vector3f angularVelocity = new Vector3f();
    protected float inverseMass;
    protected float angularFactor;
    protected final Vector3f gravity = new Vector3f();
    protected final Vector3f invInertiaLocal = new Vector3f();
    protected final Vector3f totalForce = new Vector3f();
    protected final Vector3f totalTorque = new Vector3f();
    protected float linearDamping;
    protected float angularDamping;
    protected boolean additionalDamping;
    protected float additionalDampingFactor;
    protected float additionalLinearDampingThresholdSqr;
    protected float additionalAngularDampingThresholdSqr;
    protected float additionalAngularDampingFactor;
    protected float linearSleepingThreshold;
    protected float angularSleepingThreshold;
    protected MotionState optionalMotionState;
    protected final ArrayList<TypedConstraint> constraintRefs = new ArrayList();
    public int contactSolverType;
    public int frictionSolverType;
    protected static int uniqueId = 0;
    public int debugBodyId;

    public RigidBody(RigidBodyConstructionInfo rigidBodyConstructionInfo) {
        this.setupRigidBody(rigidBodyConstructionInfo);
    }

    public RigidBody(float f, MotionState motionState, CollisionShape collisionShape) {
        this(f, motionState, collisionShape, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public RigidBody(float f, MotionState motionState, CollisionShape collisionShape, Vector3f vector3f) {
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(f, motionState, collisionShape, vector3f);
        this.setupRigidBody(rigidBodyConstructionInfo);
    }

    protected void setupRigidBody(RigidBodyConstructionInfo rigidBodyConstructionInfo) {
        this.internalType = CollisionObjectType.RIGID_BODY;
        this.linearVelocity.set(0.0f, 0.0f, 0.0f);
        this.angularVelocity.set(0.0f, 0.0f, 0.0f);
        this.angularFactor = 1.0f;
        this.gravity.set(0.0f, 0.0f, 0.0f);
        this.totalForce.set(0.0f, 0.0f, 0.0f);
        this.totalTorque.set(0.0f, 0.0f, 0.0f);
        this.linearDamping = 0.0f;
        this.angularDamping = 0.5f;
        this.linearSleepingThreshold = rigidBodyConstructionInfo.linearSleepingThreshold;
        this.angularSleepingThreshold = rigidBodyConstructionInfo.angularSleepingThreshold;
        this.optionalMotionState = rigidBodyConstructionInfo.motionState;
        this.contactSolverType = 0;
        this.frictionSolverType = 0;
        this.additionalDamping = rigidBodyConstructionInfo.additionalDamping;
        this.additionalDampingFactor = rigidBodyConstructionInfo.additionalDampingFactor;
        this.additionalLinearDampingThresholdSqr = rigidBodyConstructionInfo.additionalLinearDampingThresholdSqr;
        this.additionalAngularDampingThresholdSqr = rigidBodyConstructionInfo.additionalAngularDampingThresholdSqr;
        this.additionalAngularDampingFactor = rigidBodyConstructionInfo.additionalAngularDampingFactor;
        if (this.optionalMotionState != null) {
            this.optionalMotionState.getWorldTransform(this.worldTransform);
        } else {
            this.worldTransform.set(rigidBodyConstructionInfo.startWorldTransform);
        }
        this.interpolationWorldTransform.set(this.worldTransform);
        this.interpolationLinearVelocity.set(0.0f, 0.0f, 0.0f);
        this.interpolationAngularVelocity.set(0.0f, 0.0f, 0.0f);
        this.friction = rigidBodyConstructionInfo.friction;
        this.restitution = rigidBodyConstructionInfo.restitution;
        this.setCollisionShape(rigidBodyConstructionInfo.collisionShape);
        this.debugBodyId = uniqueId++;
        this.setMassProps(rigidBodyConstructionInfo.mass, rigidBodyConstructionInfo.localInertia);
        this.setDamping(rigidBodyConstructionInfo.linearDamping, rigidBodyConstructionInfo.angularDamping);
        this.updateInertiaTensor();
    }

    public void destroy() {
        assert (this.constraintRefs.size() == 0);
    }

    public void proceedToTransform(Transform transform) {
        this.setCenterOfMassTransform(transform);
    }

    public static RigidBody upcast(CollisionObject collisionObject) {
        if (collisionObject.getInternalType() == CollisionObjectType.RIGID_BODY) {
            return (RigidBody)collisionObject;
        }
        return null;
    }

    public void predictIntegratedTransform(float f, Transform transform) {
        TransformUtil.integrateTransform(this.worldTransform, this.linearVelocity, this.angularVelocity, f, transform);
    }

    public void saveKinematicState(float f) {
        if (f != 0.0f) {
            if (this.getMotionState() != null) {
                this.getMotionState().getWorldTransform(this.worldTransform);
            }
            TransformUtil.calculateVelocity(this.interpolationWorldTransform, this.worldTransform, f, this.linearVelocity, this.angularVelocity);
            this.interpolationLinearVelocity.set(this.linearVelocity);
            this.interpolationAngularVelocity.set(this.angularVelocity);
            this.interpolationWorldTransform.set(this.worldTransform);
        }
    }

    public void applyGravity() {
        if (this.isStaticOrKinematicObject()) {
            return;
        }
        this.applyCentralForce(this.gravity);
    }

    public void setGravity(Vector3f vector3f) {
        if (this.inverseMass != 0.0f) {
            this.gravity.scale(1.0f / this.inverseMass, vector3f);
        }
    }

    public Vector3f getGravity(Vector3f vector3f) {
        vector3f.set(this.gravity);
        return vector3f;
    }

    public void setDamping(float f, float f2) {
        this.linearDamping = MiscUtil.GEN_clamped(f, 0.0f, 1.0f);
        this.angularDamping = MiscUtil.GEN_clamped(f2, 0.0f, 1.0f);
    }

    public float getLinearDamping() {
        return this.linearDamping;
    }

    public float getAngularDamping() {
        return this.angularDamping;
    }

    public float getLinearSleepingThreshold() {
        return this.linearSleepingThreshold;
    }

    public float getAngularSleepingThreshold() {
        return this.angularSleepingThreshold;
    }

    public void applyDamping(float f) {
        this.linearVelocity.scale((float)Math.pow(1.0f - this.linearDamping, f));
        this.angularVelocity.scale((float)Math.pow(1.0f - this.angularDamping, f));
        if (this.additionalDamping) {
            float f2;
            float f3;
            if (this.angularVelocity.lengthSquared() < this.additionalAngularDampingThresholdSqr && this.linearVelocity.lengthSquared() < this.additionalLinearDampingThresholdSqr) {
                this.angularVelocity.scale(this.additionalDampingFactor);
                this.linearVelocity.scale(this.additionalDampingFactor);
            }
            if ((f3 = this.linearVelocity.length()) < this.linearDamping) {
                f2 = 0.005f;
                if (f3 > f2) {
                    Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)this.linearVelocity);
                    vector3f.normalize();
                    vector3f.scale(f2);
                    this.linearVelocity.sub(vector3f);
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                } else {
                    this.linearVelocity.set(0.0f, 0.0f, 0.0f);
                }
            }
            if ((f2 = this.angularVelocity.length()) < this.angularDamping) {
                float f4 = 0.005f;
                if (f2 > f4) {
                    Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)this.angularVelocity);
                    vector3f.normalize();
                    vector3f.scale(f4);
                    this.angularVelocity.sub(vector3f);
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                } else {
                    this.angularVelocity.set(0.0f, 0.0f, 0.0f);
                }
            }
        }
    }

    public void setMassProps(float f, Vector3f vector3f) {
        if (f == 0.0f) {
            this.collisionFlags |= 1;
            this.inverseMass = 0.0f;
        } else {
            this.collisionFlags &= 0xFFFFFFFE;
            this.inverseMass = 1.0f / f;
        }
        this.invInertiaLocal.set(vector3f.x != 0.0f ? 1.0f / vector3f.x : 0.0f, vector3f.y != 0.0f ? 1.0f / vector3f.y : 0.0f, vector3f.z != 0.0f ? 1.0f / vector3f.z : 0.0f);
    }

    public float getInvMass() {
        return this.inverseMass;
    }

    public Matrix3f getInvInertiaTensorWorld(Matrix3f matrix3f) {
        matrix3f.set(this.invInertiaTensorWorld);
        return matrix3f;
    }

    public void integrateVelocities(float f) {
        if (this.isStaticOrKinematicObject()) {
            return;
        }
        this.linearVelocity.scaleAdd(this.inverseMass * f, this.totalForce, this.linearVelocity);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)this.totalTorque);
        this.invInertiaTensorWorld.transform(vector3f);
        this.angularVelocity.scaleAdd(f, vector3f, this.angularVelocity);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        float f2 = this.angularVelocity.length();
        if (f2 * f > 1.5707964f) {
            this.angularVelocity.scale(1.5707964f / f / f2);
        }
    }

    public void setCenterOfMassTransform(Transform transform) {
        if (this.isStaticOrKinematicObject()) {
            this.interpolationWorldTransform.set(this.worldTransform);
        } else {
            this.interpolationWorldTransform.set(transform);
        }
        this.getLinearVelocity(this.interpolationLinearVelocity);
        this.getAngularVelocity(this.interpolationAngularVelocity);
        this.worldTransform.set(transform);
        this.updateInertiaTensor();
    }

    public void applyCentralForce(Vector3f vector3f) {
        this.totalForce.add(vector3f);
    }

    public Vector3f getInvInertiaDiagLocal(Vector3f vector3f) {
        vector3f.set(this.invInertiaLocal);
        return vector3f;
    }

    public void setInvInertiaDiagLocal(Vector3f vector3f) {
        this.invInertiaLocal.set(vector3f);
    }

    public void setSleepingThresholds(float f, float f2) {
        this.linearSleepingThreshold = f;
        this.angularSleepingThreshold = f2;
    }

    public void applyTorque(Vector3f vector3f) {
        this.totalTorque.add(vector3f);
    }

    public void applyForce(Vector3f vector3f, Vector3f vector3f2) {
        this.applyCentralForce(vector3f);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.cross(vector3f2, vector3f);
        vector3f3.scale(this.angularFactor);
        this.applyTorque(vector3f3);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
    }

    public void applyCentralImpulse(Vector3f vector3f) {
        System.out.println("Ask to apply impulse : " + String.valueOf(vector3f));
        Vector3f vector3f2 = new Vector3f();
        vector3f2.add(this.linearVelocity);
        Vector3f vector3f3 = new Vector3f(vector3f.x * this.inverseMass, vector3f.y * this.inverseMass, vector3f.z * this.inverseMass);
        vector3f2.add(vector3f3);
        this.linearVelocity.set(vector3f2.x, vector3f2.y, vector3f2.z);
    }

    public void applyTorqueImpulse(Vector3f vector3f) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        this.invInertiaTensorWorld.transform(vector3f2);
        this.angularVelocity.add(vector3f2);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
    }

    public void applyImpulse(Vector3f vector3f, Vector3f vector3f2) {
        if (this.inverseMass != 0.0f) {
            this.applyCentralImpulse(vector3f);
            if (this.angularFactor != 0.0f) {
                Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
                vector3f3.cross(vector3f2, vector3f);
                vector3f3.scale(this.angularFactor);
                this.applyTorqueImpulse(vector3f3);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
            }
        }
    }

    public void internalApplyImpulse(Vector3f vector3f, Vector3f vector3f2, float f) {
        if (this.inverseMass != 0.0f) {
            this.linearVelocity.scaleAdd(f, vector3f, this.linearVelocity);
            if (this.angularFactor != 0.0f) {
                this.angularVelocity.scaleAdd(f * this.angularFactor, vector3f2, this.angularVelocity);
            }
        }
    }

    public void clearForces() {
        this.totalForce.set(0.0f, 0.0f, 0.0f);
        this.totalTorque.set(0.0f, 0.0f, 0.0f);
    }

    public void updateInertiaTensor() {
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        MatrixUtil.scale(matrix3f, this.worldTransform.basis, this.invInertiaLocal);
        Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get((Object)this.worldTransform.basis);
        matrix3f2.transpose();
        this.invInertiaTensorWorld.mul(matrix3f, matrix3f2);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f, matrix3f2});
    }

    public Vector3f getCenterOfMassPosition(Vector3f vector3f) {
        vector3f.set(this.worldTransform.origin);
        return vector3f;
    }

    public Quat4f getOrientation(Quat4f quat4f) {
        MatrixUtil.getRotation(this.worldTransform.basis, quat4f);
        return quat4f;
    }

    public Transform getCenterOfMassTransform(Transform transform) {
        transform.set(this.worldTransform);
        return transform;
    }

    public Vector3f getLinearVelocity(Vector3f vector3f) {
        vector3f.set(this.linearVelocity);
        return vector3f;
    }

    public Vector3f getAngularVelocity(Vector3f vector3f) {
        vector3f.set(this.angularVelocity);
        return vector3f;
    }

    public void setLinearVelocity(Vector3f vector3f) {
        assert (this.collisionFlags != 1);
        this.linearVelocity.set(vector3f);
    }

    public void setAngularVelocity(Vector3f vector3f) {
        assert (this.collisionFlags != 1);
        this.angularVelocity.set(vector3f);
    }

    public Vector3f getVelocityInLocalPoint(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = vector3f2;
        vector3f3.cross(this.angularVelocity, vector3f);
        vector3f3.add(this.linearVelocity);
        return vector3f2;
    }

    public void translate(Vector3f vector3f) {
        this.worldTransform.origin.add(vector3f);
    }

    public void getAabb(Vector3f vector3f, Vector3f vector3f2) {
        this.getCollisionShape().getAabb(this.worldTransform, vector3f, vector3f2);
    }

    public float computeImpulseDenominator(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.sub(vector3f, this.getCenterOfMassPosition((Vector3f)Pools.VECTORS.get()));
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.cross(vector3f3, vector3f2);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        MatrixUtil.transposeTransform(vector3f5, vector3f4, this.getInvInertiaTensorWorld(matrix3f));
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.cross(vector3f5, vector3f3);
        float f = this.inverseMass + vector3f2.dot(vector3f6);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4, vector3f5, vector3f6});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        return f;
    }

    public float computeAngularImpulseDenominator(Vector3f vector3f) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        MatrixUtil.transposeTransform(vector3f2, vector3f, this.getInvInertiaTensorWorld(matrix3f));
        float f = vector3f.dot(vector3f2);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        return f;
    }

    public void updateDeactivation(float f) {
        if (this.getActivationState() == 2 || this.getActivationState() == 4) {
            return;
        }
        Vector3f vector3f = this.getLinearVelocity((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f2 = this.getAngularVelocity((Vector3f)Pools.VECTORS.get());
        if (vector3f.lengthSquared() < this.linearSleepingThreshold * this.linearSleepingThreshold && vector3f2.lengthSquared() < this.angularSleepingThreshold * this.angularSleepingThreshold) {
            this.deactivationTime += f;
        } else {
            this.deactivationTime = 0.0f;
            this.setActivationState(0);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    public boolean wantsSleeping() {
        if (this.getActivationState() == 4) {
            return false;
        }
        if (BulletGlobals.isDeactivationDisabled() || BulletGlobals.getDeactivationTime() == 0.0f) {
            return false;
        }
        if (this.getActivationState() == 2 || this.getActivationState() == 3) {
            return true;
        }
        return this.deactivationTime > BulletGlobals.getDeactivationTime();
    }

    public BroadphaseProxy getBroadphaseProxy() {
        return this.broadphaseHandle;
    }

    public void setNewBroadphaseProxy(BroadphaseProxy broadphaseProxy) {
        this.broadphaseHandle = broadphaseProxy;
    }

    public MotionState getMotionState() {
        return this.optionalMotionState;
    }

    public void setMotionState(MotionState motionState) {
        this.optionalMotionState = motionState;
        if (this.optionalMotionState != null) {
            motionState.getWorldTransform(this.worldTransform);
        }
    }

    public void setAngularFactor(float f) {
        this.angularFactor = f;
    }

    public float getAngularFactor() {
        return this.angularFactor;
    }

    public boolean isInWorld() {
        return this.getBroadphaseProxy() != null;
    }

    @Override
    public boolean checkCollideWithOverride(CollisionObject collisionObject) {
        RigidBody rigidBody = RigidBody.upcast(collisionObject);
        if (rigidBody == null) {
            return true;
        }
        int n = 0;
        while (n < this.constraintRefs.size()) {
            TypedConstraint typedConstraint = this.constraintRefs.get(n);
            if (typedConstraint.getRigidBodyA() == rigidBody || typedConstraint.getRigidBodyB() == rigidBody) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void addConstraintRef(TypedConstraint typedConstraint) {
        int n = this.constraintRefs.indexOf(typedConstraint);
        if (n == -1) {
            this.constraintRefs.add(typedConstraint);
        }
        this.checkCollideWith = true;
    }

    public void removeConstraintRef(TypedConstraint typedConstraint) {
        this.constraintRefs.remove(typedConstraint);
        this.checkCollideWith = this.constraintRefs.size() > 0;
    }

    public TypedConstraint getConstraintRef(int n) {
        return this.constraintRefs.get(n);
    }

    public int getNumConstraintRefs() {
        return this.constraintRefs.size();
    }
}

