/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintPersistentData;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverFunc;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverInfo;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class ContactConstraint {
    public static final ContactSolverFunc resolveSingleCollision = new ContactSolverFunc(){

        @Override
        public float resolveContact(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
            return ContactConstraint.resolveSingleCollision(rigidBody, rigidBody2, manifoldPoint, contactSolverInfo);
        }
    };
    public static final ContactSolverFunc resolveSingleFriction = new ContactSolverFunc(){

        @Override
        public float resolveContact(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
            return ContactConstraint.resolveSingleFriction(rigidBody, rigidBody2, manifoldPoint, contactSolverInfo);
        }
    };
    public static final ContactSolverFunc resolveSingleCollisionCombined = new ContactSolverFunc(){

        @Override
        public float resolveContact(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
            return ContactConstraint.resolveSingleCollisionCombined(rigidBody, rigidBody2, manifoldPoint, contactSolverInfo);
        }
    };

    public static void resolveSingleBilateral(RigidBody rigidBody, Vector3f vector3f, RigidBody rigidBody2, Vector3f vector3f2, float f, Vector3f vector3f3, float[] fArray, float f2) {
        float f3;
        float f4 = vector3f3.lengthSquared();
        assert (Math.abs(f4) < 1.1f);
        if (f4 > 1.1f) {
            fArray[0] = 0.0f;
            return;
        }
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f, rigidBody.getCenterOfMassPosition(vector3f4));
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.sub(vector3f2, rigidBody2.getCenterOfMassPosition(vector3f4));
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        rigidBody.getVelocityInLocalPoint(vector3f5, vector3f7);
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        rigidBody2.getVelocityInLocalPoint(vector3f6, vector3f8);
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        vector3f9.sub(vector3f7, vector3f8);
        Matrix3f matrix3f = rigidBody.getCenterOfMassTransform((Transform)((Transform)Pools.TRANSFORMS.get())).basis;
        matrix3f.transpose();
        Matrix3f matrix3f2 = rigidBody2.getCenterOfMassTransform((Transform)((Transform)Pools.TRANSFORMS.get())).basis;
        matrix3f2.transpose();
        JacobianEntry jacobianEntry = (JacobianEntry)Pools.JACOBIANS.get();
        jacobianEntry.init(matrix3f, matrix3f2, vector3f5, vector3f6, vector3f3, rigidBody.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), rigidBody.getInvMass(), rigidBody2.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), rigidBody2.getInvMass());
        float f5 = jacobianEntry.getDiagonal();
        float f6 = 1.0f / f5;
        Vector3f vector3f10 = rigidBody.getAngularVelocity((Vector3f)Pools.VECTORS.get());
        matrix3f.transform(vector3f10);
        Vector3f vector3f11 = rigidBody2.getAngularVelocity((Vector3f)Pools.VECTORS.get());
        matrix3f2.transform(vector3f11);
        Vector3f vector3f12 = rigidBody.getLinearVelocity((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f13 = rigidBody2.getLinearVelocity((Vector3f)Pools.VECTORS.get());
        float f7 = jacobianEntry.getRelativeVelocity(vector3f12, vector3f10, vector3f13, vector3f11);
        Pools.JACOBIANS.release((Object[])new JacobianEntry[]{jacobianEntry});
        f7 = vector3f3.dot(vector3f9);
        float f8 = 0.2f;
        fArray[0] = f3 = -f8 * f7 * f6;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f10, vector3f11, vector3f12, vector3f13, vector3f9, vector3f7, vector3f8, vector3f4, vector3f5, vector3f6});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f, matrix3f2});
    }

    public static float resolveSingleCollision(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = manifoldPoint.getPositionWorldOnA((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f3 = manifoldPoint.getPositionWorldOnB((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = manifoldPoint.normalWorldOnB;
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f2, rigidBody.getCenterOfMassPosition(vector3f));
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.sub(vector3f3, rigidBody2.getCenterOfMassPosition(vector3f));
        Vector3f vector3f7 = rigidBody.getVelocityInLocalPoint(vector3f5, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f8 = rigidBody2.getVelocityInLocalPoint(vector3f6, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        vector3f9.sub(vector3f7, vector3f8);
        float f = vector3f4.dot(vector3f9);
        float f2 = 1.0f / contactSolverInfo.timeStep;
        float f3 = contactSolverInfo.erp;
        float f4 = f3 * f2;
        ConstraintPersistentData constraintPersistentData = (ConstraintPersistentData)manifoldPoint.userPersistentData;
        assert (constraintPersistentData != null);
        float f5 = constraintPersistentData.appliedImpulse;
        float f6 = constraintPersistentData.penetration;
        float f7 = f4 * -f6;
        float f8 = f7 * constraintPersistentData.jacDiagABInv;
        float f9 = constraintPersistentData.restitution - f;
        float f10 = f9 * constraintPersistentData.jacDiagABInv;
        float f11 = f8 + f10;
        float f12 = f5 + f11;
        constraintPersistentData.appliedImpulse = 0.0f > f12 ? 0.0f : f12;
        f11 = constraintPersistentData.appliedImpulse - f5;
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        if (rigidBody.getInvMass() != 0.0f) {
            vector3f10.scale(rigidBody.getInvMass(), manifoldPoint.normalWorldOnB);
            rigidBody.internalApplyImpulse(vector3f10, constraintPersistentData.angularComponentA, f11);
        }
        if (rigidBody2.getInvMass() != 0.0f) {
            vector3f10.scale(rigidBody2.getInvMass(), manifoldPoint.normalWorldOnB);
            rigidBody2.internalApplyImpulse(vector3f10, constraintPersistentData.angularComponentB, -f11);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f5, vector3f6, vector3f7, vector3f8, vector3f9, vector3f10});
        return f11;
    }

    public static float resolveSingleFriction(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = manifoldPoint.getPositionWorldOnA((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f3 = manifoldPoint.getPositionWorldOnB((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f2, rigidBody.getCenterOfMassPosition(vector3f));
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f3, rigidBody2.getCenterOfMassPosition(vector3f));
        ConstraintPersistentData constraintPersistentData = (ConstraintPersistentData)manifoldPoint.userPersistentData;
        assert (constraintPersistentData != null);
        float f = constraintPersistentData.friction;
        float f2 = constraintPersistentData.appliedImpulse * f;
        if (constraintPersistentData.appliedImpulse > 0.0f) {
            Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
            rigidBody.getVelocityInLocalPoint(vector3f4, vector3f6);
            Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
            rigidBody2.getVelocityInLocalPoint(vector3f5, vector3f7);
            Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
            vector3f8.sub(vector3f6, vector3f7);
            float f3 = constraintPersistentData.frictionWorldTangential0.dot(vector3f8);
            float f4 = -f3 * constraintPersistentData.jacDiagABInvTangent0;
            float f5 = constraintPersistentData.accumulatedTangentImpulse0;
            constraintPersistentData.accumulatedTangentImpulse0 = f5 + f4;
            constraintPersistentData.accumulatedTangentImpulse0 = Math.min(constraintPersistentData.accumulatedTangentImpulse0, f2);
            constraintPersistentData.accumulatedTangentImpulse0 = Math.max(constraintPersistentData.accumulatedTangentImpulse0, -f2);
            f4 = constraintPersistentData.accumulatedTangentImpulse0 - f5;
            f3 = constraintPersistentData.frictionWorldTangential1.dot(vector3f8);
            float f6 = -f3 * constraintPersistentData.jacDiagABInvTangent1;
            f5 = constraintPersistentData.accumulatedTangentImpulse1;
            constraintPersistentData.accumulatedTangentImpulse1 = f5 + f6;
            constraintPersistentData.accumulatedTangentImpulse1 = Math.min(constraintPersistentData.accumulatedTangentImpulse1, f2);
            constraintPersistentData.accumulatedTangentImpulse1 = Math.max(constraintPersistentData.accumulatedTangentImpulse1, -f2);
            f6 = constraintPersistentData.accumulatedTangentImpulse1 - f5;
            Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
            if (rigidBody.getInvMass() != 0.0f) {
                vector3f9.scale(rigidBody.getInvMass(), constraintPersistentData.frictionWorldTangential0);
                rigidBody.internalApplyImpulse(vector3f9, constraintPersistentData.frictionAngularComponent0A, f4);
                vector3f9.scale(rigidBody.getInvMass(), constraintPersistentData.frictionWorldTangential1);
                rigidBody.internalApplyImpulse(vector3f9, constraintPersistentData.frictionAngularComponent1A, f6);
            }
            if (rigidBody2.getInvMass() != 0.0f) {
                vector3f9.scale(rigidBody2.getInvMass(), constraintPersistentData.frictionWorldTangential0);
                rigidBody2.internalApplyImpulse(vector3f9, constraintPersistentData.frictionAngularComponent0B, -f4);
                vector3f9.scale(rigidBody2.getInvMass(), constraintPersistentData.frictionWorldTangential1);
                rigidBody2.internalApplyImpulse(vector3f9, constraintPersistentData.frictionAngularComponent1B, -f6);
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7, vector3f8, vector3f9});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4, vector3f5});
        return constraintPersistentData.appliedImpulse;
    }

    public static float resolveSingleCollisionCombined(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = manifoldPoint.getPositionWorldOnA((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f3 = manifoldPoint.getPositionWorldOnB((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = manifoldPoint.normalWorldOnB;
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f2, rigidBody.getCenterOfMassPosition(vector3f));
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.sub(vector3f3, rigidBody2.getCenterOfMassPosition(vector3f));
        Vector3f vector3f7 = rigidBody.getVelocityInLocalPoint(vector3f5, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f8 = rigidBody2.getVelocityInLocalPoint(vector3f6, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        vector3f9.sub(vector3f7, vector3f8);
        float f = vector3f4.dot(vector3f9);
        float f2 = 1.0f / contactSolverInfo.timeStep;
        float f3 = contactSolverInfo.erp;
        float f4 = f3 * f2;
        ConstraintPersistentData constraintPersistentData = (ConstraintPersistentData)manifoldPoint.userPersistentData;
        assert (constraintPersistentData != null);
        float f5 = constraintPersistentData.appliedImpulse;
        float f6 = constraintPersistentData.penetration;
        float f7 = f4 * -f6;
        float f8 = f7 * constraintPersistentData.jacDiagABInv;
        float f9 = constraintPersistentData.restitution - f;
        float f10 = f9 * constraintPersistentData.jacDiagABInv;
        float f11 = f8 + f10;
        float f12 = f5 + f11;
        constraintPersistentData.appliedImpulse = 0.0f > f12 ? 0.0f : f12;
        f11 = constraintPersistentData.appliedImpulse - f5;
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        if (rigidBody.getInvMass() != 0.0f) {
            vector3f10.scale(rigidBody.getInvMass(), manifoldPoint.normalWorldOnB);
            rigidBody.internalApplyImpulse(vector3f10, constraintPersistentData.angularComponentA, f11);
        }
        if (rigidBody2.getInvMass() != 0.0f) {
            vector3f10.scale(rigidBody2.getInvMass(), manifoldPoint.normalWorldOnB);
            rigidBody2.internalApplyImpulse(vector3f10, constraintPersistentData.angularComponentB, -f11);
        }
        rigidBody.getVelocityInLocalPoint(vector3f5, vector3f7);
        rigidBody2.getVelocityInLocalPoint(vector3f6, vector3f8);
        vector3f9.sub(vector3f7, vector3f8);
        f = vector3f4.dot(vector3f9);
        vector3f10.scale(f, vector3f4);
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        vector3f11.sub(vector3f9, vector3f10);
        float f13 = vector3f11.length();
        float f14 = constraintPersistentData.friction;
        if (constraintPersistentData.appliedImpulse > 0.0f && f13 > 1.1920929E-7f) {
            vector3f11.scale(1.0f / f13);
            Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
            vector3f12.cross(vector3f5, vector3f11);
            rigidBody.getInvInertiaTensorWorld((Matrix3f)Pools.MATRICES.get()).transform(vector3f12);
            Vector3f vector3f13 = (Vector3f)Pools.VECTORS.get();
            vector3f13.cross(vector3f6, vector3f11);
            rigidBody2.getInvInertiaTensorWorld((Matrix3f)Pools.MATRICES.get()).transform(vector3f13);
            Vector3f vector3f14 = (Vector3f)Pools.VECTORS.get();
            vector3f14.cross(vector3f12, vector3f5);
            Vector3f vector3f15 = (Vector3f)Pools.VECTORS.get();
            vector3f15.cross(vector3f13, vector3f6);
            vector3f10.add(vector3f14, vector3f15);
            float f15 = f13 / (rigidBody.getInvMass() + rigidBody2.getInvMass() + vector3f11.dot(vector3f10));
            float f16 = constraintPersistentData.appliedImpulse * f14;
            f15 = Math.min(f15, f16);
            f15 = Math.max(f15, -f16);
            vector3f10.scale(-f15, vector3f11);
            rigidBody.applyImpulse(vector3f10, vector3f5);
            vector3f10.scale(f15, vector3f11);
            rigidBody2.applyImpulse(vector3f10, vector3f6);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f12, vector3f13, vector3f14, vector3f15});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f10, vector3f, vector3f9, vector3f7, vector3f8, vector3f2, vector3f3, vector3f5, vector3f6});
        return f11;
    }

    public static float resolveSingleFrictionEmpty(RigidBody rigidBody, RigidBody rigidBody2, ManifoldPoint manifoldPoint, ContactSolverInfo contactSolverInfo) {
        return 0.0f;
    }
}

