/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.dynamics.constraintsolver.RotationalLimitMotor;
import com.bulletphysics.dynamics.constraintsolver.TranslationalLimitMotor;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraintType;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class Generic6DofConstraint
extends TypedConstraint {
    protected final Transform frameInA = new Transform();
    protected final Transform frameInB = new Transform();
    protected final JacobianEntry[] jacLinear = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    protected final JacobianEntry[] jacAng = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    protected final TranslationalLimitMotor linearLimits = new TranslationalLimitMotor();
    protected final RotationalLimitMotor[] angularLimits = new RotationalLimitMotor[]{new RotationalLimitMotor(), new RotationalLimitMotor(), new RotationalLimitMotor()};
    protected float timeStep;
    protected final Transform calculatedTransformA = new Transform();
    protected final Transform calculatedTransformB = new Transform();
    protected final Vector3f calculatedAxisAngleDiff = new Vector3f();
    protected final Vector3f[] calculatedAxis = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
    protected final Vector3f anchorPos = new Vector3f();
    protected boolean useLinearReferenceFrameA;

    public Generic6DofConstraint() {
        super(TypedConstraintType.D6_CONSTRAINT_TYPE);
        this.useLinearReferenceFrameA = true;
    }

    public Generic6DofConstraint(RigidBody rigidBody, RigidBody rigidBody2, Transform transform, Transform transform2, boolean bl) {
        super(TypedConstraintType.D6_CONSTRAINT_TYPE, rigidBody, rigidBody2);
        this.frameInA.set(transform);
        this.frameInB.set(transform2);
        this.useLinearReferenceFrameA = bl;
    }

    private static float getMatrixElem(Matrix3f matrix3f, int n) {
        int n2 = n % 3;
        int n3 = n / 3;
        return matrix3f.getElement(n2, n3);
    }

    private static boolean matrixToEulerXYZ(Matrix3f matrix3f, Vector3f vector3f) {
        if (Generic6DofConstraint.getMatrixElem(matrix3f, 2) < 1.0f) {
            if (Generic6DofConstraint.getMatrixElem(matrix3f, 2) > -1.0f) {
                vector3f.x = (float)Math.atan2(-Generic6DofConstraint.getMatrixElem(matrix3f, 5), Generic6DofConstraint.getMatrixElem(matrix3f, 8));
                vector3f.y = (float)Math.asin(Generic6DofConstraint.getMatrixElem(matrix3f, 2));
                vector3f.z = (float)Math.atan2(-Generic6DofConstraint.getMatrixElem(matrix3f, 1), Generic6DofConstraint.getMatrixElem(matrix3f, 0));
                return true;
            }
            vector3f.x = -((float)Math.atan2(Generic6DofConstraint.getMatrixElem(matrix3f, 3), Generic6DofConstraint.getMatrixElem(matrix3f, 4)));
            vector3f.y = -1.5707964f;
            vector3f.z = 0.0f;
            return false;
        }
        vector3f.x = (float)Math.atan2(Generic6DofConstraint.getMatrixElem(matrix3f, 3), Generic6DofConstraint.getMatrixElem(matrix3f, 4));
        vector3f.y = 1.5707964f;
        vector3f.z = 0.0f;
        return false;
    }

    protected void calculateAngleInfo() {
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get();
        matrix3f.set(this.calculatedTransformA.basis);
        MatrixUtil.invert(matrix3f);
        matrix3f2.mul(matrix3f, this.calculatedTransformB.basis);
        Generic6DofConstraint.matrixToEulerXYZ(matrix3f2, this.calculatedAxisAngleDiff);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        this.calculatedTransformB.basis.getColumn(0, vector3f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        this.calculatedTransformA.basis.getColumn(2, vector3f2);
        this.calculatedAxis[1].cross(vector3f2, vector3f);
        this.calculatedAxis[0].cross(this.calculatedAxis[1], vector3f2);
        this.calculatedAxis[2].cross(vector3f, this.calculatedAxis[1]);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f, matrix3f2});
    }

    public void calculateTransforms() {
        this.rbA.getCenterOfMassTransform(this.calculatedTransformA);
        this.calculatedTransformA.mul(this.frameInA);
        this.rbB.getCenterOfMassTransform(this.calculatedTransformB);
        this.calculatedTransformB.mul(this.frameInB);
        this.calculateAngleInfo();
    }

    protected void buildLinearJacobian(int n, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Matrix3f matrix3f = this.rbA.getCenterOfMassTransform((Transform)transform).basis;
        matrix3f.transpose();
        Matrix3f matrix3f2 = this.rbB.getCenterOfMassTransform((Transform)transform).basis;
        matrix3f2.transpose();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f2, this.rbA.getCenterOfMassPosition(vector3f4));
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.sub(vector3f3, this.rbB.getCenterOfMassPosition(vector3f4));
        this.jacLinear[n].init(matrix3f, matrix3f2, vector3f5, vector3f6, vector3f, this.rbA.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), this.rbA.getInvMass(), this.rbB.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), this.rbB.getInvMass());
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f5, vector3f6});
    }

    protected void buildAngularJacobian(int n, Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Matrix3f matrix3f = this.rbA.getCenterOfMassTransform((Transform)transform).basis;
        matrix3f.transpose();
        Matrix3f matrix3f2 = this.rbB.getCenterOfMassTransform((Transform)transform).basis;
        matrix3f2.transpose();
        this.jacAng[n].init(vector3f, matrix3f, matrix3f2, this.rbA.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), this.rbB.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()));
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public boolean testAngularLimitMotor(int n) {
        float f = VectorUtil.getCoord(this.calculatedAxisAngleDiff, n);
        this.angularLimits[n].testLimitValue(f);
        return this.angularLimits[n].needApplyTorques();
    }

    @Override
    public void buildJacobian() {
        this.linearLimits.accumulatedImpulse.set(0.0f, 0.0f, 0.0f);
        int n = 0;
        while (n < 3) {
            this.angularLimits[n].accumulatedImpulse = 0.0f;
            ++n;
        }
        this.calculateTransforms();
        this.calcAnchorPos();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)this.anchorPos);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.anchorPos);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        int n2 = 0;
        while (n2 < 3) {
            if (this.linearLimits.isLimited(n2)) {
                if (this.useLinearReferenceFrameA) {
                    this.calculatedTransformA.basis.getColumn(n2, vector3f3);
                } else {
                    this.calculatedTransformB.basis.getColumn(n2, vector3f3);
                }
                this.buildLinearJacobian(n2, vector3f3, vector3f, vector3f2);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 3) {
            if (this.testAngularLimitMotor(n2)) {
                this.getAxis(n2, vector3f3);
                this.buildAngularJacobian(n2, vector3f3);
            }
            ++n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    @Override
    public void solveConstraint(float f) {
        this.timeStep = f;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)this.calculatedTransformA.origin);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.calculatedTransformB.origin);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        int n = 0;
        while (n < 3) {
            if (this.linearLimits.isLimited(n)) {
                float f2 = 1.0f / this.jacLinear[n].getDiagonal();
                if (this.useLinearReferenceFrameA) {
                    this.calculatedTransformA.basis.getColumn(n, vector3f3);
                } else {
                    this.calculatedTransformB.basis.getColumn(n, vector3f3);
                }
                this.linearLimits.solveLinearAxis(this.timeStep, f2, this.rbA, vector3f, this.rbB, vector3f2, n, vector3f3, this.anchorPos);
            }
            ++n;
        }
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        n = 0;
        while (n < 3) {
            if (this.angularLimits[n].needApplyTorques()) {
                this.getAxis(n, vector3f4);
                float f3 = 1.0f / this.jacAng[n].getDiagonal();
                this.angularLimits[n].solveAngularLimits(this.timeStep, vector3f4, f3, this.rbA, this.rbB);
            }
            ++n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f4, vector3f3});
    }

    public void updateRHS(float f) {
    }

    public Vector3f getAxis(int n, Vector3f vector3f) {
        vector3f.set(this.calculatedAxis[n]);
        return vector3f;
    }

    public float getAngle(int n) {
        return VectorUtil.getCoord(this.calculatedAxisAngleDiff, n);
    }

    public Transform getCalculatedTransformA(Transform transform) {
        transform.set(this.calculatedTransformA);
        return transform;
    }

    public Transform getCalculatedTransformB(Transform transform) {
        transform.set(this.calculatedTransformB);
        return transform;
    }

    public Transform getFrameOffsetA(Transform transform) {
        transform.set(this.frameInA);
        return transform;
    }

    public Transform getFrameOffsetB(Transform transform) {
        transform.set(this.frameInB);
        return transform;
    }

    public void setLinearLowerLimit(Vector3f vector3f) {
        this.linearLimits.lowerLimit.set(vector3f);
    }

    public void setLinearUpperLimit(Vector3f vector3f) {
        this.linearLimits.upperLimit.set(vector3f);
    }

    public void setAngularLowerLimit(Vector3f vector3f) {
        this.angularLimits[0].loLimit = vector3f.x;
        this.angularLimits[1].loLimit = vector3f.y;
        this.angularLimits[2].loLimit = vector3f.z;
    }

    public void setAngularUpperLimit(Vector3f vector3f) {
        this.angularLimits[0].hiLimit = vector3f.x;
        this.angularLimits[1].hiLimit = vector3f.y;
        this.angularLimits[2].hiLimit = vector3f.z;
    }

    public RotationalLimitMotor getRotationalLimitMotor(int n) {
        return this.angularLimits[n];
    }

    public TranslationalLimitMotor getTranslationalLimitMotor() {
        return this.linearLimits;
    }

    public void setLimit(int n, float f, float f2) {
        if (n < 3) {
            VectorUtil.setCoord(this.linearLimits.lowerLimit, n, f);
            VectorUtil.setCoord(this.linearLimits.upperLimit, n, f2);
        } else {
            this.angularLimits[n - 3].loLimit = f;
            this.angularLimits[n - 3].hiLimit = f2;
        }
    }

    public boolean isLimited(int n) {
        if (n < 3) {
            return this.linearLimits.isLimited(n);
        }
        return this.angularLimits[n - 3].isLimited();
    }

    public void calcAnchorPos() {
        float f = this.rbA.getInvMass();
        float f2 = this.rbB.getInvMass();
        float f3 = f2 == 0.0f ? 1.0f : f / (f + f2);
        Vector3f vector3f = this.calculatedTransformA.origin;
        Vector3f vector3f2 = this.calculatedTransformB.origin;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f3.scale(f3, vector3f);
        vector3f4.scale(1.0f - f3, vector3f2);
        this.anchorPos.add(vector3f3, vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
    }
}

