/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class TranslationalLimitMotor {
    public final Vector3f lowerLimit = new Vector3f();
    public final Vector3f upperLimit = new Vector3f();
    public final Vector3f accumulatedImpulse = new Vector3f();
    public float limitSoftness;
    public float damping;
    public float restitution;

    public TranslationalLimitMotor() {
        this.lowerLimit.set(0.0f, 0.0f, 0.0f);
        this.upperLimit.set(0.0f, 0.0f, 0.0f);
        this.accumulatedImpulse.set(0.0f, 0.0f, 0.0f);
        this.limitSoftness = 0.7f;
        this.damping = 1.0f;
        this.restitution = 0.5f;
    }

    public TranslationalLimitMotor(TranslationalLimitMotor translationalLimitMotor) {
        this.lowerLimit.set(translationalLimitMotor.lowerLimit);
        this.upperLimit.set(translationalLimitMotor.upperLimit);
        this.accumulatedImpulse.set(translationalLimitMotor.accumulatedImpulse);
        this.limitSoftness = translationalLimitMotor.limitSoftness;
        this.damping = translationalLimitMotor.damping;
        this.restitution = translationalLimitMotor.restitution;
    }

    public boolean isLimited(int n) {
        return VectorUtil.getCoord(this.upperLimit, n) >= VectorUtil.getCoord(this.lowerLimit, n);
    }

    public float solveLinearAxis(float f, float f2, RigidBody rigidBody, Vector3f vector3f, RigidBody rigidBody2, Vector3f vector3f2, int n, Vector3f vector3f3, Vector3f vector3f4) {
        float f3;
        float f4;
        float f5;
        float f6;
        Vector3f vector3f5;
        Vector3f vector3f6;
        Vector3f vector3f7;
        Vector3f vector3f8;
        Vector3f vector3f9;
        Vector3f vector3f10;
        Vector3f vector3f11;
        block4: {
            block5: {
                vector3f11 = (Vector3f)Pools.VECTORS.get();
                vector3f10 = (Vector3f)Pools.VECTORS.get();
                vector3f9 = (Vector3f)Pools.VECTORS.get();
                vector3f9.sub(vector3f4, rigidBody.getCenterOfMassPosition(vector3f10));
                vector3f8 = (Vector3f)Pools.VECTORS.get();
                vector3f8.sub(vector3f4, rigidBody2.getCenterOfMassPosition(vector3f10));
                vector3f7 = rigidBody.getVelocityInLocalPoint(vector3f9, (Vector3f)Pools.VECTORS.get());
                vector3f6 = rigidBody2.getVelocityInLocalPoint(vector3f8, (Vector3f)Pools.VECTORS.get());
                vector3f5 = (Vector3f)Pools.VECTORS.get();
                vector3f5.sub(vector3f7, vector3f6);
                f6 = vector3f3.dot(vector3f5);
                vector3f11.sub(vector3f, vector3f2);
                f5 = -vector3f11.dot(vector3f3);
                f4 = -1.0E30f;
                f3 = 1.0E30f;
                float f7 = VectorUtil.getCoord(this.lowerLimit, n);
                float f8 = VectorUtil.getCoord(this.upperLimit, n);
                try {
                    if (!(f7 < f8)) break block4;
                    if (f5 > f8) {
                        f5 -= f8;
                        f4 = 0.0f;
                        break block4;
                    }
                    if (!(f5 < f7)) break block5;
                    f5 -= f7;
                    f3 = 0.0f;
                    break block4;
                }
                catch (Throwable throwable) {
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11, vector3f10, vector3f9, vector3f8, vector3f7, vector3f6, vector3f5});
                    throw throwable;
                }
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11, vector3f10, vector3f9, vector3f8, vector3f7, vector3f6, vector3f5});
            return 0.0f;
        }
        float f9 = this.limitSoftness * (this.restitution * f5 / f - this.damping * f6) * f2;
        float f10 = VectorUtil.getCoord(this.accumulatedImpulse, n);
        float f11 = f10 + f9;
        VectorUtil.setCoord(this.accumulatedImpulse, n, f11 > f3 ? 0.0f : (f11 < f4 ? 0.0f : f11));
        f9 = VectorUtil.getCoord(this.accumulatedImpulse, n) - f10;
        Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
        vector3f12.scale(f9, vector3f3);
        rigidBody.applyImpulse(vector3f12, vector3f9);
        vector3f11.negate(vector3f12);
        rigidBody2.applyImpulse(vector3f11, vector3f8);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f12});
        float f12 = f9;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11, vector3f10, vector3f9, vector3f8, vector3f7, vector3f6, vector3f5});
        return f12;
    }
}

