/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.vehicle;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.vehicle.WheelInfoConstructionInfo;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class WheelInfo {
    public final RaycastInfo raycastInfo = new RaycastInfo();
    public final Transform worldTransform = new Transform();
    public final Vector3f chassisConnectionPointCS = new Vector3f();
    public final Vector3f wheelDirectionCS = new Vector3f();
    public final Vector3f wheelAxleCS = new Vector3f();
    public float suspensionRestLength1;
    public float maxSuspensionTravelCm;
    public float maxSuspensionForce;
    public float wheelsRadius;
    public float suspensionStiffness;
    public float wheelsDampingCompression;
    public float wheelsDampingRelaxation;
    public float frictionSlip;
    public float steering;
    public float rotation;
    public float deltaRotation;
    public float rollInfluence;
    public float engineForce;
    public float brake;
    public boolean bIsFrontWheel;
    public Object clientInfo;
    public float clippedInvContactDotSuspension;
    public float suspensionRelativeVelocity;
    public float wheelsSuspensionForce;
    public float skidInfo;

    public WheelInfo(WheelInfoConstructionInfo wheelInfoConstructionInfo) {
        this.suspensionRestLength1 = wheelInfoConstructionInfo.suspensionRestLength;
        this.maxSuspensionTravelCm = wheelInfoConstructionInfo.maxSuspensionTravelCm;
        this.maxSuspensionForce = wheelInfoConstructionInfo.maxSuspensionForce;
        this.wheelsRadius = wheelInfoConstructionInfo.wheelRadius;
        this.suspensionStiffness = wheelInfoConstructionInfo.suspensionStiffness;
        this.wheelsDampingCompression = wheelInfoConstructionInfo.wheelsDampingCompression;
        this.wheelsDampingRelaxation = wheelInfoConstructionInfo.wheelsDampingRelaxation;
        this.chassisConnectionPointCS.set(wheelInfoConstructionInfo.chassisConnectionCS);
        this.wheelDirectionCS.set(wheelInfoConstructionInfo.wheelDirectionCS);
        this.wheelAxleCS.set(wheelInfoConstructionInfo.wheelAxleCS);
        this.frictionSlip = wheelInfoConstructionInfo.frictionSlip;
        this.steering = 0.0f;
        this.engineForce = 0.0f;
        this.rotation = 0.0f;
        this.deltaRotation = 0.0f;
        this.brake = 0.0f;
        this.rollInfluence = 0.1f;
        this.bIsFrontWheel = wheelInfoConstructionInfo.bIsFrontWheel;
    }

    public float getSuspensionRestLength() {
        return this.suspensionRestLength1;
    }

    public void updateWheel(RigidBody rigidBody, RaycastInfo raycastInfo) {
        if (raycastInfo.isInContact) {
            float f = raycastInfo.contactNormalWS.dot(raycastInfo.wheelDirectionWS);
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f2.sub(raycastInfo.contactPointWS, rigidBody.getCenterOfMassPosition((Vector3f)Pools.VECTORS.get()));
            rigidBody.getVelocityInLocalPoint(vector3f2, vector3f);
            float f2 = raycastInfo.contactNormalWS.dot(vector3f);
            if (f >= -0.1f) {
                this.suspensionRelativeVelocity = 0.0f;
                this.clippedInvContactDotSuspension = 10.0f;
            } else {
                float f3 = -1.0f / f;
                this.suspensionRelativeVelocity = f2 * f3;
                this.clippedInvContactDotSuspension = f3;
            }
        } else {
            raycastInfo.suspensionLength = this.getSuspensionRestLength();
            this.suspensionRelativeVelocity = 0.0f;
            raycastInfo.contactNormalWS.negate(raycastInfo.wheelDirectionWS);
            this.clippedInvContactDotSuspension = 1.0f;
        }
    }

    public static class RaycastInfo {
        public final Vector3f contactNormalWS = new Vector3f();
        public final Vector3f contactPointWS = new Vector3f();
        public float suspensionLength;
        public final Vector3f hardPointWS = new Vector3f();
        public final Vector3f wheelDirectionWS = new Vector3f();
        public final Vector3f wheelAxleWS = new Vector3f();
        public boolean isInContact;
        public Object groundObject;
    }
}

