/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.extras.gimpact.ClipPolygon;
import com.bulletphysics.util.ArrayPool;
import java.util.ArrayList;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class TriangleContact {
    private final ArrayPool<int[]> intArrays = ArrayPool.get(Integer.TYPE);
    public static final int MAX_TRI_CLIPPING = 16;
    public float penetration_depth;
    public int point_count;
    public final Vector4f separating_normal = new Vector4f();
    public Vector3f[] points = new Vector3f[16];

    public TriangleContact() {
        int n = 0;
        while (n < this.points.length) {
            this.points[n] = new Vector3f();
            ++n;
        }
    }

    public TriangleContact(TriangleContact triangleContact) {
        this.copy_from(triangleContact);
    }

    public void set(TriangleContact triangleContact) {
        this.copy_from(triangleContact);
    }

    public void copy_from(TriangleContact triangleContact) {
        this.penetration_depth = triangleContact.penetration_depth;
        this.separating_normal.set(triangleContact.separating_normal);
        int n = this.point_count = triangleContact.point_count;
        while (n-- != 0) {
            this.points[n].set(triangleContact.points[n]);
        }
    }

    public void merge_points(Vector4f vector4f, float f, ArrayList<Vector3f> arrayList, int n) {
        this.point_count = 0;
        this.penetration_depth = -1000.0f;
        int[] nArray = this.intArrays.getFixed(16);
        int n2 = 0;
        while (n2 < n) {
            float f2 = -ClipPolygon.distance_point_plane(vector4f, arrayList.get(n2)) + f;
            if (f2 >= 0.0f) {
                if (f2 > this.penetration_depth) {
                    this.penetration_depth = f2;
                    nArray[0] = n2;
                    this.point_count = 1;
                } else if (f2 + 1.1920929E-7f >= this.penetration_depth) {
                    nArray[this.point_count] = n2;
                    ++this.point_count;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.point_count) {
            this.points[n2].set(arrayList.get(nArray[n2]));
            ++n2;
        }
        this.intArrays.release(nArray);
    }
}

