/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ArrayPool<T> {
    private final Class componentType;
    private final ArrayList list = new ArrayList();
    private Comparator comparator;
    private final IntValue key = new IntValue();
    private static Comparator floatComparator = (object, object2) -> {
        int n;
        int n2 = object instanceof IntValue ? ((IntValue)object).value : ((float[])object).length;
        int n3 = n = object2 instanceof IntValue ? ((IntValue)object2).value : ((float[])object2).length;
        return n2 > n ? 1 : (n2 < n ? -1 : 0);
    };
    private static Comparator intComparator = (object, object2) -> {
        int n;
        int n2 = object instanceof IntValue ? ((IntValue)object).value : ((int[])object).length;
        int n3 = n = object2 instanceof IntValue ? ((IntValue)object2).value : ((int[])object2).length;
        return n2 > n ? 1 : (n2 < n ? -1 : 0);
    };
    private static Comparator objectComparator = (object, object2) -> {
        int n;
        int n2 = object instanceof IntValue ? ((IntValue)object).value : ((Object[])object).length;
        int n3 = n = object2 instanceof IntValue ? ((IntValue)object2).value : ((Object[])object2).length;
        return n2 > n ? 1 : (n2 < n ? -1 : 0);
    };
    private static ThreadLocal<Map> threadLocal = new ThreadLocal<Map>(){

        @Override
        protected Map initialValue() {
            return new HashMap();
        }
    };

    public ArrayPool(Class clazz) {
        this.componentType = clazz;
        if (clazz == Float.TYPE) {
            this.comparator = floatComparator;
        } else if (clazz == Integer.TYPE) {
            this.comparator = intComparator;
        } else if (!clazz.isPrimitive()) {
            this.comparator = objectComparator;
        } else {
            throw new UnsupportedOperationException("unsupported type " + String.valueOf(clazz));
        }
    }

    private T create(int n) {
        return (T)Array.newInstance(this.componentType, n);
    }

    public T getFixed(int n) {
        this.key.value = n;
        int n2 = Collections.binarySearch(this.list, this.key, this.comparator);
        if (n2 < 0) {
            return this.create(n);
        }
        return (T)this.list.remove(n2);
    }

    public T getAtLeast(int n) {
        this.key.value = n;
        int n2 = Collections.binarySearch(this.list, this.key, this.comparator);
        if (n2 < 0) {
            if ((n2 = -n2 - 1) < this.list.size()) {
                return (T)this.list.remove(n2);
            }
            return this.create(n);
        }
        return (T)this.list.remove(n2);
    }

    public void release(T t) {
        int n = Collections.binarySearch(this.list, t, this.comparator);
        if (n < 0) {
            n = -n - 1;
        }
        this.list.add(n, t);
        if (this.comparator == objectComparator) {
            Object[] objectArray = (Object[])t;
            int n2 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = null;
                ++n2;
            }
        }
    }

    public static <T> ArrayPool<T> get(Class clazz) {
        Map map = threadLocal.get();
        ArrayPool<T> arrayPool = (ArrayPool<T>)map.get(clazz);
        if (arrayPool == null) {
            arrayPool = new ArrayPool<T>(clazz);
            map.put(clazz, arrayPool);
        }
        return arrayPool;
    }

    public static void cleanCurrentThread() {
        threadLocal.remove();
    }

    private static class IntValue {
        public int value;

        private IntValue() {
        }
    }
}

