/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.RandomAccess;

public final class ObjectArrayList<T>
extends AbstractList<T>
implements RandomAccess,
Externalizable {
    private T[] array;
    private int size;

    public ObjectArrayList() {
        this(16);
    }

    public ObjectArrayList(int n) {
        this.array = new Object[n];
    }

    @Override
    public boolean add(T t) {
        if (this.size == this.array.length) {
            this.expand();
        }
        this.array[this.size++] = t;
        return true;
    }

    @Override
    public void add(int n, T t) {
        int n2;
        if (this.size == this.array.length) {
            this.expand();
        }
        if ((n2 = this.size - n) > 0) {
            System.arraycopy(this.array, n, this.array, n + 1, n2);
        }
        this.array[n] = t;
        ++this.size;
    }

    @Override
    public T remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        T t = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        this.array[this.size - 1] = null;
        --this.size;
        return t;
    }

    private void expand() {
        Object[] objectArray = new Object[this.array.length << 1];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    public void removeQuick(int n) {
        System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    @Override
    public T get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public T getQuick(int n) {
        return this.array[n];
    }

    @Override
    public T set(int n, T t) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        T t2 = this.array[n];
        this.array[n] = t;
        return t2;
    }

    public void setQuick(int n, T t) {
        this.array[n] = t;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int indexOf(Object object) {
        int n = this.size;
        T[] TArray = this.array;
        int n2 = 0;
        while (n2 < n) {
            if (object == null ? TArray[n2] == null : object.equals(TArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size);
        int n = 0;
        while (n < this.size) {
            objectOutput.writeObject(this.array[n]);
            ++n;
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.size = objectInput.readInt();
        int n = 16;
        while (n < this.size) {
            n <<= 1;
        }
        this.array = new Object[n];
        int n2 = 0;
        while (n2 < this.size) {
            this.array[n2] = objectInput.readObject();
            ++n2;
        }
    }
}

