/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;

public class NativeUtils {
    private static final int MIN_PREFIX_LENGTH = 3;
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static File temporaryDir;

    private NativeUtils() {
    }

    public static void loadLibraryFromJar(String string) throws IOException {
        String string2;
        if (string == null || !string.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] stringArray = string.split("/");
        String string3 = string2 = stringArray.length > 1 ? stringArray[stringArray.length - 1] : null;
        if (string2 == null || string2.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtils.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            temporaryDir.deleteOnExit();
        }
        File file = new File(temporaryDir, string2);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream inputStream = NativeUtils.class.getResourceAsStream(string);){
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            file.delete();
            throw new FileNotFoundException("File " + string + " was not found in the plugin.");
        }
        try {
            System.load(file.getAbsolutePath());
        }
        finally {
            if (NativeUtils.isPosixCompliant()) {
                file.delete();
            } else {
                file.deleteOnExit();
            }
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException runtimeException) {
            return false;
        }
    }

    private static File createTempDirectory(String string) throws IOException {
        String string2 = System.getProperty("java.io.tmpdir");
        File file = new File(string2, string + System.nanoTime());
        if (!file.mkdir()) {
            throw new IOException("Failed to create temp directory " + file.getName());
        }
        return file;
    }
}

