/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.box2d_version;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.extension.physics.box2d_version.Box2DBodyWrapper;
import gama.extension.physics.box2d_version.Box2DShapeConverter;
import gama.extension.physics.box2d_version.IBox2DPhysicalEntity;
import gama.extension.physics.common.AbstractPhysicalWorld;
import gama.extension.physics.common.IBody;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.gaml.PhysicalSimulationAgent;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.World;

public class Box2DPhysicalWorld
extends AbstractPhysicalWorld<World, Shape, Vec2>
implements IBox2DPhysicalEntity {
    float scale;
    static float TARGET = 10.0f;

    public Box2DPhysicalWorld(PhysicalSimulationAgent physicalSimulationAgent) {
        super(physicalSimulationAgent);
        double d = physicalSimulationAgent.getWidth();
        double d2 = physicalSimulationAgent.getHeight();
        this.scale = (float)((double)TARGET / Math.max(d, d2));
    }

    @Override
    public void registerAgent(IAgent iAgent) {
        new Box2DBodyWrapper(iAgent, this);
    }

    @Override
    public void unregisterAgent(IAgent iAgent) {
        Body body = (Body)((Box2DBodyWrapper)iAgent.getAttribute((String)"%%rigid_body%%")).body;
        ((World)this.getWorld()).destroyBody(body);
    }

    @Override
    public void setCCD(boolean bl) {
    }

    @Override
    public void setGravity(GamaPoint gamaPoint) {
        if (this.world != null) {
            ((World)this.world).setGravity((Vec2)this.toVector(gamaPoint));
        }
    }

    @Override
    public void dispose() {
        if (this.world != null) {
            Body body = ((World)this.world).getBodyList();
            while (body != null) {
                ((World)this.world).destroyBody(body);
                body = body.getNext();
            }
            this.world = null;
        }
    }

    @Override
    public void updatePositionsAndRotations() {
        if (this.world == null) {
            return;
        }
        Body body = ((World)this.world).getBodyList();
        while (body != null) {
            IBody iBody = (IBody)body.getUserData();
            if (body.isActive()) {
                iBody.transferLocationAndRotationToAgent();
            }
            body = body.getNext();
        }
    }

    @Override
    protected World createWorld() {
        GamaPoint gamaPoint = this.simulation.getGravity(this.simulation.getScope());
        World world = new World((Vec2)this.toVector(gamaPoint));
        world.setAutoClearForces(true);
        world.setContactListener(this.contactListener);
        return world;
    }

    @Override
    protected IShapeConverter<Shape, Vec2> createShapeConverter() {
        return new Box2DShapeConverter(this.scale);
    }

    @Override
    protected void updateAgentsShape() {
        for (IAgent iAgent : this.updatableAgents) {
            this.unregisterAgent(iAgent);
        }
        for (IAgent iAgent : this.updatableAgents) {
            this.registerAgent(iAgent);
        }
        this.updatableAgents.clear();
    }

    @Override
    protected void updateEngine(Double d, int n) {
        int n2 = n == 0 ? 1 : n;
        ((World)this.getWorld()).step(d.floatValue(), n2, n2);
    }

    @Override
    public float getScale() {
        return this.scale;
    }
}

